/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.subsystem.power.PowerControl;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class PowerDeviceGroup {
    private static final Map<DriverConstants.ConnType, Power.ConnType> cTypeMap = new HashMap<DriverConstants.ConnType, Power.ConnType>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private final Map<String, PowerControl> controlsMap = new LinkedHashMap<String, PowerControl>();
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private PowerDevice device;

    public Power getPowerConfig() {
        Power power = new Power();
        power.setName(this.device.getName());
        power.setConnType(cTypeMap.get(this.device.getConnType()));
        power.setDevcId(this.device.getDevcId());
        power.setDevcParm(this.device.getDevcParm());
        Power.Channel[] chans = new Power.Channel[this.controlsMap.size()];
        int j = 0;
        for (PowerControl ctl : this.controlsMap.values()) {
            chans[j++] = ctl.getConfig();
        }
        power.setChannels(chans);
        return power;
    }

    public void setPowerConfig(Power power) throws PowerException {
        for (Power.Channel chan : power.getChannels()) {
            String cName = this.device.getName() + "." + chan.getName();
            this.controlsMap.get(cName).setConfig(chan);
        }
    }

    protected List<PowerChanState> getPowerState() {
        this.device.readVoltageGroup();
        this.device.readCurrentGroup();
        this.device.readOutputGroup();
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (PowerControl ctl : this.controlsMap.values()) {
            pState.add(ctl.getState());
        }
        return pState;
    }

    protected void powerOn() throws PowerException {
        for (PowerControl ctl : this.controlsMap.values()) {
            ctl.writeAll();
        }
        try {
            this.device.writeVoltageGroup();
            this.device.writeCurrentGroup();
            this.device.writeOnDelayGroup();
            this.device.writeOffDelayGroup();
        }
        catch (DriverException e) {
            this.device.handleException(e);
        }
        this.setOutput(true);
    }

    protected void waitPowerOn(int timeout) throws PowerException {
        this.waitOutputSet(true, timeout);
    }

    protected void powerOff() throws PowerException {
        this.setOutput(false);
    }

    protected void waitPowerOff(int timeout) throws PowerException {
        this.waitOutputSet(false, timeout);
    }

    private void setOutput(boolean value) throws PowerException {
        try {
            for (PowerControl ctl : this.controlsMap.values()) {
                this.device.writeOutput(value, ctl.getHwChan());
            }
            this.device.writeOutputGroup();
        }
        catch (DriverException e) {
            this.device.handleException(e);
        }
    }

    private void waitOutputSet(boolean value, int timeout) throws PowerException {
        if (timeout <= 0) {
            return;
        }
        long maxTime = System.currentTimeMillis() + (long)timeout;
        try {
            this.device.readOutputGroup();
            for (PowerControl ctl : this.controlsMap.values()) {
                while (System.currentTimeMillis() <= maxTime) {
                    if (value == this.device.readOutput(ctl.getHwChan())) {
                        return;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            throw new DriverTimeoutException("Output wait timeout");
        }
        catch (DriverException e) {
            this.device.handleException(e);
            return;
        }
    }

    static {
        cTypeMap.put(DriverConstants.ConnType.NET, Power.ConnType.Network);
        cTypeMap.put(DriverConstants.ConnType.SERIAL, Power.ConnType.Serial);
    }
}

