/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;

public class MCMConfig {
    @ConfigurationParameter
    private volatile boolean hasFilterChanger = true;
    @ConfigurationParameter
    private volatile int maxImagesPerSequence = 10;
    @ConfigurationParameter(units="seconds")
    private volatile double minExposeTime = 1.0;
    @ConfigurationParameter(units="seconds")
    private volatile double maxExposeTime = 30.0;
    @ConfigurationParameter
    private volatile String focalPlaneSubsystemName;
    @ConfigurationParameter
    private volatile String shutterSubsystemName;
    @ConfigurationParameter
    private volatile String filterChangerSubsystemName;
    @ConfigurationParameter
    private volatile Camera cameraType = Camera.MAIN_CAMERA;
    @ConfigurationParameter(maxLength=100)
    private volatile Set<String> requiredKeywords = new HashSet<String>(Arrays.asList("imageType", "groupId"));
    @ConfigurationParameter(maxLength=100)
    private volatile Set<String> allowedKeywords = new HashSet<String>(Arrays.asList("testType"));
    @ConfigurationParameter(description="List of additional subsystems which need to have their configuration broadcast", maxLength=100)
    private volatile Set<String> otherSubsystems;
    @ConfigurationParameter(description="Time for shutter to prepare to move. If zero then no preparation time is needed", units="seconds")
    private volatile double shutterPrepTime = 0.15;
    @ConfigurationParameter(description="Controls whether we always command focal-plane to do a clear on all images")
    private volatile boolean alwaysClear = false;

    MCMConfig() {
    }

    public MCMConfig(Camera cameraType) {
        this.cameraType = cameraType;
    }

    public boolean hasFilterChanger() {
        return this.hasFilterChanger;
    }

    public String getFocalPlaneSubsystemName() {
        return this.focalPlaneSubsystemName;
    }

    boolean hasFocalPlaneSubsystem() {
        return this.getFocalPlaneSubsystemName() != null && !this.getFocalPlaneSubsystemName().trim().isEmpty();
    }

    public String getShutterSubsystemName() {
        return this.shutterSubsystemName;
    }

    String getFilterChangerSubsystemName() {
        return this.filterChangerSubsystemName;
    }

    public int getMaxImagesPerSequence() {
        return this.maxImagesPerSequence;
    }

    public double getMinExposeTime() {
        return this.minExposeTime;
    }

    public double getMaxExposeTime() {
        return this.maxExposeTime;
    }

    public Camera getCameraType() {
        return this.cameraType;
    }

    Set<String> getRequiredKeys() {
        return this.requiredKeywords;
    }

    Set<String> getAllowedKeys() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.requiredKeywords);
        result.addAll(this.allowedKeywords);
        return result;
    }

    Set<String> getOtherSubsystems() {
        return this.otherSubsystems;
    }

    public static MCMConfig createDefaultConfig() {
        return new MCMConfig();
    }

    public static MCMConfig createNewDefaultConfig() {
        MCMConfig mcmConfig = new MCMConfig();
        mcmConfig.alwaysClear = true;
        mcmConfig.shutterPrepTime = 0.0;
        return mcmConfig;
    }

    public double getShutterPrepTime() {
        return this.shutterPrepTime;
    }

    boolean isAlwaysClear() {
        return this.alwaysClear;
    }
}

