/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class AtsCryoCon24cDevice
extends Device {
    public static final int CHAN_HTR_1 = 0;
    public static final int CHAN_HTR_2 = 1;
    public static final int CHAN_TEMP_A = 2;
    public static final int CHAN_TEMP_B = 3;
    public static final int CHAN_TEMP_C = 4;
    public static final int CHAN_TEMP_D = 5;
    public static final int CHAN_PID_P_1 = 6;
    public static final int CHAN_PID_I_1 = 7;
    public static final int CHAN_PID_D_1 = 8;
    public static final int CHAN_PID_P_2 = 9;
    public static final int CHAN_PID_I_2 = 10;
    public static final int CHAN_PID_D_2 = 11;
    public static final int CHAN_SETPOINT_1 = 12;
    public static final int CHAN_SETPOINT_2 = 13;
    public static final int NUM_CHANS = 14;
    @ConfigurationParameter(category="Device")
    volatile String host;
    DriverConstants.ConnType connType = DriverConstants.ConnType.NET;
    int port = 5000;
    private static final Logger LOG = Logger.getLogger(AtsCryoCon24cDevice.class.getName());
    private final M24C m24c = new M24C();
    private boolean initError = false;

    protected void initDevice() {
        if (this.host == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"host", (String)"is not specified");
        }
        this.fullName = "Cryocon M24C (" + this.host + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.m24c.open(this.connType, this.host, this.port);
                this.setOnline(true);
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    public void close() {
        try {
            this.m24c.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        String name = ch.getName();
        if (hwChan < 0 || hwChan >= 14) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        int chan = ch.getHwChan();
        double value = 0.0;
        try {
            switch (chan) {
                case 0: {
                    value = this.m24c.getHtrRead(1);
                    break;
                }
                case 1: {
                    value = this.m24c.getHtrRead(2);
                    break;
                }
                case 2: {
                    value = this.getTemp("A");
                    break;
                }
                case 3: {
                    value = this.getTemp("B");
                    break;
                }
                case 4: {
                    value = this.getTemp("C");
                    break;
                }
                case 5: {
                    value = this.getTemp("D");
                    break;
                }
                case 6: {
                    value = this.m24c.getPidP(1);
                    break;
                }
                case 7: {
                    value = this.m24c.getPidI(1);
                    break;
                }
                case 8: {
                    value = this.m24c.getPidD(1);
                    break;
                }
                case 9: {
                    value = this.m24c.getPidP(2);
                    break;
                }
                case 10: {
                    value = this.m24c.getPidI(2);
                    break;
                }
                case 11: {
                    value = this.m24c.getPidD(2);
                    break;
                }
                case 12: {
                    value = this.m24c.getSetPoint(1);
                    break;
                }
                case 13: {
                    value = this.m24c.getSetPoint(2);
                }
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading channel {0}: {1}", new Object[]{chan, e});
            this.setOnline(false);
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, description="Show Temp Control 24C identification")
    public String showIdentification() throws DriverException {
        String[] ident = this.m24c.getIdentification();
        return "Manufacturer:  " + ident[0] + "\nModel name:    " + ident[1] + "\nSerial number: " + ident[2] + "\nF/W version:   " + ident[3];
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getMaxSetPoint(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSetPoint(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve heater reading for loop")
    public double getHtrRead(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHtrRead(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve PID parameter P for loop")
    public double getPidP(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPidP(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve PID parameter I for loop")
    public double getPidI(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPidI(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve PID parameter D for loop")
    public double getPidD(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPidD(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSource(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Get heater range for loop")
    public String getHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterRange(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Get maximum heater power for loop")
    public double getHeaterMax(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterMax(loop);
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve temperature info")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getTemp(channel.charAt(0));
    }

    @Command(type=Command.CommandType.QUERY, description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getUnit(channel.charAt(0));
    }

    @Command(type=Command.CommandType.QUERY, description="Get sensor type")
    public String getType(@Argument(name="channel", description="Temp Channel to set") String channel) throws DriverException {
        return this.m24c.getType(channel.charAt(0));
    }

    @Command(type=Command.CommandType.QUERY, description="Get whether OTD system enabled")
    public boolean isOtdEnabled() throws DriverException {
        return this.m24c.isOtdEnabled();
    }

    @Command(type=Command.CommandType.QUERY, description="Get source channel for the OTD system")
    public char getOtdSource() throws DriverException {
        return this.m24c.getOtdSource();
    }

    @Command(type=Command.CommandType.QUERY, description="Get temperature limit for the OTD system")
    public double getOtdTemp() throws DriverException {
        return this.m24c.getOtdTemp();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the CryoCon24c into control mode")
    public void setToControl() throws DriverException {
        this.m24c.setToControl();
    }

    @Command(type=Command.CommandType.ACTION, description="Stop the CryoCon24c control mode")
    public void stopControl() throws DriverException {
        this.m24c.stopControl();
    }

    @Command(type=Command.CommandType.QUERY, description="Is the CryoCon24c in control mode")
    public boolean isInControl() throws DriverException {
        return this.m24c.isInControl();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the control type for a loop")
    public void setControlType(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(description="control type (OFF, MAN or PID)") ControlType type) throws DriverException {
        this.m24c.setControlType(loop, type.name());
    }

    @Command(type=Command.CommandType.QUERY, description="Set the control type for a loop")
    public String getControlType(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getControlType(loop);
    }

    @Command(type=Command.CommandType.ACTION, description="Set the manual heater power for a loop")
    public void setHeaterPower(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(description="power as % of maximum") double power) throws DriverException {
        this.m24c.setHeaterPower(loop, power);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the manual heater power for a loop")
    public double getHeaterPower(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterPower(loop);
    }

    public static enum ControlType {
        OFF,
        MAN,
        PID;

    }
}

