/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;

public class SALClassDescriptionMaker {
    private final Map<String, SALClassDescription> SALClassMap = new TreeMap<String, SALClassDescription>();
    private static final boolean SALCLASS_DESCRIPTION_MAKER_DEBUG = false;

    public SALClassDescriptionMaker(DataProviderDictionary dataProviderDictionary, String cscName, String subsystemName, int level, Mapping mapping, String attributeType, String resultType) {
        boolean trending = "MONITORING".equals(attributeType);
        List dpInfoList = dataProviderDictionary.getDataProviderInfos();
        for (DataProviderInfo dpi : dpInfoList) {
            Mapping.Match match;
            String originalPathName;
            String category;
            if (!dpi.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE).trim().equals(attributeType)) continue;
            String type = dpi.getAttributeValue(DataProviderInfo.Attribute.TYPE);
            String description = dpi.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION);
            String units = dpi.getAttributeValue(DataProviderInfo.Attribute.UNITS);
            String string = category = trending ? "" : dpi.getAttributeValue(DataProviderInfo.Attribute.CONFIG_CATEGORY);
            if (trending) {
                type = "double";
            }
            if ((originalPathName = dpi.getAttributeValue(DataProviderInfo.Attribute.PUBLISHED_PATH)) == null) {
                originalPathName = dpi.getFullPath().replace("main/", "").trim();
            }
            if (!trending && !originalPathName.contains("/")) {
                originalPathName = "/" + originalPathName;
            }
            if ((match = mapping.match(originalPathName)) != null) {
                String rawSALClassParameterName = match.getPatternName() + "/" + match.getPathAfterMatch();
                String salClassParameterName = this.makeSALClassParameterName(rawSALClassParameterName.trim(), level);
                String associatedClassName = this.makeSALClassName(level, cscName, subsystemName, resultType, rawSALClassParameterName, category);
                SALClassDescription salClassDescription = this.SALClassMap.computeIfAbsent(associatedClassName, name -> new SALClassDescription(associatedClassName, level, category));
                SALClassDescription.BusVariable busVariable = new SALClassDescription.BusVariable(originalPathName);
                SALClassDescription.SALVariable existingVariable = salClassDescription.getVariable(salClassParameterName);
                if (existingVariable instanceof SALClassDescription.PatternMatchedSALVariable) {
                    ((SALClassDescription.PatternMatchedSALVariable)existingVariable).addBusVariable(busVariable);
                    continue;
                }
                String locationVariableName = match.getPatternName() + "Location";
                SALClassDescription.LocationVariable locationVariable = (SALClassDescription.LocationVariable)salClassDescription.getVariable(locationVariableName);
                if (locationVariable == null) {
                    locationVariable = new SALClassDescription.LocationVariable(locationVariableName, match.getPatternName() + " location");
                    salClassDescription.add(locationVariable);
                }
                SALClassDescription.PatternMatchedSALVariable var = new SALClassDescription.PatternMatchedSALVariable(match.getPatternName(), match.getLocation(), locationVariable, salClassParameterName, type, units, description);
                var.addBusVariable(busVariable);
                salClassDescription.add(var);
                continue;
            }
            String associatedClassName = this.makeSALClassName(level, cscName, subsystemName, resultType, originalPathName, category);
            SALClassDescription salClassDescription = this.SALClassMap.computeIfAbsent(associatedClassName, name -> new SALClassDescription(associatedClassName, level, category));
            SALClassDescription.BusVariable busVariable = new SALClassDescription.BusVariable(originalPathName);
            SALClassDescription.SimpleSALVariable var = new SALClassDescription.SimpleSALVariable(this.makeSALClassParameterName(originalPathName, level), type, units, description, busVariable);
            salClassDescription.add(var);
        }
        for (SALClassDescription classDescription : this.SALClassMap.values()) {
            List locationVariables = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).collect(Collectors.toList());
            if (locationVariables.size() != 1) continue;
            SALClassDescription.SALVariable theLocationVariable = (SALClassDescription.SALVariable)locationVariables.get(0);
            classDescription.renameVariable(theLocationVariable, "location");
        }
    }

    public Map<String, SALClassDescription> getSALClassDescriptions() {
        return this.SALClassMap;
    }

    String makeSALClassName(int level, String cscName, String subsystemName, String salType, String path, String category) {
        if (cscName.toLowerCase().contains("comcam")) {
            cscName = "CCCamera";
        }
        String subsystemAndComponent = "";
        if (!cscName.isEmpty()) {
            subsystemAndComponent = cscName.substring(0, 1).toUpperCase() + cscName.substring(1);
        }
        if (!(subsystemName = subsystemName.trim()).isEmpty()) {
            subsystemAndComponent = subsystemAndComponent + "_" + subsystemName.substring(0, 1).toLowerCase() + subsystemName.substring(1);
        }
        String className = salType.toLowerCase().contains("settingsapplied") ? cscName + "_logevent_" + subsystemName.toLowerCase() : subsystemAndComponent;
        if (path.contains("main/")) {
            path = path.replace("main/", "");
            className = subsystemAndComponent;
        } else {
            for (int i = 0; i < level; ++i) {
                String pathComponentI = path.split("/")[i];
                if (pathComponentI.length() <= 0) continue;
                className = className + "_" + SALClassDescriptionMaker.capitalize(pathComponentI);
            }
        }
        if (category != null && !category.isEmpty()) {
            className = className + "_" + category;
        }
        if (className.endsWith("_")) {
            className = className.substring(0, className.length() - 1);
        }
        return className;
    }

    final String makeSALClassParameterName(String path, int level) {
        path = path.replace("main/", "");
        int pathLength = path.split("/").length;
        String variableName = "";
        if ((path = path.replaceAll("-", "_")).contains("/")) {
            if (level <= pathLength) {
                for (int i = level; i < pathLength; ++i) {
                    variableName = variableName + "_" + path.split("/")[i];
                }
                if (variableName.startsWith("_")) {
                    variableName = variableName.substring(1);
                }
            } else {
                System.out.println("!!You have specified level to be longer than the variable path + name!!");
                System.exit(-1);
            }
        } else {
            variableName = path;
        }
        return SALClassDescriptionMaker.uncapitalize(variableName).trim();
    }

    public static String capitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toUpperCase() + in.substring(1);
        }
        return in.toUpperCase();
    }

    public static String uncapitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toLowerCase() + in.substring(1);
        }
        return in.toLowerCase();
    }
}

