/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;

public class IntFileChannelReader
implements ReadableIntChannel {
    private final FileChannel channel;
    private long position;
    private int length;
    private ByteBuffer bb = ByteBuffer.allocateDirect(1000000);
    private IntBuffer ib = this.bb.asIntBuffer();

    IntFileChannelReader(FileChannel channel, long position, int length) throws IOException {
        this.channel = channel;
        this.position = position;
        this.length = length;
        this.ib.flip();
    }

    @Override
    public int read() throws IOException {
        while (!this.ib.hasRemaining()) {
            int intsRead = this.fillBuffer();
            if (intsRead >= 0) continue;
            throw new EOFException();
        }
        return this.ib.get();
    }

    @Override
    public int read(IntBuffer buffer) throws IOException {
        while (!this.ib.hasRemaining()) {
            int intsRead = this.fillBuffer();
            if (intsRead >= 0) continue;
            return intsRead;
        }
        int remaining = this.ib.remaining();
        if (remaining > buffer.remaining()) {
            int oldLimit = this.ib.limit();
            this.ib.limit(this.ib.position() + buffer.remaining());
            buffer.put(this.ib);
            this.ib.limit(oldLimit);
        } else {
            buffer.put(this.ib);
        }
        return remaining - this.ib.remaining();
    }

    @Override
    public boolean isOpen() {
        return this.bb != null;
    }

    @Override
    public void close() throws IOException {
        this.ib = null;
        this.bb = null;
    }

    private int fillBuffer() throws IOException {
        int bytesRead;
        this.bb.clear();
        if (this.length < this.bb.capacity()) {
            this.bb.limit(this.length);
        }
        if ((bytesRead = this.channel.read(this.bb, this.position)) <= 0) {
            return -1;
        }
        this.position += (long)bytesRead;
        this.length -= bytesRead;
        this.ib.position(0);
        this.ib.limit(bytesRead / 4);
        return bytesRead / 4;
    }
}

