/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class MCMSubsystem
extends Subsystem
implements HasLifecycle {
    private final CCS ccs = new CCS();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MCMConfig config;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    private MCM mcm;

    public MCMSubsystem() {
        super("mcm", AgentInfo.AgentType.MCM);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void init() {
        this.agentStateService.registerState(Shutter.ShutterState.class, "Shutter state", (Object)this);
        this.agentStateService.registerState(MCM.TakeImageReadinessState.class, "Image readiness State", (Object)this);
        this.agentStateService.registerState(FilterChanger.FilterState.class, "Filter State", (Object)this);
        this.agentStateService.registerState(MCM.CalibrationState.class, "Calibration State", (Object)this);
        this.agentStateService.registerState(Shutter.ShutterReadinessState.class, "Shutter readiness State", (Object)this);
        this.agentStateService.registerState(FocalPlane.RaftsState.class, "Focal plane state", (Object)this);
        this.agentStateService.registerState(MCM.StandbyState.class, "Standby state", (Object)this);
    }

    public void postStart() {
        this.mcm = new MCM(this.ccs, this.config, this.imageNameService);
        this.mcm.registerMCMSubsystem(this);
        if (this.config.hasFocalPlaneSubsystem()) {
            this.mcm.getFocalPlane().registerMCMSubsystem(this);
        }
        if (this.config.getShutterSubsystemName() != null && !this.config.getShutterSubsystemName().trim().isEmpty()) {
            this.mcm.getShutter().registerMCMSubsystem(this);
        }
        if (this.config.hasFilterChanger() && this.config.getFilterChangerSubsystemName() != null && !this.config.getFilterChangerSubsystemName().trim().isEmpty()) {
            this.mcm.getFilterChanger().registerMCMSubsystem(this);
        }
        this.ccs.addStateChangeListener((when, state, oldState) -> this.agentStateService.updateAgentState(when, new Enum[]{state}));
        ArrayList initialStates = new ArrayList();
        this.ccs.getAggregateStatus().getStates().forEach(state -> initialStates.add(state.getState()));
        this.agentStateService.updateAgentState(initialStates.toArray(new Enum[initialStates.size()]));
        this.ccs.addStatusMessageListener(msg -> this.getMessagingAccess().sendStatusMessage(msg));
        this.ccs.addEventListener(event -> this.publishSubsystemDataOnStatusBus(new KeyValueData("CCSEvent", (Serializable)event)));
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initImage(@Argument(description="Time in seconds") double delta) throws Exception {
        CCSCommand.CCSInitImageCommand initImage = new CCSCommand.CCSInitImageCommand(delta);
        this.executeAndHandleResponse(initImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void startImage(boolean shutter, String sensors, String keyValueData, String annotation, double timeout) throws Exception {
        CCSCommand.CCSStartImageCommand startImage = new CCSCommand.CCSStartImageCommand(shutter, sensors, keyValueData, annotation, timeout);
        this.executeAndHandleResponse(startImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void takeImages(double expTime, int numImages, boolean shutter, String sensors, String keyValueData, String annotation) throws Exception {
        CCSCommand.CCSTakeImagesCommand takeImages = new CCSCommand.CCSTakeImagesCommand(expTime, numImages, shutter, sensors, keyValueData, annotation);
        this.executeAndHandleResponse(takeImages);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setFilter(String name) throws Exception {
        CCSCommand.CCSSetFilterCommand setFilter = new CCSCommand.CCSSetFilterCommand(name);
        this.executeAndHandleResponse(setFilter);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initGuiders(String roiSpec) throws Exception {
        CCSCommand.CCSInitGuidersCommand initGuiders = new CCSCommand.CCSInitGuidersCommand(roiSpec);
        this.executeAndHandleResponse(initGuiders);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void endImage() throws Exception {
        CCSCommand.CCSEndImageCommand endImage = new CCSCommand.CCSEndImageCommand();
        this.executeAndHandleResponse(endImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clear(int nClears) throws Exception {
        CCSCommand.CCSClearCommand clear = new CCSCommand.CCSClearCommand(nClears);
        this.executeAndHandleResponse(clear);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void play(String playlist, @Argument(defaultValue="false") boolean repeat) throws Exception {
        CCSCommand.CCSPlayCommand play = new CCSCommand.CCSPlayCommand(playlist, repeat);
        this.executeAndHandleResponse(play);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void definePlaylist(String playlist, String daqFolder, String ... images) throws Exception {
        CCSCommand.CCSDefinePlaylistCommand definePlaylist = new CCSCommand.CCSDefinePlaylistCommand(playlist, daqFolder, images);
        this.executeAndHandleResponse(definePlaylist);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void discardRows(int nRows) throws Exception {
        CCSCommand.CCSDiscardRowsCommand discardRows = new CCSCommand.CCSDiscardRowsCommand(nRows);
        this.executeAndHandleResponse(discardRows);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void start(String configuration) throws Exception {
        CCSCommand.CCSStartCommand start = new CCSCommand.CCSStartCommand(configuration);
        this.executeAndHandleResponse(start);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void standby() throws Exception {
        CCSCommand.CCSStandbyCommand standby = new CCSCommand.CCSStandbyCommand();
        this.executeAndHandleResponse(standby);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void enableCalibration() throws Exception {
        CCSCommand.CCSEnableCalibrationCommand enableCalibration = new CCSCommand.CCSEnableCalibrationCommand();
        this.executeAndHandleResponse(enableCalibration);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void disableCalibration() throws Exception {
        CCSCommand.CCSDisableCalibrationCommand disableCalibration = new CCSCommand.CCSDisableCalibrationCommand();
        this.executeAndHandleResponse(disableCalibration);
    }

    private void executeAndHandleResponse(CCSCommand command) throws Exception {
        CCSCommand.CCSCommandResponse response = this.mcm.execute(command);
        CCSCommand.CCSAckOrNack can = response.waitForAckOrNack();
        if (can.isNack()) {
            this.sendNack((Serializable)((Object)can.getReason()));
        } else {
            this.sendAck(can.getDuration().plus(Duration.ofMillis(1000L)));
            response.waitForCompletion();
        }
    }
}

