/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.Arrays;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.AsciiString;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class SiteUUID
extends ExtendedUUID
implements SiteAddress {
    protected static final byte[] NAME = Util.stringToBytes("relay2.name");
    protected static final byte[] SITE_NAME = Util.stringToBytes("relay2.site");

    public SiteUUID() {
    }

    public SiteUUID(long mostSigBits, long leastSigBits, String name, String site) {
        super(mostSigBits, leastSigBits);
        if (name != null) {
            this.put(NAME, Util.stringToBytes(name));
        }
        this.put(SITE_NAME, Util.stringToBytes(site));
    }

    public SiteUUID(long mostSigBits, long leastSigBits, byte[] name, byte[] site) {
        super(mostSigBits, leastSigBits);
        if (name != null) {
            this.put(NAME, name);
        }
        this.put(SITE_NAME, site);
    }

    public SiteUUID(UUID uuid, String name, String site) {
        super(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        if (name != null) {
            this.put(NAME, Util.stringToBytes(name));
        }
        this.put(SITE_NAME, Util.stringToBytes(site));
    }

    @Override
    public Supplier<? extends UUID> create() {
        return SiteUUID::new;
    }

    public String getName() {
        return Util.bytesToString(this.get(NAME));
    }

    @Override
    public String getSite() {
        return Util.bytesToString(this.get(SITE_NAME));
    }

    @Override
    public UUID copy() {
        return new SiteUUID(this.mostSigBits, this.leastSigBits, this.get(NAME), this.get(SITE_NAME));
    }

    @Override
    public String toString() {
        return this.print(false);
    }

    @Override
    public int compareTo(Address other) {
        if (other instanceof SiteUUID) {
            int siteCompare = Util.compare(this.get(SITE_NAME), ((SiteUUID)other).get(SITE_NAME));
            return siteCompare == 0 ? super.compareTo(other) : siteCompare;
        }
        return super.compareTo(other);
    }

    public String print(boolean detailed) {
        String name = this.getName();
        String retval = name != null ? name : NameCache.get(this);
        return retval + ":" + this.getSite() + (detailed ? this.printOthers() : "");
    }

    protected String printOthers() {
        StringBuilder sb = new StringBuilder();
        if (this.flags != 0) {
            sb.append(" flags=" + this.flags + " (" + this.flags + ")");
        }
        if (this.keys == null) {
            return sb.toString();
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] key = this.keys[i];
            if (key == null || Arrays.equals(key, SITE_NAME) || Arrays.equals(key, NAME)) continue;
            byte[] val = this.values[i];
            String obj = null;
            try {
                obj = Util.bytesToString(val);
            }
            catch (Throwable t) {
                obj = val != null ? val.length + " bytes" : null;
            }
            sb.append(", ").append(new AsciiString(key)).append("=").append((Object)obj);
        }
        return sb.toString();
    }
}

