/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.CCSVersions;
import org.lsst.ccs.services.AgentVersionsService;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.sal.camera.event.SoftwareVersionsEvent;

class SoftwareVersionsGenerator {
    private final Agent agent;
    private final OCSBridge ocsBridge;

    SoftwareVersionsGenerator(OCSBridge ocsBridge, Agent agent) {
        this.ocsBridge = ocsBridge;
        this.agent = agent;
    }

    void run(boolean fullVersions) {
        AgentInfo agentInfo = this.agent.getAgentInfo();
        CCSVersions ccsVersions = ((AgentVersionsService)this.agent.getAgentService(AgentVersionsService.class)).getCCSVersions();
        String cscVersion = ccsVersions.getDistributionInfo(agentInfo).getVersion();
        String subsystemVersions = ccsVersions.getAgents().stream().filter(a -> a.isAgentWorkerOrService()).filter(a -> !a.equals((Object)this.agent.getAgentInfo())).map(a -> a.getName() + "=" + ccsVersions.getDistributionInfo(a).getVersion()).collect(Collectors.joining(","));
        OCSCommandExecutor oce = this.ocsBridge.getOcsCommandExecutor();
        SoftwareVersionsEvent sve = new SoftwareVersionsEvent(1, oce.getSALVersion(), oce.getXMLVersion(), oce.getOSPLVersion(), cscVersion, fullVersions ? subsystemVersions : "");
        this.ocsBridge.getOcsCommandExecutor().sendEvent(sve);
    }
}

