/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.agilent.DL34970;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestDL34970
extends TestScpi {
    private final DL34970 dl;

    public TestDL34970() {
        super(new DL34970());
        this.dl = (DL34970)this.scpi;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type") DriverConstants.ConnType connType, @Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.dl.open(connType, ident);
    }

    @Command(name="configtc", description="Configure for a thermocouple")
    public void configTC(@Argument(name="type", description="TC type") DL34970.TcType type, int ... chans) throws DriverException {
        this.dl.configTC(type, chans);
    }

    @Command(name="configvolts", description="Configure for a voltage")
    public void configVolts(@Argument(name="range", description="Voltage range") double range, int ... chans) throws DriverException {
        this.dl.configVolts(range, chans);
    }

    @Command(name="configcurrent", description="Configure for a current")
    public void configCurrent(@Argument(name="range", description="Current range") double range, int ... chans) throws DriverException {
        this.dl.configCurrent(range, chans);
    }

    @Command(name="setscanlist", description="Set the scan list")
    public void setScanList(int ... chans) throws DriverException {
        this.dl.setScanList(chans);
    }

    @Command(name="readdata", description="Reads data from channels")
    public String readData(int ... chans) throws DriverException {
        if (chans.length == 1) {
            return "Value = " + this.dl.readData(chans[0]);
        }
        double[] data = chans.length == 0 ? this.dl.readData() : this.dl.readData(chans);
        StringBuilder text = new StringBuilder("Values =");
        for (double value : data) {
            text.append(' ').append(value);
        }
        return text.toString();
    }
}

