/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Measurement;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.PIDController;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class TempControl
implements HasLifecycle {
    private static final String TEMP_CONTROL_CATEGORY = "RaftTempControl";
    private static final String TEMP_CONTROL_STATUS_CATEGORY = "RaftTempControlStatus";
    private static final Logger LOG = Logger.getLogger(TempControl.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupName
    private String name;
    @LookupPath
    private String path;
    private String raftPath;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private final Map<String, REBDevice> allRebs = new HashMap<String, REBDevice>();
    @ConfigurationParameter(category="RaftTempControlStatus", description="True if loop is active", units="unitless")
    private volatile boolean active = false;
    @ConfigurationParameter(category="RaftTempControl", description="maximum PID output", units="Watt")
    private volatile double maxOutput = 5.6;
    @ConfigurationParameter(category="RaftTempControl", description="Temperature set point", units="C")
    private volatile double setTemp;
    @ConfigurationParameter(maxLength=9, category="RaftTempControl", description="Temperature channels to use", units="unitless")
    private volatile String[] tempChans = new String[]{"Reb0/S01/Temp", "Reb2/S11/Temp", "Reb2/S21/Temp"};
    @ConfigurationParameter(maxLength=3, category="RaftTempControl", description="The REBs with heaters to use", units="unitless")
    private volatile String[] rebs = new String[]{"Reb0", "Reb2"};
    @ConfigurationParameter(category="RaftTempControl", description="input smoothing time", units="second")
    private volatile double smoothTime = 20.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="base power input", units="Watt")
    private volatile double basePower = 0.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="minimum PID output", units="Watt")
    private volatile double minOutput = 0.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="maximum input", units="unitless")
    private volatile double maxInput = 100.0;
    @ConfigurationParameter(isFinal=true, category="RaftTempControl", description="minimum input", units="unitless")
    private volatile double minInput = -200.0;
    @ConfigurationParameter(category="RaftTempControl", description="integration time constant", units="second")
    private volatile double timeConst = 120.0;
    @ConfigurationParameter(category="RaftTempControl", description="PID P coeficient", units="unitless")
    private volatile double coefP = 3.0;
    @ConfigurationParameter(category="RaftTempControl", description="PID I coeficient", units="unitless")
    private volatile double coefI = 1.0;
    @ConfigurationParameter(category="RaftTempControl", description="PID D coeficient", units="unitless")
    private volatile double coefD = 0.0;
    private PIDController pic;
    private final List<Channel> tempChansL = new ArrayList<Channel>();
    private final List<REBDevice> rebsL = new ArrayList<REBDevice>();
    private double lastPower;

    public void build() {
        if (!this.raftPath.endsWith("/")) {
            this.raftPath = this.raftPath + "/";
        }
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("tempControl/" + this.raftPath.replace("/", ""), () -> this.iterateLoop()).withPeriod(Duration.ofMillis(30000L)));
    }

    public void postInit() {
        this.pic = new PIDController(this.raftPath.replace("/", ""));
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput);
        this.pic.setCoefP(this.coefP);
        this.pic.setCoefI(this.coefI);
        this.pic.setCoefD(this.coefD);
        this.pic.setSmoothTime(this.smoothTime);
        this.pic.setTimeConst(this.timeConst);
        this.pic.setBaseOutput(this.basePower);
        this.setTemperatureChannels(this.tempChans);
        this.setPowerRebs(this.rebs);
        this.setTemperature(this.setTemp);
        this.setActive(this.active);
    }

    @ConfigurationParameterChanger(propertyName="active")
    public void setActive(boolean active) {
        if (this.pic != null) {
            if (active) {
                this.pic.reset();
            } else {
                this.setPower(0.0);
            }
        }
        this.active = active;
    }

    @ConfigurationParameterChanger(propertyName="maxOutput")
    public void setMaxOutput(double maxOutput) {
        if (this.pic != null) {
            this.pic.setOutputRange(this.minOutput, maxOutput);
        }
        this.maxOutput = maxOutput;
    }

    @ConfigurationParameterChanger(propertyName="timeConst")
    public void setTimeConst(double timeConst) {
        if (this.pic != null) {
            this.pic.setTimeConst(timeConst);
        }
        this.timeConst = timeConst;
    }

    @ConfigurationParameterChanger(propertyName="coefP")
    public void setCoefP(double value) {
        this.coefP = value;
        if (this.pic != null) {
            this.pic.setCoefP(this.coefP);
        }
    }

    @ConfigurationParameterChanger(propertyName="coefI")
    public void setCoefI(double value) {
        this.coefI = value;
        if (this.pic != null) {
            this.pic.setCoefI(this.coefI);
        }
    }

    @ConfigurationParameterChanger(propertyName="coefD")
    public void setCoefD(double value) {
        this.coefD = value;
        if (this.pic != null) {
            this.pic.setCoefD(this.coefD);
        }
    }

    @ConfigurationParameterChanger(propertyName="setTemp")
    public void setTemperature(double temp) {
        this.setTemp = temp;
        if (this.pic != null) {
            this.pic.setSetpoint(this.setTemp);
        }
    }

    @ConfigurationParameterChanger(propertyName="tempChans")
    public void setTemperatureChannels(String[] tempChans) {
        ArrayList<Channel> tmpChansList = new ArrayList<Channel>();
        for (String cName : tempChans) {
            Channel chan = this.allChannels.get(this.raftPath + cName);
            if (chan == null) {
                throw new RuntimeException("Invalid configuration " + Arrays.asList(tempChans) + ". Channel " + cName + " does not exist in " + this.allChannels);
            }
            tmpChansList.add(chan);
        }
        this.tempChansL.clear();
        this.tempChansL.addAll(tmpChansList);
        this.tempChans = tempChans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ConfigurationParameterChanger(propertyName="rebs")
    public void setPowerRebs(String[] rebs) {
        ArrayList<REBDevice> tmpRebList = new ArrayList<REBDevice>();
        for (String cName : rebs) {
            REBDevice reb = this.allRebs.get(this.raftPath + cName);
            if (reb == null) {
                throw new RuntimeException("Invalid configuration " + Arrays.asList(rebs) + ". Reb Device " + this.raftPath + cName + " does not exist in " + this.allRebs);
            }
            tmpRebList.add(reb);
        }
        List<REBDevice> list = this.rebsL;
        synchronized (list) {
            this.setPower(0.0);
            this.rebsL.clear();
            this.rebsL.addAll(tmpRebList);
        }
        this.rebs = rebs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPower(double power) {
        List<REBDevice> list = this.rebsL;
        synchronized (list) {
            for (REBDevice reb : this.rebsL) {
                try {
                    if (!reb.isOnline()) continue;
                    reb.setHeaterPower(0, power / (double)this.rebs.length);
                }
                catch (RaftException e) {
                    LOG.log(Level.SEVERE, "Error setting " + reb.getName() + "(isOnline:" + reb.isOnline() + ") heater", e);
                }
            }
        }
    }

    private void iterateLoop() {
        if (!this.active) {
            return;
        }
        int count = 0;
        double tstamp = 0.0;
        double temp = 0.0;
        for (Channel tempChan : this.tempChansL) {
            Measurement point = tempChan.getLastMeasurement();
            if (Double.isNaN(point.getValue())) continue;
            temp += point.getValue();
            tstamp += point.getCCSTimestamp().getTAIDouble();
            ++count;
        }
        if (count > 0) {
            this.lastPower = this.pic.performPID(new double[]{temp / (double)count}, tstamp / (double)count);
            this.setPower(this.lastPower);
        } else {
            LOG.log(Level.SEVERE, "Control loop iteration failed: no valid temperature values available");
        }
    }
}

