/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationAppliedEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSConfigurationsAvailableEvent;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSImageNameEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.KeyValueParser;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MCM {
    private final MCMConfig config;
    private final ImageNameService imageNameService;
    private static final Logger LOG = Logger.getLogger(MCM.class.getName());
    private MCMSubsystem mcmSubsystem;
    private final CCS ccs;
    private final State takeImageReadinessState;
    private final State calibrationState;
    private final Shutter shutter;
    private final FocalPlane focalPlane;
    private final FilterChanger fcs;
    private Instant startIntegrationTime;
    private ScheduledFuture<?> startImageTimeout;
    private ScheduledFuture<?> shutterPrepSchedule;
    private ScheduledFuture<?> raftsClearSchedule;
    private CCSTimeStamp integrationStartTime = CCSTimeStamp.currentTime();
    private final State standbyState;

    public MCM(CCS ccs, MCMConfig config, ImageNameService imageNameService) {
        this.ccs = ccs;
        this.config = config;
        this.imageNameService = imageNameService;
        this.takeImageReadinessState = new State<TakeImageReadinessState>(config.getShutterPrepTime() > 0.0 || !config.isAlwaysClear() ? TakeImageReadinessState.NOT_READY : TakeImageReadinessState.READY);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        ccs.getAggregateStatus().add(now, this.takeImageReadinessState);
        this.calibrationState = new State<CalibrationState>(CalibrationState.DISABLED);
        ccs.getAggregateStatus().add(now, this.calibrationState);
        this.standbyState = new State<StandbyState>(StandbyState.STANDBY);
        ccs.getAggregateStatus().add(now, this.standbyState);
        this.shutter = new Shutter(ccs, config);
        this.focalPlane = new FocalPlane(ccs, config);
        this.fcs = config.hasFilterChanger() ? new FilterChanger(ccs, config) : null;
        ccs.addStateChangeListener((when, state, oldState, cause) -> {
            AggregateStatus as = ccs.getAggregateStatus();
            TakeImageReadinessState newState = TakeImageReadinessState.READY;
            if (!config.isAlwaysClear() && !as.hasState(FocalPlane.RaftsState.QUIESCENT)) {
                newState = TakeImageReadinessState.NOT_READY;
            }
            if (config.getShutterPrepTime() > 0.0 && !as.hasState(Shutter.ShutterReadinessState.READY)) {
                newState = TakeImageReadinessState.NOT_READY;
            }
            if (newState != TakeImageReadinessState.NOT_READY || !as.hasState(TakeImageReadinessState.GETTING_READY)) {
                this.takeImageReadinessState.setState(when, newState);
            }
            if (oldState == FocalPlane.RaftsState.CLEARING || oldState == FocalPlane.RaftsState.READING_OUT) {
                this.integrationStartTime = when;
            }
        });
    }

    void registerMCMSubsystem(MCMSubsystem mcmSubsystem) {
        this.mcmSubsystem = mcmSubsystem;
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSInitImageCommand) {
            return this.execute((CCSCommand.CCSInitImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSTakeImagesCommand) {
            return this.execute((CCSCommand.CCSTakeImagesCommand)command);
        }
        if (command instanceof CCSCommand.CCSSetFilterCommand) {
            return this.execute((CCSCommand.CCSSetFilterCommand)command);
        }
        if (command instanceof CCSCommand.CCSInitGuidersCommand) {
            return this.execute((CCSCommand.CCSInitGuidersCommand)command);
        }
        if (command instanceof CCSCommand.CCSStartImageCommand) {
            return this.execute((CCSCommand.CCSStartImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSEndImageCommand) {
            return this.execute((CCSCommand.CCSEndImageCommand)command);
        }
        if (command instanceof CCSCommand.CCSClearCommand) {
            return this.execute((CCSCommand.CCSClearCommand)command);
        }
        if (command instanceof CCSCommand.CCSDiscardRowsCommand) {
            return this.execute((CCSCommand.CCSDiscardRowsCommand)command);
        }
        if (command instanceof CCSCommand.CCSStartCommand) {
            return this.execute((CCSCommand.CCSStartCommand)command);
        }
        if (command instanceof CCSCommand.CCSStandbyCommand) {
            return this.execute((CCSCommand.CCSStandbyCommand)command);
        }
        if (command instanceof CCSCommand.CCSEnableCalibrationCommand) {
            return this.execute((CCSCommand.CCSEnableCalibrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSDisableCalibrationCommand) {
            return this.execute((CCSCommand.CCSDisableCalibrationCommand)command);
        }
        if (command instanceof CCSCommand.CCSPlayCommand) {
            return this.execute((CCSCommand.CCSPlayCommand)command);
        }
        if (command instanceof CCSCommand.CCSDefinePlaylistCommand) {
            return this.execute((CCSCommand.CCSDefinePlaylistCommand)command);
        }
        throw new RuntimeException("Unknown command type: " + command);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSInitImageCommand command) {
        InitImageExecutor executor = new InitImageExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSTakeImagesCommand command) {
        TakeImagesExecutor executor = new TakeImagesExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSSetFilterCommand command) {
        SetFilterExecutor executor = new SetFilterExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSInitGuidersCommand command) {
        InitGuidersExecutor executor = new InitGuidersExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStartImageCommand command) {
        StartImageExecutor executor = new StartImageExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEndImageCommand command) {
        EndImageExecutor executor = new EndImageExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSClearCommand command) {
        ClearExecutor executor = new ClearExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDiscardRowsCommand command) {
        DiscardRowsExecutor executor = new DiscardRowsExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStandbyCommand command) {
        StandbyExecutor executor = new StandbyExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSStartCommand command) {
        StartExecutor executor = new StartExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSEnableCalibrationCommand command) {
        EnableCalibrationExecutor executor = new EnableCalibrationExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDisableCalibrationCommand command) {
        DisableCalibrationExecutor executor = new DisableCalibrationExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSPlayCommand command) {
        PlayExecutor executor = new PlayExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCSCommand.CCSCommandResponse execute(CCSCommand.CCSDefinePlaylistCommand command) {
        DefinePlaylistExecutor executor = new DefinePlaylistExecutor(command);
        return new CCSCommand.CCSCommandResponse(executor);
    }

    CCS getCCS() {
        return this.ccs;
    }

    FocalPlane getFocalPlane() {
        return this.focalPlane;
    }

    public Shutter getShutter() {
        return this.shutter;
    }

    public FilterChanger getFilterChanger() {
        return this.fcs;
    }

    MCMConfig getConfig() {
        return this.config;
    }

    private void imageTimeout() {
        try {
            this.shutter.close();
            this.focalPlane.endIntegration(false, Duration.ZERO);
            this.calibrationState.setState(CalibrationState.ENABLED);
        }
        catch (ExecutionException x) {
            LOG.log(Level.SEVERE, "Error during image timeout", x);
        }
    }

    private class DiscardRowsExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDiscardRowsCommand command;

        public DiscardRowsExecutor(CCSCommand.CCSDiscardRowsCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.INTEGRATING)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            if (MCM.this.startImageTimeout == null || MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("No exposure in progress");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            MCM.this.focalPlane.discardRows(this.command.getnRows());
            Future<Void> waitUntilDone = MCM.this.ccs.waitForStatus(FocalPlane.RaftsState.INTEGRATING);
            waitUntilDone.get(FocalPlane.DISCARD_TIME.multipliedBy(this.command.getnRows()).plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private class EndImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSEndImageCommand command;

        public EndImageExecutor(CCSCommand.CCSEndImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.INTEGRATING)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            if (MCM.this.startImageTimeout == null || MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("No exposure in progress");
            }
            return Shutter.MOVE_TIME;
        }

        @Override
        protected void execute() throws Exception {
            if (!MCM.this.startImageTimeout.cancel(false)) {
                throw new RuntimeException("Image exposure already timed out");
            }
            Future<Void> waitUntilClosed = MCM.this.ccs.waitForStatus(Shutter.ShutterState.CLOSED);
            MCM.this.shutter.close();
            waitUntilClosed.get(Shutter.MOVE_TIME.plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
            Instant endIntegationTime = Instant.now();
            MCM.this.focalPlane.endIntegration(true, Duration.between(MCM.this.startIntegrationTime, endIntegationTime));
            MCM.this.calibrationState.setState(CalibrationState.ENABLED);
        }
    }

    private class StartImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStartImageCommand command;
        private Map<String, String> parsedKeyValueData;
        private LocationSet locations;

        public StartImageExecutor(CCSCommand.CCSStartImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getTimeout() < 1.0 | this.command.getTimeout() > 120.0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid argument");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            try {
                this.parsedKeyValueData = KeyValueParser.parse(this.command.getKeyValueMap());
                for (String key : MCM.this.config.getRequiredKeys()) {
                    if (this.parsedKeyValueData.containsKey(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Required key missing: " + key);
                }
                for (String key : this.parsedKeyValueData.keySet()) {
                    if (MCM.this.config.getAllowedKeys().contains(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Key not allowed: " + key);
                }
            }
            catch (ParseException x) {
                throw new CCSCommand.CCSPreconditionsNotMet(x.getMessage());
            }
            if (!this.command.getSensors().trim().isEmpty()) {
                try {
                    this.locations = LocationSet.of((String[])new String[]{this.command.getSensors()});
                }
                catch (RuntimeException x) {
                    throw new CCSCommand.CCSPreconditionsNotMet("Invalid sensors argument" + this.command.getSensors());
                }
            } else {
                this.locations = new LocationSet();
            }
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws Exception {
            Future<Void> waitUntilReady = MCM.this.ccs.waitForStatus(TakeImageReadinessState.READY);
            if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.NOT_READY)) {
                MCM.this.focalPlane.clear(1);
                MCM.this.shutter.prepare();
            }
            waitUntilReady.get(1L, TimeUnit.SECONDS);
            ImageName imageName = MCM.this.imageNameService.getImageName();
            MCM.this.ccs.fireEvent(new CCSImageNameEvent(this.parsedKeyValueData, 1, imageName, 1, MCM.this.integrationStartTime, 0.0, "calibration", this.command.getTimeout()));
            if (this.command.isShutterOpen()) {
                MCM.this.focalPlane.startIntegration(imageName, this.parsedKeyValueData, this.locations, this.command.getObsNote());
                MCM.this.shutter.open();
            } else {
                MCM.this.focalPlane.startIntegration(imageName, this.parsedKeyValueData, this.locations, this.command.getObsNote());
            }
            MCM.this.startIntegrationTime = Instant.now();
            MCM.this.calibrationState.setState(CalibrationState.INTEGRATING);
            MCM.this.startImageTimeout = MCM.this.ccs.schedule(Duration.ofMillis((long)(this.command.getTimeout() * 1000.0)), () -> MCM.this.imageTimeout());
        }
    }

    private class DefinePlaylistExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDefinePlaylistCommand command;

        public DefinePlaylistExecutor(CCSCommand.CCSDefinePlaylistCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getPlaylist().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid playlist: " + this.command.getPlaylist());
            }
            if (this.command.getFolder().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid folder: " + this.command.getFolder());
            }
            if (this.command.getImages().length == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid image list: " + Arrays.toString(this.command.getImages()));
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.focalPlane.definePlaylist(this.command.getPlaylist(), this.command.getFolder(), this.command.getImages());
        }
    }

    private class PlayExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSPlayCommand command;

        public PlayExecutor(CCSCommand.CCSPlayCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getPlaylist().length() == 0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid playlist: " + this.command.getPlaylist());
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.focalPlane.play(this.command.getPlaylist(), this.command.isRepeat());
        }
    }

    private class ClearExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSClearCommand command;

        public ClearExecutor(CCSCommand.CCSClearCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getNClears() <= 0 || this.command.getNClears() > 15) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid nClears: " + this.command.getNClears());
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return FocalPlane.CLEAR_TIME.multipliedBy(this.command.getNClears());
        }

        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException {
            MCM.this.focalPlane.clear(this.command.getNClears());
            Future<Void> waitUntilClear = MCM.this.ccs.waitForStatus(FocalPlane.RaftsState.QUIESCENT);
            waitUntilClear.get(FocalPlane.CLEAR_TIME.multipliedBy(this.command.getNClears()).plus(Duration.ofSeconds(1L)).toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private class StartExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStartCommand command;

        public StartExecutor(CCSCommand.CCSStartCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ofSeconds(5L);
        }

        @Override
        protected void execute() throws ExecutionException {
            String requestedConfig = this.command.getConfiguration();
            if (requestedConfig.trim().isEmpty()) {
                requestedConfig = "Normal";
            }
            if (MCM.this.fcs != null) {
                MCM.this.fcs.start("default");
            }
            if (MCM.this.focalPlane != null) {
                MCM.this.focalPlane.start("default");
            }
            if (MCM.this.shutter != null) {
                MCM.this.shutter.start("default");
            }
            if (MCM.this.mcmSubsystem != null) {
                for (String other : MCM.this.config.getOtherConfiguredSubsystems()) {
                    try {
                        AgentMessagingLayer agentMessagingLayer = MCM.this.mcmSubsystem.getMessagingAccess();
                        CommandRequest request = new CommandRequest(other, "publishConfigurationInfo");
                        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
                        cmu.sendSynchronousCommand(request);
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, "Unable to send publishConfigurationInfo to " + other, x);
                    }
                }
            }
            MCM.this.standbyState.setState(StandbyState.STARTED);
            CCSTimeStamp now = CCSTimeStamp.currentTime();
            MCM.this.ccs.fireEvent(new CCSConfigurationAppliedEvent(requestedConfig, now.getTAIDouble(), "1", "https://lsst-camera-dev.slac.stanford.edu/RestFileServer/config/", "UNKNOWN"));
        }
    }

    private class StandbyExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSStandbyCommand command;

        public StandbyExecutor(CCSCommand.CCSStandbyCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ofSeconds(1L);
        }

        @Override
        protected void execute() throws ExecutionException {
            MCM.this.standbyState.setState(StandbyState.STANDBY);
            MCM.this.ccs.fireEvent(new CCSConfigurationsAvailableEvent("Normal", "1", "https://lsst-camera-dev.slac.stanford.edu/RestFileServer/config/", "UNKNOWN"));
        }
    }

    private class DisableCalibrationExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSDisableCalibrationCommand command;

        public DisableCalibrationExecutor(CCSCommand.CCSDisableCalibrationCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.ENABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            MCM.this.calibrationState.setState(CalibrationState.DISABLED);
        }
    }

    private class EnableCalibrationExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSEnableCalibrationCommand command;

        public EnableCalibrationExecutor(CCSCommand.CCSEnableCalibrationCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (!MCM.this.calibrationState.isInState(CalibrationState.DISABLED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid calibration state " + MCM.this.calibrationState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            MCM.this.calibrationState.setState(CalibrationState.ENABLED);
        }
    }

    private class InitGuidersExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSInitGuidersCommand command;

        public InitGuidersExecutor(CCSCommand.CCSInitGuidersCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
        }
    }

    class SetFilterExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSSetFilterCommand command;

        public SetFilterExecutor(CCSCommand.CCSSetFilterCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (MCM.this.fcs == null) {
                throw new CCSCommand.CCSPreconditionsNotMet("setFilter command not supported");
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            if (!MCM.this.fcs.filterIsAvailable(this.command.getFilterName())) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid filter: " + this.command.getFilterName());
            }
            return MCM.this.fcs.getEstimatedTimeForChange(this.command.getFilterName());
        }

        @Override
        protected void execute() throws ExecutionException {
            MCM.this.fcs.setFilter(this.command.getFilterName());
        }
    }

    class TakeImagesExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSTakeImagesCommand command;
        private Map<String, String> parsedKeyValueData;
        private LocationSet locations;

        public TakeImagesExecutor(CCSCommand.CCSTakeImagesCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            double minExposeTime;
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getNumImages() <= 0 || this.command.getNumImages() > MCM.this.config.getMaxImagesPerSequence()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid number of images");
            }
            double d = minExposeTime = this.command.isShutter() ? MCM.this.config.getMinExposeTime() : 0.0;
            if (this.command.getExpTime() < minExposeTime || this.command.getExpTime() > MCM.this.config.getMaxExposeTime()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid exposure time");
            }
            try {
                this.parsedKeyValueData = KeyValueParser.parse(this.command.getKeyValueMap());
                for (String key : MCM.this.config.getRequiredKeys()) {
                    if (this.parsedKeyValueData.containsKey(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Required key missing: " + key);
                }
                for (String key : this.parsedKeyValueData.keySet()) {
                    if (MCM.this.config.getAllowedKeys().contains(key)) continue;
                    throw new CCSCommand.CCSPreconditionsNotMet("Key not allowed: " + key);
                }
            }
            catch (ParseException x) {
                throw new CCSCommand.CCSPreconditionsNotMet(x.getMessage());
            }
            if (!this.command.getSensors().trim().isEmpty()) {
                try {
                    this.locations = LocationSet.of((String[])new String[]{this.command.getSensors()});
                }
                catch (RuntimeException x) {
                    throw new CCSCommand.CCSPreconditionsNotMet("Invalid sensors argument" + this.command.getSensors());
                }
            } else {
                this.locations = new LocationSet();
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            return Duration.ofMillis((long)(this.command.getExpTime() * 1000.0)).plus(Shutter.MOVE_TIME).plus(FocalPlane.READOUT_TIME).multipliedBy(this.command.getNumImages());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() throws InterruptedException, ExecutionException, TimeoutException, CCSCommand.CCSPreconditionsNotMet {
            List imageNames = MCM.this.imageNameService.getImageNames(this.command.getNumImages());
            Duration exposeTime = Duration.ofMillis((long)(this.command.getExpTime() * 1000.0));
            if (this.command.getNumImages() > 1) {
                MCM.this.shutter.startImageSequence();
            }
            try {
                for (int i = 0; i < this.command.getNumImages(); ++i) {
                    Future<Void> waitUntilReady = MCM.this.ccs.waitForStatus(TakeImageReadinessState.READY);
                    if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.NOT_READY)) {
                        MCM.this.focalPlane.clear(1);
                        MCM.this.shutter.prepare();
                    } else if (MCM.this.takeImageReadinessState.isInState(TakeImageReadinessState.GETTING_READY)) {
                        boolean raftClearEnd = MCM.this.raftsClearSchedule.cancel(false);
                        boolean shutterPrepEnd = MCM.this.shutterPrepSchedule.cancel(false);
                        if (raftClearEnd) {
                            MCM.this.focalPlane.clear(1);
                        }
                        if (shutterPrepEnd) {
                            MCM.this.shutter.prepare();
                        }
                    }
                    waitUntilReady.get(20L, TimeUnit.SECONDS);
                    ImageName imageName = (ImageName)imageNames.get(i);
                    MCM.this.ccs.fireEvent(new CCSImageNameEvent(this.parsedKeyValueData, this.command.getNumImages(), imageName, i, MCM.this.integrationStartTime, this.command.getExpTime(), "normal", this.command.getExpTime()));
                    LOG.log(Level.INFO, "Sent image name event for {0}", imageName);
                    if (this.command.isShutter()) {
                        MCM.this.focalPlane.startIntegration(imageName, this.parsedKeyValueData, this.locations, this.command.getObsNote());
                        LOG.log(Level.INFO, "Starting expose for {0}", exposeTime);
                        MCM.this.shutter.expose(exposeTime);
                        Future<Void> waitShutterClosed = MCM.this.ccs.waitForStatus(Shutter.ShutterState.CLOSED);
                        waitShutterClosed.get(exposeTime.plus(Shutter.MOVE_TIME).plusSeconds(10L).toMillis(), TimeUnit.MILLISECONDS);
                        LOG.log(Level.INFO, "Ending expose for {0}", exposeTime);
                        MCM.this.focalPlane.endIntegration(true, exposeTime);
                        Future<Void> waitUntilDone = MCM.this.ccs.waitForStatus(i + 1 < this.command.getNumImages() ? FocalPlane.RaftsState.QUIESCENT : FocalPlane.RaftsState.READING_OUT);
                        waitUntilDone.get(FocalPlane.READOUT_TIME.plusSeconds(10L).toMillis(), TimeUnit.MILLISECONDS);
                    } else {
                        MCM.this.focalPlane.startIntegration(imageName, this.parsedKeyValueData, this.locations, this.command.getObsNote());
                        Thread.sleep(exposeTime.toMillis());
                        MCM.this.focalPlane.endIntegration(true, exposeTime);
                        Future<Void> waitUntilDone = MCM.this.ccs.waitForStatus(i + 1 < this.command.getNumImages() ? FocalPlane.RaftsState.QUIESCENT : FocalPlane.RaftsState.READING_OUT);
                        waitUntilDone.get(FocalPlane.READOUT_TIME.plusSeconds(10L).toMillis(), TimeUnit.MILLISECONDS);
                    }
                    LOG.log(Level.INFO, "Readout complete");
                }
            }
            finally {
                MCM.this.shutter.endImageSequence();
            }
        }
    }

    class InitImageExecutor
    extends CCSExecutor {
        private final CCSCommand.CCSInitImageCommand command;

        public InitImageExecutor(CCSCommand.CCSInitImageCommand command) {
            this.command = command;
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!MCM.this.standbyState.isInState(StandbyState.STARTED)) {
                throw new CCSCommand.CCSPreconditionsNotMet("MCM start command has not been issued");
            }
            if (this.command.getDeltaT() <= 0.0 || this.command.getDeltaT() > 15.0) {
                throw new CCSCommand.CCSPreconditionsNotMet("Invalid deltaT: " + this.command.getDeltaT());
            }
            if (MCM.this.startImageTimeout != null && !MCM.this.startImageTimeout.isDone()) {
                throw new CCSCommand.CCSPreconditionsNotMet("Exposure in progress");
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() {
            Duration takeImagesExpected = Duration.ofMillis((long)(this.command.getDeltaT() * 1000.0));
            MCM.this.takeImageReadinessState.setState(TakeImageReadinessState.GETTING_READY);
            MCM.this.raftsClearSchedule = MCM.this.ccs.schedule(takeImagesExpected.minus(FocalPlane.CLEAR_TIME), () -> {
                try {
                    MCM.this.focalPlane.clear(1);
                }
                catch (ExecutionException x) {
                    LOG.log(Level.SEVERE, "Error while performing scheduled clear", x);
                }
            });
            MCM.this.shutterPrepSchedule = MCM.this.ccs.schedule(takeImagesExpected.minus(Duration.ofMillis((long)MCM.this.config.getShutterPrepTime() * 1000L)), () -> MCM.this.shutter.prepare());
        }
    }

    public static enum StandbyState {
        STANDBY,
        STARTED;

    }

    public static enum CalibrationState {
        DISABLED,
        ENABLED,
        INTEGRATING;

    }

    public static enum TakeImageReadinessState {
        NOT_READY,
        GETTING_READY,
        READY;

    }
}

