import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.power.ATSPowerMain
import org.lsst.ccs.subsystem.power.HamegDevice;
import org.lsst.ccs.subsystem.power.N6487Device;
import org.lsst.ccs.subsystem.power.SimPowerDevice;
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.monitor.Channel

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")

hameg1 = "Hameg1"
hameg2 = "Hameg2"
hameg3 = "Hameg3"
n6487  = "Keithley"

CCSBuilder builder = ["ats-power"]

builder.main (ATSPowerMain) {


    if (runMode.equals("simulation")) {

        "$hameg1" (SimPowerDevice, loads: [1, 1000, 600, 10] as double[]) {

            DPHI    (PowerControl, description:"DPHI voltage", hwChan:1)

            OD      (PowerControl, description:"OD voltage", hwChan:2)

            Digital (PowerControl, description:"Digital voltage", hwChan:3)
        }

        "$hameg2" (SimPowerDevice, loads: [1, 240, 240, 20] as double[]) {

            ClockLow  (PowerControl, description:"Clock low voltage", hwChan:1)

            ClockHigh (PowerControl, description:"Clock high voltage", hwChan:2)

            Analog    (PowerControl, description:"Analog voltage", hwChan:3)
        }

        "$hameg3" (SimPowerDevice, loads: [1, 15, 100, 20] as double[]) {

            OTM  (PowerControl, description:"OTM voltage", hwChan:1)

            Fan  (PowerControl, description:"Fan voltage", hwChan:2)

            Aux  (PowerControl, description:"Aux voltage", hwChan:3)

        }

        "$n6487" (SimPowerDevice, loads: [50000] as double[]) {

            HVBias (PowerControl, description:"HV bias voltage", hwChan:0)
        }
    }
    else {

        "$hameg1" (HamegDevice) {

            DPHI    (PowerControl, description:"DPHI voltage", hwChan:1)

            OD      (PowerControl, description:"OD voltage", hwChan:2)

            Digital (PowerControl, description:"Digital voltage", hwChan:3)
        }

        "$hameg2" (HamegDevice) {

            ClockLow  (PowerControl, description:"Clock low voltage", hwChan:1)

            ClockHigh (PowerControl, description:"Clock high voltage", hwChan:2)

            Analog    (PowerControl, description:"Analog voltage", hwChan:3)
        }

        "$hameg3" (HamegDevice) {

            OTM  (PowerControl, description:"OTM voltage", hwChan:1)

            Fan  (PowerControl, description:"Fan voltage", hwChan:2)

            Aux  (PowerControl, description:"Aux voltage", hwChan:3)

        }

        "$n6487" (N6487Device) {

            HVBias (PowerControl, description:"HV bias voltage", hwChan:0)
        }
    }

    Digital_V (Channel, description: "Digital voltage", units: "Volts",
               devcName: hameg1,  hwChan:3, type: "VOLTAGE")
                          
    Digital_I (Channel, description: "Digital current", units: "mA", format: ".1f",
               devcName: hameg1,  hwChan:3, type: "CURRENT", scale: 1000.0)
                          
    Analog_V  (Channel, description: "Analog voltage", units: "Volts",
               devcName: hameg2,  hwChan:3, type: "VOLTAGE")
                          
    Analog_I  (Channel, description: "Analog current", units: "mA", format: ".1f",
               devcName: hameg2,  hwChan:3, type: "CURRENT", scale: 1000.0)

    ClkHigh_V (Channel, description: "Clock high voltage", units: "Volts",
               devcName: hameg2,  hwChan:2, type: "VOLTAGE")
                          
    ClkHigh_I (Channel, description: "Clock high current", units: "mA", format: ".1f",
               devcName: hameg2,  hwChan:2, type: "CURRENT", scale: 1000.0)
                          
    ClkLow_V  (Channel, description: "Clock low voltage", units: "Volts",
               devcName: hameg2,  hwChan:1, type: "VOLTAGE")
                          
    ClkLow_I  (Channel, description: "Clock low current", units: "mA", format: ".1f",
               devcName: hameg2,  hwChan:1, type: "CURRENT", scale: 1000.0)
                          
    OD_V      (Channel, description: "OD voltage", units: "Volts",
               devcName: hameg1,  hwChan:2, type: "VOLTAGE")
                          
    OD_I      (Channel, description: "OD current", units: "mA", format: ".1f",
               devcName: hameg1,  hwChan:2, type: "CURRENT", scale: 1000.0)
                          
    DPHI_V    (Channel, description: "DPHI voltage", units: "Volts",
               devcName: hameg1,  hwChan:1, type: "VOLTAGE")
                          
    DPHI_I    (Channel, description: "DPHI current", units: "mA", format: ".1f",
               devcName: hameg1,  hwChan:1, type: "CURRENT", scale: 1000.0)
     
    HVBias_V  (Channel, description: "HV bias voltage", units: "Volts",
                devcName: n6487,  hwChan:0, type: "VOLTAGE")
                          
    HVBias_I  (Channel, description: "HV bias current", units: "mA", format: ".1f",
                devcName: n6487,  hwChan:0, type: "CURRENT", scale: 1000.0)
     
    OTM_V     (Channel, description: "OTM voltage", units: "Volts",
               devcName: hameg3,  hwChan:1, type: "VOLTAGE")
                          
    OTM_I     (Channel, description: "OTM current", units: "mA", format: ".1f",
               devcName: hameg3,  hwChan:1, type: "CURRENT", scale: 1000.0)
                          
    Fan_V     (Channel, description: "Fan voltage", units: "Volts",
               devcName: hameg3,  hwChan:2, type: "VOLTAGE")
                          
    Fan_I     (Channel, description: "Fan current", units: "mA", format: ".1f",
               devcName: hameg3,  hwChan:2, type: "CURRENT", scale: 1000.0)
                          
    Aux_V     (Channel, description: "Aux voltage", units: "Volts",
               devcName: hameg3,  hwChan:3, type: "VOLTAGE")
                          
    Aux_I     (Channel, description: "Aux current", units: "mA", format: ".1f",
               devcName: hameg3,  hwChan:3, type: "CURRENT", scale: 1000.0)
                          
}
