/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.internal.AbstractSaveEventListener;
import org.hibernate.event.internal.MergeContext;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.TypeHelper;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultMergeEventListener.class);
    private String entityCopyObserverStrategy;

    @Override
    protected Map getMergeMap(Object anything) {
        return ((MergeContext)anything).invertMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMerge(MergeEvent event) throws HibernateException {
        EntityCopyObserver entityCopyObserver = this.createEntityCopyObserver(event.getSession().getFactory());
        MergeContext mergeContext = new MergeContext(event.getSession(), entityCopyObserver);
        try {
            this.onMerge(event, mergeContext);
            entityCopyObserver.topLevelMergeComplete(event.getSession());
        }
        finally {
            entityCopyObserver.clear();
            mergeContext.clear();
        }
    }

    private EntityCopyObserver createEntityCopyObserver(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        if (this.entityCopyObserverStrategy == null) {
            ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
            this.entityCopyObserverStrategy = configurationService.getSetting("hibernate.event.merge.entity_copy_observer", new ConfigurationService.Converter<String>(){

                @Override
                public String convert(Object value) {
                    return value.toString();
                }
            }, "disallow");
            LOG.debugf("EntityCopyObserver strategy: %s", this.entityCopyObserverStrategy);
        }
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        return strategySelector.resolveStrategy(EntityCopyObserver.class, this.entityCopyObserverStrategy);
    }

    @Override
    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        MergeContext copyCache = (MergeContext)copiedAlready;
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getIdentifier()));
                    return;
                }
                entity = li.getImplementation();
            } else {
                entity = original;
            }
            if (copyCache.containsKey(entity) && copyCache.isOperatedOn(entity)) {
                LOG.trace("Already in merge process");
                event.setResult(entity);
            } else {
                EntityPersister persister;
                Serializable id;
                if (copyCache.containsKey(entity)) {
                    LOG.trace("Already in copyCache; setting in merge process");
                    copyCache.setOperatedOn(entity, true);
                }
                event.setEntity(entity);
                Enum entityState = null;
                EntityEntry entry = source.getPersistenceContext().getEntry(entity);
                if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, source)) != null) {
                    EntityKey key = source.generateEntityKey(id, persister);
                    Object managedEntity = source.getPersistenceContext().getEntity(key);
                    entry = source.getPersistenceContext().getEntry(managedEntity);
                    if (entry != null) {
                        entityState = AbstractSaveEventListener.EntityState.DETACHED;
                    }
                }
                if (entityState == null) {
                    entityState = this.getEntityState(entity, event.getEntityName(), entry, source);
                }
                switch (2.$SwitchMap$org$hibernate$event$internal$AbstractSaveEventListener$EntityState[entityState.ordinal()]) {
                    case 1: {
                        this.entityIsDetached(event, copyCache);
                        break;
                    }
                    case 2: {
                        this.entityIsTransient(event, copyCache);
                        break;
                    }
                    case 3: {
                        this.entityIsPersistent(event, copyCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(event.getEntityName(), entity));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent event, Map copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        ((MergeContext)copyCache).put(entity, entity, true);
        this.cascadeOnMerge(source, persister, entity, copyCache);
        this.copyValues(persister, entity, entity, source, copyCache);
        event.setResult(entity);
    }

    protected void entityIsTransient(MergeEvent event, Map copyCache) {
        Serializable id;
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Serializable serializable = id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, source) : null;
        if (copyCache.containsKey(entity)) {
            persister.setIdentifier(copyCache.get(entity), id, source);
        } else {
            ((MergeContext)copyCache).put(entity, source.instantiate(persister, id), true);
        }
        Object copy = copyCache.get(entity);
        super.cascadeBeforeSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.FROM_PARENT);
        this.saveTransientEntity(copy, entityName, event.getRequestedId(), source, copyCache);
        super.cascadeAfterSave(source, persister, entity, copyCache);
        this.copyValues(persister, entity, copy, source, copyCache, ForeignKeyDirection.TO_PARENT);
        event.setResult(copy);
    }

    private void saveTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, Map copyCache) {
        if (requestedId == null) {
            this.saveWithGeneratedId(entity, entityName, copyCache, source, false);
        } else {
            this.saveWithRequestedId(entity, requestedId, entityName, copyCache, source);
        }
    }

    protected void entityIsDetached(MergeEvent event, Map copyCache) {
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable id = event.getRequestedId();
        if (id == null) {
            id = persister.getIdentifier(entity, source);
        } else {
            Serializable entityId = persister.getIdentifier(entity, source);
            if (!persister.getIdentifierType().isEqual(id, entityId, source.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        String previousFetchProfile = source.getLoadQueryInfluencers().getInternalFetchProfile();
        source.getLoadQueryInfluencers().setInternalFetchProfile("merge");
        Serializable clonedIdentifier = (Serializable)persister.getIdentifierType().deepCopy(id, source.getFactory());
        Object result = source.get(entityName, clonedIdentifier);
        source.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile);
        if (result == null) {
            this.entityIsTransient(event, copyCache);
        } else {
            ((MergeContext)copyCache).put(entity, result, true);
            Object target = source.getPersistenceContext().unproxy(result);
            if (target == entity) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!source.getEntityName(target).equals(entityName)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
            }
            if (this.isVersionChanged(entity, source, persister, target)) {
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().optimisticFailure(entityName);
                }
                throw new StaleObjectStateException(entityName, id);
            }
            this.cascadeOnMerge(source, persister, entity, copyCache);
            this.copyValues(persister, entity, target, source, copyCache);
            this.markInterceptorDirty(entity, target, persister);
            event.setResult(result);
        }
    }

    private void markInterceptorDirty(Object entity, Object target, EntityPersister persister) {
        if (entity instanceof SelfDirtinessTracker && target instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)target).$$_hibernate_clearDirtyAttributes();
            for (String fieldName : ((SelfDirtinessTracker)entity).$$_hibernate_getDirtyAttributes()) {
                ((SelfDirtinessTracker)target).$$_hibernate_trackChange(fieldName);
            }
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (!persister.isVersioned()) {
            return false;
        }
        boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
        return changed && this.existsInDatabase(target, source, persister);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Serializable id;
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = source.getPersistenceContext().getEntity(key);
            entry = source.getPersistenceContext().getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache) {
        Object[] copiedValues = TypeHelper.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache);
        persister.setPropertyValues(target, copiedValues);
    }

    protected void copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copiedValues = foreignKeyDirection == ForeignKeyDirection.TO_PARENT ? TypeHelper.replaceAssociations(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection) : TypeHelper.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, copyCache, foreignKeyDirection);
        persister.setPropertyValues(target, copiedValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, Map copyCache) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_MERGE, source, persister, entity, copyCache);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    @Override
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }

    @Override
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) throws HibernateException {
    }
}

