/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayerMBean;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusApplicationLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.MessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;

public class AgentMessagingLayer
implements AgentMessagingLayerMBean {
    private static final List<AgentMessagingLayer> msgAccesses = new CopyOnWriteArrayList<AgentMessagingLayer>();
    private Predicate<BusMessage<? extends Serializable, ?>> filterMessagesFromThisAgent;
    private final Logger curLogger = Logger.getLogger("org.lsst.ccs.bus");
    private final BusApplicationLayer layer;
    private volatile ConnectionStatus connectionStatus = ConnectionStatus.NOT_CONNECTED;
    private final Object connectionLock = new Object();
    private final AgentInfo agentInfo;
    private final LockLevelService lockLevelService;

    public static AgentMessagingLayer createInstance(AgentInfo agentInfo, LockLevelService lockLevelService) {
        AgentMessagingLayer agentMessagingLayer = new AgentMessagingLayer(agentInfo, lockLevelService);
        return agentMessagingLayer;
    }

    AgentMessagingLayer(AgentInfo agentInfo, LockLevelService lockLevelService) {
        this.layer = new BusApplicationLayer(agentInfo, this);
        this.filterMessagesFromThisAgent = BusMessageFilterFactory.messageOrigin(agentInfo.getName()).negate();
        this.agentInfo = agentInfo;
        this.lockLevelService = lockLevelService;
    }

    @Override
    public void restart(int seconds) {
        this.shutdownBusAccess();
        Thread restart = new Thread(() -> {
            try {
                Thread.sleep(1000 * seconds);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            this.connectToBuses();
        });
    }

    public final void addBusMessagePreProcessor(BusMessagePreProcessor preProcessor) {
        this.layer.addBusMessagePreProcessor(preProcessor);
    }

    public BusApplicationLayer getApplicationLayer() {
        return this.layer;
    }

    public MessagingLayer getMessagingLayer() {
        return this.layer.getBusMessagingLayer();
    }

    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownBusAccess() {
        this.layer.close();
        msgAccesses.remove(this);
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionStatus = ConnectionStatus.DISCONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToBuses() {
        this.layer.connectToBuses();
        msgAccesses.add(this);
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionStatus = ConnectionStatus.CONNECTED;
            this.connectionLock.notify();
        }
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.layer.getAgentPresenceManager();
    }

    public boolean needsHeartbeat() {
        return !this.layer.hasInternalHeartbeat();
    }

    public LockLevelService getAgentLockService() {
        return this.lockLevelService;
    }

    public void addLogMessageListener(LogMessageListener listener) {
        this.addLogMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addLogMessageListener(LogMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addLogListener(listener, filter);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.addStatusMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addStatusMessageListener(StatusMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addStatusListener(listener, filter);
    }

    public void addCommandMessageListener(CommandMessageListener listener) {
        this.addCommandMessageListener(listener, this.filterMessagesFromThisAgent);
    }

    public void addCommandMessageListener(CommandMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.layer.addCommandListener(listener, filter);
    }

    public void removeLogMessageListener(LogMessageListener listener) {
        this.layer.removeLogListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.layer.removeStatusListener(listener);
    }

    public void removeCommandMessageListener(CommandMessageListener listener) {
        this.layer.removeCommandListener(listener);
    }

    public void sendLogMessage(LogMessage msg) {
        this.checkMessageLayerConnection();
        msg.setOriginAgentInfo(this.agentInfo);
        this.layer.sendLog(msg);
    }

    public void sendStatusMessage(StatusMessage msg) {
        this.checkMessageLayerConnection();
        msg.setOriginAgentInfo(this.agentInfo);
        this.curLogger.finest("sending status " + msg);
        this.layer.sendStatus(msg);
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator) {
        this.sendCommandRequest(cmd, originator, true);
    }

    public void sendCommandRequest(CommandRequest cmd, CommandOriginator originator, boolean checkDestinationExists) {
        String destination;
        this.checkMessageLayerConnection();
        if (this.lockLevelService != null) {
            destination = BusMessagingLayer.parseDestination(cmd.getDestination());
            AgentLock lock = this.lockLevelService.getLockForAgent(destination);
            int desiredLevel = this.lockLevelService.getLevelForAgent(destination);
            cmd.setLockAndLevel(lock, desiredLevel);
        }
        cmd.setOriginAgentInfo(this.agentInfo);
        if (checkDestinationExists) {
            destination = BusMessagingLayer.parseDestination(cmd.getDestination());
            if (!this.getAgentPresenceManager().agentExists(destination)) {
                DestinationsException exc = new DestinationsException(this.agentInfo.getName(), destination);
                this.curLogger.log(Level.FINE, "sending fail (closed){0} to destination {1}", new Object[]{this.agentInfo.getName(), destination});
                this.curLogger.log(Level.WARNING, "destination problem", exc);
                throw exc;
            }
        }
        this.layer.sendCommand(cmd, originator);
    }

    public void sendCommandReply(CommandReply reply) {
        this.checkMessageLayerConnection();
        reply.setOriginAgentInfo(this.agentInfo);
        this.layer.reply(reply);
    }

    private void checkMessageLayerConnection() {
        switch (this.connectionStatus) {
            case NOT_CONNECTED: {
                throw new RuntimeException("The CCS Buses have not been connected yet.");
            }
            case DISCONNECTED: {
                throw new RuntimeException("The CCS Buses have been shutdown. It's no longer possible to send messages.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessageLayerConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            switch (this.connectionStatus) {
                case CONNECTED: {
                    return;
                }
                case DISCONNECTED: {
                    throw new RuntimeException("The connection to the messaging layer has been lost");
                }
            }
            try {
                this.connectionLock.wait(1000L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Failed to wait for bus connection", ie);
            }
        }
    }

    public void setCommandExecutor(CommandExecutor executor) {
        this.layer.setCommandExecutor(executor);
    }

    public void setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler h) {
        this.layer.setClusterDeserializationErrorHandler(h);
    }

    static List<AgentMessagingLayer> getMessagingAccesses() {
        return msgAccesses;
    }

    static void printMessagingAccessInfo(AgentMessagingLayer msgAccess) {
        System.out.println("MessagingAccess " + msgAccess.agentInfo.getName());
        BusApplicationLayer layer = msgAccess.getApplicationLayer();
        System.out.println("BusApplicationLayer " + layer);
        BusMessagingLayer messagingLayer = layer.getBusMessagingLayer();
        System.out.println("BusMessagingLayer " + messagingLayer);
        Set<String> localAgents = messagingLayer.getRegisteredLocalAgents();
        System.out.println("Local Agents " + localAgents.size());
        for (String agent : localAgents) {
            System.out.println("\t" + agent);
        }
    }

    public static enum ConnectionStatus {
        NOT_CONNECTED,
        CONNECTED,
        DISCONNECTED;

    }
}

