/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;

public abstract class CCSCommand {
    abstract String getCommand();

    abstract List<Object> getArguments();

    public String toString() {
        return "CCSCommand: " + this.getCommand() + " " + this.getArguments().stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public static class CCSPreconditionsNotMet
    extends Exception {
        private static final long serialVersionUID = 7463370916615596884L;
        private final String reason;

        public CCSPreconditionsNotMet(String reason) {
            super("Reason : " + reason);
            this.reason = reason;
        }

        private String getReason() {
            return this.reason;
        }
    }

    public static class CCSAckOrNack {
        private final boolean ack;
        private final Duration duration;
        private final String reason;

        private CCSAckOrNack(Duration duration) {
            this.ack = true;
            this.reason = null;
            this.duration = duration;
        }

        private CCSAckOrNack(String reason) {
            this.ack = false;
            this.reason = reason;
            this.duration = null;
        }

        public boolean isNack() {
            return !this.ack;
        }

        public String getReason() {
            return this.reason;
        }

        public Duration getDuration() {
            return this.duration;
        }
    }

    public static class CCSCommandResponse {
        private final CCSExecutor executor;

        public CCSCommandResponse(CCSExecutor executor) {
            this.executor = executor;
        }

        public CCSAckOrNack waitForAckOrNack() {
            try {
                Duration duration = this.executor.testPreconditions();
                return new CCSAckOrNack(duration);
            }
            catch (CCSPreconditionsNotMet ex) {
                return new CCSAckOrNack(ex.getReason());
            }
        }

        public void waitForCompletion() throws Exception {
            this.executor.execute();
        }
    }

    public static class CCSDefinePlaylistCommand
    extends CCSCommand {
        private final String playlist;
        private final String folder;
        private final String[] images;

        public CCSDefinePlaylistCommand() {
            this.playlist = "";
            this.folder = "";
            this.images = new String[0];
        }

        public CCSDefinePlaylistCommand(String playlist, String folder, String ... images) {
            this.playlist = playlist;
            this.folder = folder;
            this.images = images;
        }

        public String getPlaylist() {
            return this.playlist;
        }

        public String getFolder() {
            return this.folder;
        }

        public String[] getImages() {
            return this.images;
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.playlist, this.folder, this.images);
        }

        @Override
        String getCommand() {
            return "definePlaylist";
        }
    }

    public static class CCSPlayCommand
    extends CCSCommand {
        private final String playlist;
        private final boolean repeat;

        public CCSPlayCommand() {
            this.playlist = "";
            this.repeat = false;
        }

        public CCSPlayCommand(String playlist, boolean repeat) {
            this.playlist = playlist;
            this.repeat = repeat;
        }

        public String getPlaylist() {
            return this.playlist;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.playlist, this.repeat);
        }

        @Override
        String getCommand() {
            return "play";
        }
    }

    public static class CCSClearCommand
    extends CCSCommand {
        private final int nClears;

        public CCSClearCommand() {
            this.nClears = 0;
        }

        public CCSClearCommand(int nClears) {
            this.nClears = nClears;
        }

        public int getNClears() {
            return this.nClears;
        }

        @Override
        String getCommand() {
            return "clear";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.nClears);
        }
    }

    public static class CCSDiscardRowsCommand
    extends CCSCommand {
        private final int nRows;

        public CCSDiscardRowsCommand() {
            this.nRows = 0;
        }

        public CCSDiscardRowsCommand(int nRows) {
            this.nRows = nRows;
        }

        public int getnRows() {
            return this.nRows;
        }

        @Override
        String getCommand() {
            return "discardRows";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.nRows);
        }
    }

    public static class CCSClearFaultCommand
    extends NoArgCCSCommand {
        public CCSClearFaultCommand() {
            super("clearFault");
        }
    }

    public static class CCSSimulateFaultCommand
    extends NoArgCCSCommand {
        public CCSSimulateFaultCommand() {
            super("simulateFault");
        }
    }

    public static class CCSRevokeAvailableCommand
    extends NoArgCCSCommand {
        public CCSRevokeAvailableCommand() {
            super("revokeAvailable");
        }
    }

    public static class CCSSetAvailableCommand
    extends NoArgCCSCommand {
        public CCSSetAvailableCommand() {
            super("setAvailable");
        }
    }

    public static class CCSEndImageCommand
    extends NoArgCCSCommand {
        public CCSEndImageCommand() {
            super("endImage");
        }
    }

    public static class CCSDisableCalibrationCommand
    extends NoArgCCSCommand {
        public CCSDisableCalibrationCommand() {
            super("disableCalibration");
        }
    }

    public static class CCSEnableCalibrationCommand
    extends NoArgCCSCommand {
        public CCSEnableCalibrationCommand() {
            super("enableCalibration");
        }
    }

    public static class CCSStandbyCommand
    extends NoArgCCSCommand {
        public CCSStandbyCommand() {
            super("standby");
        }
    }

    static class NoArgCCSCommand
    extends CCSCommand {
        private String commandName;

        NoArgCCSCommand(String commandName) {
            this.commandName = commandName;
        }

        @Override
        String getCommand() {
            return this.commandName;
        }

        @Override
        List<Object> getArguments() {
            return Collections.emptyList();
        }
    }

    public static class CCSStartCommand
    extends CCSCommand {
        private final String configurationOverride;

        public CCSStartCommand() {
            this.configurationOverride = "will be oerwritten";
        }

        public CCSStartCommand(String configurationOverride) {
            this.configurationOverride = configurationOverride;
        }

        public String getConfiguration() {
            return this.configurationOverride;
        }

        @Override
        public String toString() {
            return "CCSStartCommand{configuration=" + this.configurationOverride + '}';
        }

        @Override
        String getCommand() {
            return "start";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.configurationOverride);
        }
    }

    public static class CCSStartImageCommand
    extends CCSCommand {
        private final boolean shutter;
        private final double timeout;
        private final String sensors;
        private final String keyValueMap;
        private final String obsNote;

        public CCSStartImageCommand() {
            this.shutter = false;
            this.sensors = "";
            this.keyValueMap = "";
            this.obsNote = "";
            this.timeout = 1.0;
        }

        public CCSStartImageCommand(boolean shutter, String sensors, String keyValueMap, String obsNote, double timeout) {
            this.shutter = shutter;
            this.sensors = sensors;
            this.keyValueMap = keyValueMap;
            this.obsNote = obsNote;
            this.timeout = timeout;
        }

        public boolean isShutterOpen() {
            return this.shutter;
        }

        public String getSensors() {
            return this.sensors;
        }

        public String getKeyValueMap() {
            return this.keyValueMap;
        }

        public String getObsNote() {
            return this.obsNote;
        }

        public double getTimeout() {
            return this.timeout;
        }

        @Override
        String getCommand() {
            return "startImage";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.shutter, this.sensors, this.keyValueMap, this.obsNote, this.timeout);
        }

        @Override
        public String toString() {
            return "CCSStartImageCommand{shutter=" + this.shutter + ", timeout=" + this.timeout + ", sensors=" + this.sensors + ", keyValueMap=" + this.keyValueMap + ", annotation=" + this.obsNote + '}';
        }
    }

    public static class CCSInitGuidersCommand
    extends CCSCommand {
        private final String roiSpec;

        public CCSInitGuidersCommand() {
            this.roiSpec = "will be overwritten";
        }

        public CCSInitGuidersCommand(String roiSpec) {
            this.roiSpec = roiSpec;
        }

        public String getRoiSpec() {
            return this.roiSpec;
        }

        @Override
        String getCommand() {
            return "initGuiders";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.roiSpec);
        }
    }

    public static class CCSSetFilterCommand
    extends CCSCommand {
        private final String name;

        public CCSSetFilterCommand() {
            this.name = "Empty Constructor Default";
        }

        public CCSSetFilterCommand(String filterName) {
            this.name = filterName;
        }

        public String getFilterName() {
            return this.name;
        }

        @Override
        String getCommand() {
            return "setFilter";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.name);
        }
    }

    public static class CCSTakeImagesCommand
    extends CCSCommand {
        private final int numImages;
        private final double expTime;
        private final boolean shutter;
        private final String sensors;
        private final String obsNote;
        private final String keyValueMap;

        public CCSTakeImagesCommand() {
            this.numImages = 1;
            this.expTime = 1.0;
            this.shutter = false;
            this.sensors = "";
            this.obsNote = "";
            this.keyValueMap = "";
        }

        public CCSTakeImagesCommand(double expTime, int numImages, boolean shutter, String sensors, String keyValueMap, String obsNote) {
            this.numImages = numImages;
            this.expTime = expTime;
            this.shutter = shutter;
            this.sensors = sensors;
            this.keyValueMap = keyValueMap;
            this.obsNote = obsNote;
        }

        public int getNumImages() {
            return this.numImages;
        }

        public double getExpTime() {
            return this.expTime;
        }

        public boolean isShutter() {
            return this.shutter;
        }

        public String getSensors() {
            return this.sensors;
        }

        public String getObsNote() {
            return this.obsNote;
        }

        public String getKeyValueMap() {
            return this.keyValueMap;
        }

        @Override
        String getCommand() {
            return "takeImages";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.expTime, this.numImages, this.shutter, this.sensors, this.keyValueMap, this.obsNote);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("CCSTakeImagesCommand{numImages=").append(this.numImages);
            sb.append(", expTime=").append(this.expTime);
            sb.append(", shutter=").append(this.shutter);
            sb.append(", sensors=").append(this.sensors);
            sb.append(", obsNote=").append(this.obsNote);
            sb.append(", keyValueMap=").append(this.keyValueMap);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class CCSInitImageCommand
    extends CCSCommand {
        private final double deltaT;

        public CCSInitImageCommand() {
            this.deltaT = 0.0;
        }

        public CCSInitImageCommand(double deltaT) {
            this.deltaT = deltaT;
        }

        public double getDeltaT() {
            return this.deltaT;
        }

        @Override
        String getCommand() {
            return "initImage";
        }

        @Override
        List<Object> getArguments() {
            return Arrays.asList(this.deltaT);
        }
    }
}

