/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.ProcessedInfo;

public class ProcessedInfoMaker {
    private final Set<String> patternSubstitutionRecord;
    private final Map<String, List<ProcessedInfo>> processedInfo;
    private final boolean DEBUG_PRINT = true;

    public ProcessedInfoMaker(StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping, String attributeType, String resultType) {
        boolean trending = "MONITORING".equals(attributeType);
        DataProviderDictionary innards = info.getDataProviderDictionary();
        List dpInfoList = innards.getDataProviderInfos();
        ArrayList<ProcessedInfo> preliminaryProcessedInfo = new ArrayList<ProcessedInfo>();
        for (DataProviderInfo dataProviderInfo : dpInfoList) {
            String originalPathName;
            if (!dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE).trim().equals(attributeType)) continue;
            String type = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.TYPE);
            String description = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.DESCRIPTION);
            String units = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.UNITS);
            String category = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.CONFIG_CATEGORY);
            if (trending) {
                type = "double";
                category = "";
            }
            if (null == (originalPathName = dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.PUBLISHED_PATH))) {
                originalPathName = dataProviderInfo.getFullPath().replace("main/", "").trim();
            }
            originalPathName = originalPathName.trim();
            System.out.println(" *************** (1) ********************************");
            System.out.println(" ProcessedInfoMaker:Original Path  (from getPath() no main replacement) " + dataProviderInfo.getPath());
            System.out.println(" ProcessedInfoMaker:Original Path (from getFullPath() no main replacement) " + dataProviderInfo.getFullPath());
            System.out.println(" ProcessedInfoMaker:Published Path " + dataProviderInfo.getAttributeValue(DataProviderInfo.Attribute.PUBLISHED_PATH));
            System.out.println(" ProcessedInfoMaker:What is the final assigned originalPath Name ? " + originalPathName);
            System.out.println(" ProcessedInfoMaker:Type " + type);
            System.out.println(" *************** (1) ********************************");
            boolean foundPattern = false;
            for (Map.Entry<Pattern, String> patternKey : mapping.getPatterns().entrySet()) {
                Matcher m = patternKey.getKey().matcher(originalPathName);
                if (!m.matches()) continue;
                String rawSALClassParameterName = patternKey.getValue() + "/" + m.group(m.groupCount());
                String salClassParameterName = this.makeSALClassParameterName(rawSALClassParameterName.trim(), level);
                String associatedClassNameM = this.makeClassName(level, subsystemName, componentName, resultType, rawSALClassParameterName, category);
                System.out.println("\n *************** (2) ********************************");
                System.out.println(" Class name generated " + associatedClassNameM);
                System.out.println(" Original path name " + originalPathName);
                System.out.println(" Sal Parameter Name " + salClassParameterName);
                System.out.println("*************** (2) ********************************");
                ProcessedInfo addThis = new ProcessedInfo(originalPathName, salClassParameterName, patternKey.getValue(), patternKey.getKey().toString(), associatedClassNameM, type, units, description, category);
                String locationString = "";
                if (patternKey.getValue().trim().equals("ccd")) {
                    locationString = m.group(1) + m.group(3);
                    System.out.println("\n *************** (3) ********************************");
                    System.out.println(" ProcessedInfoMaker:CCD location string " + locationString);
                    System.out.println(" ProcessedInfoMaker:PatternKey " + patternKey.getKey());
                    System.out.println(" ProcessedInfoMaker:Original Path Name " + originalPathName);
                    System.out.println(" *************** (3) ********************************");
                } else if (patternKey.getValue().trim().equals("reb")) {
                    locationString = m.group(1) + m.group(2);
                    System.out.println("\n *************** (3) ********************************");
                    System.out.println(" ProcessedInfoMaker:Reb location string " + locationString);
                    System.out.println(" ProcessedInfoMaker:PatternKey " + patternKey.getKey());
                    System.out.println(" ProcessedInfoMaker:Original Path Name " + originalPathName);
                    System.out.println(" group 1 " + m.group(1) + " group 2 " + m.group(2));
                    System.out.println(" *************** (3) ********************************");
                } else if (patternKey.getValue().trim().equals("raft")) {
                    locationString = m.group(1);
                    System.out.println(" *************** (3) ********************************");
                    System.out.println(" ProcessedInfoMaker:Raft location string " + locationString);
                    System.out.println(" ProcessedInfoMaker:PatternKey " + patternKey.getKey());
                    System.out.println(" ProcessedInfoMaker:Original Path Name " + originalPathName);
                    System.out.println(" *************** (3) ********************************");
                } else if (patternKey.getValue().trim().equals("rebps")) {
                    locationString = m.group(1);
                    System.out.println(" *************** (3) ********************************");
                    System.out.println(" ProcessedInfoMaker:Rebps location string " + locationString);
                    System.out.println(" ProcessedInfoMaker:PatternKey " + patternKey.getKey());
                    System.out.println(" ProcessedInfoMaker:Original Path Name " + originalPathName);
                    System.out.println(" *************** (3) ********************************");
                } else if (patternKey.getValue().trim().equals("segment")) {
                    locationString = m.group(1);
                    System.out.println(" *************** (3) ********************************");
                    System.out.println(" ProcessedInfoMaker:Segment location string " + locationString);
                    System.out.println(" ProcessedInfoMaker:PatternKey " + patternKey.getKey());
                    System.out.println(" ProcessedInfoMaker:Original Path Name " + originalPathName);
                    System.out.println(" *************** (3) ********************************");
                }
                addThis.setLocationString(locationString);
                preliminaryProcessedInfo.add(addThis);
                foundPattern = true;
                break;
            }
            if (foundPattern) continue;
            String associatedClassName = this.makeClassName(level, subsystemName, componentName, resultType, originalPathName, category);
            preliminaryProcessedInfo.add(new ProcessedInfo(originalPathName, this.makeSALClassParameterName(originalPathName, level), "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", associatedClassName, type, units, description, category));
        }
        this.patternSubstitutionRecord = new HashSet<String>();
        this.processedInfo = this.classNameVariableProcessor(level, subsystemName, componentName, resultType, preliminaryProcessedInfo, mapping);
        for (Map.Entry entry : this.processedInfo.entrySet()) {
            ProcessedInfo.sortProcessedInfo((List)entry.getValue());
        }
    }

    Set<String> getPatternSubstitutionRecord() {
        return this.patternSubstitutionRecord;
    }

    public Map<String, List<ProcessedInfo>> getProcessedInfo() {
        return this.processedInfo;
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<ProcessedInfo>> e : this.processedInfo.entrySet()) {
            result.add("\n" + e.getKey() + "\n");
            for (ProcessedInfo pi : e.getValue()) {
                List<String> locationList;
                result.add(String.format("%-30s %-30s %-30s %5d %-12s %-12s $-%-40s", pi.getOriginalPathName(), pi.getMatchedPattern(), pi.getPatternReplacement(), pi.getCounts(), pi.getSALClassParameterType(), pi.getSALClassParameterUnits(), pi.getSALClassParameterDescription()));
                List<String> originalPathsCorrespondingToArray = pi.getOriginalPathsCorrespondingToArray();
                if (originalPathsCorrespondingToArray != null) {
                    for (String path : originalPathsCorrespondingToArray) {
                        result.add(String.format("\t%s", path));
                    }
                }
                if ((locationList = pi.getLocationList()) == null) continue;
                for (String location : locationList) {
                    result.add(String.format("\t%s", location));
                }
            }
        }
        result.add(this.patternSubstitutionRecord.toString());
        return result.stream().collect(Collectors.joining("\n"));
    }

    private Map<String, List<ProcessedInfo>> classNameVariableProcessor(int level, String subsystem, String component, String salType, List<ProcessedInfo> preliminaryProcessedInfo, Mapping mapping) {
        String salClassParameterName;
        LinkedHashMap classesAndVariablesMap = new LinkedHashMap();
        HashSet<String> recordPatternSubstitution = new HashSet<String>();
        HashSet locationEntry = new HashSet();
        for (ProcessedInfo inputPI1 : preliminaryProcessedInfo) {
            String className = inputPI1.getAssociatedClassName();
            ArrayList<ProcessedInfo> thisClassesVariables = new ArrayList<ProcessedInfo>();
            for (ProcessedInfo inputPI2 : preliminaryProcessedInfo) {
                if (!className.trim().equals(inputPI2.getAssociatedClassName().trim())) continue;
                salClassParameterName = inputPI2.getSALClassParameterName();
                if (!inputPI2.getPatternReplacement().contains("NOMATCHEDPATTERN")) {
                    recordPatternSubstitution.add(inputPI2.getAssociatedClassName() + "::" + inputPI2.getSALClassParameterName() + "::" + inputPI2.getPatternReplacement());
                }
                if (salClassParameterName.isEmpty()) {
                    String tmp = "";
                    String[] tmpArr = className.split("_");
                    for (int i = 1; i < className.split("_").length; ++i) {
                        tmp = tmp + tmpArr[i];
                    }
                    tmp = tmp.trim();
                    System.out.println("******************(4)**************");
                    System.out.println(" ProcessedInfoMaker:Class Name " + inputPI2.getAssociatedClassName());
                    System.out.println(" ProcessedInfoMaker:Parameter Name " + inputPI2.getSALClassParameterName());
                    System.out.println(" ProcessedInfoMaker:Parameter Type " + inputPI2.getSALClassParameterType());
                    System.out.println(" ProcessedInfoMaker:Path from Dictionary " + inputPI2.getOriginalPathName());
                    System.out.println(" ProcessedInfoMaker:Location String " + inputPI2.getLocationString());
                    System.out.println(" ProcessedInfoMaker:Parameter Description " + inputPI2.getSALClassParameterDescription());
                    System.out.println("******************(4)**************");
                    salClassParameterName = tmp.substring(0, 1).toLowerCase() + tmp.substring(1);
                }
                thisClassesVariables.add(inputPI2);
            }
            classesAndVariablesMap.put(className, thisClassesVariables);
        }
        LinkedHashMap<String, List<ProcessedInfo>> finalReprocessedClassInfo = new LinkedHashMap<String, List<ProcessedInfo>>();
        for (Map.Entry mykey : classesAndVariablesMap.entrySet()) {
            List info = (List)mykey.getValue();
            ArrayList<ProcessedInfo> reprocessedInfo = new ArrayList<ProcessedInfo>();
            ArrayList<String> alreadyAdded = new ArrayList<String>();
            for (int i = 0; i < info.size(); ++i) {
                boolean isArray = false;
                int arrayCount = 0;
                salClassParameterName = ((ProcessedInfo)info.get(i)).getSALClassParameterName();
                String variableType = ((ProcessedInfo)info.get(i)).getSALClassParameterType();
                String variableUnits = ((ProcessedInfo)info.get(i)).getSALClassParameterUnits();
                String variableDescription = ((ProcessedInfo)info.get(i)).getSALClassParameterDescription();
                String piCategory = ((ProcessedInfo)info.get(i)).getCategory();
                ArrayList<String> matchedOldPathNames = new ArrayList<String>();
                ArrayList<String> locationValueList = new ArrayList<String>();
                matchedOldPathNames.add(((ProcessedInfo)info.get(i)).getOriginalPathName());
                if (((ProcessedInfo)info.get(i)).getLocationString() != null) {
                    locationValueList.add(((ProcessedInfo)info.get(i)).getLocationString());
                }
                for (int j = i + 1; j < info.size(); ++j) {
                    if (!salClassParameterName.equals(((ProcessedInfo)info.get(j)).getSALClassParameterName())) continue;
                    ++arrayCount;
                    isArray = true;
                    matchedOldPathNames.add(((ProcessedInfo)info.get(j)).getOriginalPathName());
                    if (((ProcessedInfo)info.get(j)).getLocationString().isEmpty()) continue;
                    locationValueList.add(((ProcessedInfo)info.get(j)).getLocationString());
                }
                if (isArray && !alreadyAdded.contains(salClassParameterName)) {
                    int countThatMustBeProvided = arrayCount;
                    variableType = "list<" + variableType + ">";
                    ProcessedInfo addMe = new ProcessedInfo(((ProcessedInfo)info.get(i)).getOriginalPathName(), salClassParameterName, ((ProcessedInfo)info.get(i)).getPatternReplacement(), ((ProcessedInfo)info.get(i)).getMatchedPattern(), ((ProcessedInfo)info.get(i)).getAssociatedClassName(), variableType, variableUnits, variableDescription, piCategory);
                    addMe.setCounts(arrayCount + 1);
                    addMe.setLocationString(((ProcessedInfo)info.get(i)).getLocationString());
                    addMe.setOriginalPathsCorrespondingToArray(matchedOldPathNames);
                    reprocessedInfo.add(addMe);
                    alreadyAdded.add(salClassParameterName);
                    for (String it : recordPatternSubstitution) {
                        if (!it.split("::")[0].trim().equals(((String)mykey.getKey()).trim()) || !it.split("::")[1].trim().equals(salClassParameterName.trim())) continue;
                        String location = "Location";
                        if (it.split("::")[1].trim().contains(it.split("::")[2].trim())) {
                            location = it.split("::")[2].trim() + location;
                        }
                        if (alreadyAdded.contains(location)) continue;
                        String localVarName = it.split("::")[2].trim() + "Location".trim();
                        String localVarType = "string";
                        String localVarUnits = "unitless";
                        String localVarDescr = it.split("::")[2].substring(0, 1).toUpperCase() + it.split("::")[2].substring(1).toLowerCase() + " Location";
                        ProcessedInfo addMeLocation = new ProcessedInfo(location, location, ((ProcessedInfo)info.get(i)).getPatternReplacement(), ((ProcessedInfo)info.get(i)).getMatchedPattern(), ((ProcessedInfo)info.get(i)).getAssociatedClassName(), localVarType, localVarUnits, localVarDescr, piCategory);
                        addMeLocation.setLocationList(locationValueList);
                        addMeLocation.setOriginalPathsCorrespondingToArray(matchedOldPathNames);
                        reprocessedInfo.add(addMeLocation);
                        alreadyAdded.add(location);
                    }
                } else if (!isArray && !alreadyAdded.contains(salClassParameterName)) {
                    reprocessedInfo.add((ProcessedInfo)info.get(i));
                    for (String it : recordPatternSubstitution) {
                        if (!it.split("::")[0].trim().equals(((String)mykey.getKey()).trim()) || !it.split("::")[1].trim().equals(salClassParameterName.trim())) continue;
                        String location = "Location";
                        if (it.split("::")[1].trim().contains(it.split("::")[2].trim())) {
                            location = it.split("::")[2].trim() + location;
                        }
                        if (alreadyAdded.contains(location)) continue;
                        String localVarName = it.split("::")[2].trim() + "Location".trim();
                        String localVarType = "string";
                        String localVarUnits = "unitless";
                        System.out.println("******************(5)**************");
                        System.out.println(" Class Name  " + ((ProcessedInfo)info.get(i)).getAssociatedClassName());
                        System.out.println(" Parameter Name  " + ((ProcessedInfo)info.get(i)).getSALClassParameterName());
                        System.out.println(" ProcessedInfoMaker:Parameter Type " + ((ProcessedInfo)info.get(i)).getSALClassParameterType());
                        System.out.println(" ProcessedInfoMaker:Path from Dictionary " + ((ProcessedInfo)info.get(i)).getOriginalPathName());
                        System.out.println(" ProcessedInfoMaker:Location String " + ((ProcessedInfo)info.get(i)).getLocationListSALFormat());
                        System.out.println(" ProcessedInfoMaker:DAMN !!!");
                        System.out.println("*************(5)*******************");
                        String localVarDescr = it.split("::")[2].substring(0, 1).toUpperCase() + it.split("::")[2].substring(1).toLowerCase() + " Location";
                        ProcessedInfo addMeSingleLocation = new ProcessedInfo(location, location, ((ProcessedInfo)info.get(i)).getPatternReplacement(), ((ProcessedInfo)info.get(i)).getMatchedPattern(), ((ProcessedInfo)info.get(i)).getAssociatedClassName(), localVarType, localVarUnits, localVarDescr, piCategory);
                        addMeSingleLocation.setLocationString(((ProcessedInfo)info.get(i)).getLocationString());
                        reprocessedInfo.add(addMeSingleLocation);
                        alreadyAdded.add(location);
                    }
                }
                finalReprocessedClassInfo.put((String)mykey.getKey(), (List<ProcessedInfo>)reprocessedInfo);
            }
            alreadyAdded.clear();
        }
        return finalReprocessedClassInfo;
    }

    private String makeClassName(int level, String subsystem, String component, String salType, String path, String category) {
        if (subsystem.toLowerCase().contains("comcam")) {
            subsystem = "CCCamera";
        }
        String subsystemAndComponent = "";
        if (!subsystem.isEmpty()) {
            subsystemAndComponent = subsystem.substring(0, 1).toUpperCase() + subsystem.substring(1);
        }
        if (!(component = component.trim()).isEmpty()) {
            subsystemAndComponent = subsystemAndComponent + "_" + component.substring(0, 1).toLowerCase() + component.substring(1);
        }
        String className = "";
        className = salType.toLowerCase().contains("settingsapplied") ? subsystem + "_logevent_" + component.toLowerCase() : subsystemAndComponent;
        if (path.contains("main/")) {
            path = path.replace("main/", "");
            className = subsystemAndComponent;
        } else {
            for (int i = 0; i < level; ++i) {
                className = className + "_" + this.capitalize(path.split("/")[i]);
            }
        }
        if (category != null && !category.isEmpty()) {
            className = className + category;
        }
        if (className.endsWith("_")) {
            className = className.substring(0, className.length() - 1);
        }
        return className;
    }

    private String makeSALClassParameterName1(String path, int level) {
        path = path.replace("main/", "");
        int pathLength = path.split("/").length;
        String variableName = "";
        if (level <= pathLength) {
            for (int i = level; i < pathLength; ++i) {
                variableName = variableName + "_" + path.split("/")[i];
            }
            if (variableName.startsWith("_")) {
                variableName = variableName.substring(1);
            }
        } else {
            System.out.println("!!You have specified level to be longer than the variable path + name!!");
            System.exit(-1);
        }
        return this.uncapitalize(variableName).trim();
    }

    String makeSALClassParameterName(String path, int level) {
        path = path.replace("main/", "");
        int pathLength = path.split("/").length;
        String variableName = "";
        if (path.contains("/")) {
            if (level <= pathLength) {
                for (int i = level; i < pathLength; ++i) {
                    variableName = variableName + "_" + path.split("/")[i];
                }
                if (variableName.startsWith("_")) {
                    variableName = variableName.substring(1);
                }
            } else {
                System.out.println("!!You have specified level to be longer than the variable path + name!!");
                System.exit(-1);
            }
        } else {
            variableName = path;
        }
        return this.uncapitalize(variableName).trim();
    }

    private String capitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toUpperCase() + in.substring(1);
        }
        return in.toUpperCase();
    }

    private String uncapitalize(String in) {
        if (in.length() > 1) {
            return in.substring(0, 1).toLowerCase() + in.substring(1);
        }
        return in.toLowerCase();
    }
}

