/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProcessedInfo {
    private final String salClassParameterName;
    private final String originalPathName;
    private final String patternReplacement;
    private final String matchedPattern;
    private final String associatedClassName;
    private final String salClassParameterType;
    private final String salClassParameterDescription;
    private final String salClassParameterUnits;
    private final String category;
    private List<String> originalPathArrayNames = new ArrayList<String>();
    private String locationString;
    private List<String> locationsValueList = new ArrayList<String>();
    private boolean isLocation;
    private boolean isArray;
    private int counts;

    ProcessedInfo(String originalPathName, String salClassParameterName, String patternReplacement, String matchedPattern, String associatedClassName, String salClassParameterType, String salClassParameterUnits, String salClassParameterDescription, String category) {
        int backSlashIndex;
        this.originalPathArrayNames = new ArrayList<String>();
        this.salClassParameterName = salClassParameterName;
        this.originalPathName = originalPathName;
        this.patternReplacement = patternReplacement;
        this.matchedPattern = matchedPattern;
        this.associatedClassName = associatedClassName;
        this.salClassParameterType = this.cleanUpType(salClassParameterType);
        this.salClassParameterUnits = salClassParameterUnits;
        this.category = category;
        this.isArray = false;
        this.isLocation = false;
        this.salClassParameterDescription = salClassParameterDescription == null ? null : ((backSlashIndex = salClassParameterDescription.lastIndexOf(92)) < 0 ? salClassParameterDescription : salClassParameterDescription.substring(backSlashIndex + 1));
    }

    public String getOriginalPathName() {
        return this.originalPathName;
    }

    public String getSALClassParameterName() {
        return this.salClassParameterName;
    }

    public String getPatternReplacement() {
        return this.patternReplacement;
    }

    public String getMatchedPattern() {
        return this.matchedPattern;
    }

    public String getAssociatedClassName() {
        return this.associatedClassName;
    }

    public String getSALClassParameterType() {
        return this.salClassParameterType;
    }

    public String getSALClassParameterDescription() {
        return this.salClassParameterDescription;
    }

    public String getSALClassParameterUnits() {
        return this.salClassParameterUnits;
    }

    public List<String> getOriginalPathsCorrespondingToArray() {
        return this.originalPathArrayNames;
    }

    public List<String> getLocationList() {
        return this.locationsValueList;
    }

    public String getLocationListSALFormat() {
        String concatString = "";
        if (!this.locationsValueList.isEmpty()) {
            for (int i = 0; i < this.locationsValueList.size(); ++i) {
                concatString = i < this.locationsValueList.size() - 1 ? concatString + this.locationsValueList.get(i) + ":" : concatString + this.locationsValueList.get(i);
            }
        }
        if (concatString.isEmpty()) {
            concatString = this.locationString;
        }
        return concatString;
    }

    public String getLocationString() {
        return this.locationString;
    }

    void setOriginalPathsCorrespondingToArray(List<String> oldPathArray) {
        this.originalPathArrayNames = oldPathArray;
    }

    public boolean isArray() {
        return this.isArray;
    }

    boolean isLocation() {
        return this.isLocation;
    }

    void setLocationList(List<String> locationsValueList) {
        this.locationsValueList = locationsValueList;
    }

    void setIsArray(boolean isAnArray) {
        this.isArray = isAnArray;
    }

    void setLocationString(String locationString) {
        this.locationString = locationString;
    }

    void setIsLocation(boolean isLocation) {
        this.isLocation = isLocation;
    }

    void setCounts(int counts) {
        this.counts = counts;
    }

    public int getCounts() {
        return this.counts;
    }

    public String getCategory() {
        return this.category;
    }

    final String cleanUpType(String type) {
        String whatWeGot = type.replace("class", "");
        if ((whatWeGot = whatWeGot.replace("Class", "")).toLowerCase().contains("java.lang.string")) {
            whatWeGot = "string";
        }
        whatWeGot = whatWeGot.trim();
        return whatWeGot;
    }

    public String toString() {
        return " Variable name : " + this.getOriginalPathName() + " Parameter type : " + this.getSALClassParameterType() + "   Parameter Units : " + this.getSALClassParameterUnits() + " Parameter description : " + this.getSALClassParameterDescription() + " Category " + this.getCategory();
    }

    static void sortProcessedInfo(List<ProcessedInfo> processedInfo) {
        Collections.sort(processedInfo, (p1, p2) -> p1.getOriginalPathName().compareToIgnoreCase(p2.getOriginalPathName()));
    }
}

