/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class PluginDownload
extends JPanel
implements Runnable,
ActionListener {
    private Map<File, String> files;
    private Map<File, ByteArrayOutputStream> downloads;
    private Throwable status;
    private int size = 1;
    private int read = 0;
    private int iFile = 0;
    private JLabel label1;
    private JLabel label2;
    private JProgressBar progress1;
    private JProgressBar progress2;
    static final Logger logger = Logger.getLogger(PluginDownload.class.getName());

    PluginDownload(Map<File, String> files) {
        super(new GridLayout(4, 1));
        this.files = files;
        int n = files.size();
        this.label1 = new JLabel("File 1/" + n);
        this.label2 = new JLabel("Downloading ...");
        this.progress1 = new JProgressBar(0, n * 100);
        this.progress2 = new JProgressBar();
        this.progress1.setStringPainted(true);
        this.progress2.setStringPainted(true);
        this.add(this.label1);
        this.add(this.progress1);
        this.add(this.label2);
        this.add(this.progress2);
    }

    Throwable getStatus() {
        return this.status;
    }

    void cleanUp() {
        this.downloads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        try {
            for (Map.Entry<File, ByteArrayOutputStream> entry : this.downloads.entrySet()) {
                ByteArrayOutputStream bytes = entry.getValue();
                FileOutputStream out = new FileOutputStream(entry.getKey());
                bytes.writeTo(out);
                ((OutputStream)out).close();
            }
        }
        catch (IOException x) {
            logger.log(Level.SEVERE, "Error during download", x);
        }
        finally {
            this.downloads = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Timer timer = new Timer(100, this);
        timer.start();
        try {
            this.downloads = new HashMap<File, ByteArrayOutputStream>();
            this.iFile = 0;
            for (Map.Entry<File, String> entry : this.files.entrySet()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                this.read = 0;
                URL url = new URL(entry.getValue());
                SwingUtilities.invokeLater(new Update(this.iFile, url, "Downloading"));
                URLConnection connect = url.openConnection();
                this.size = connect.getContentLength();
                InputStream in = connect.getInputStream();
                byte[] buffer = new byte[8196];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ZipEntry jarEntry;
                    while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        int l = in.read(buffer);
                        if (l < 0) break;
                        out.write(buffer, 0, l);
                        this.read += l;
                    }
                    out.close();
                    this.read = this.size;
                    SwingUtilities.invokeLater(new Update(this.iFile, url, "Verify"));
                    ByteArrayInputStream verifyStream = new ByteArrayInputStream(out.toByteArray());
                    JarInputStream verify = new JarInputStream(verifyStream);
                    int nEntries = 0;
                    while ((jarEntry = verify.getNextEntry()) != null) {
                        ++nEntries;
                    }
                    verify.close();
                    if (nEntries == 0) {
                        throw new IOException("Downloaded jar had no entries " + entry.getKey().getName());
                    }
                    this.downloads.put(entry.getKey(), out);
                }
                finally {
                    in.close();
                }
                ++this.iFile;
            }
        }
        catch (Throwable t) {
            this.status = t;
        }
        finally {
            SwingUtilities.invokeLater(new Update(this.files.size(), null, null));
            timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.progress2.setValue(this.read);
        this.progress2.setMaximum(this.size);
        this.progress1.setValue(100 * this.iFile + 100 * this.read / this.size);
    }

    private class Update
    implements Runnable {
        private int n;
        private URL url;
        private String message;

        Update(int n, URL url, String message) {
            this.n = n;
            this.url = url;
            this.message = message;
        }

        @Override
        public void run() {
            PluginDownload.this.label1.setText("File " + (this.n + 1) + "/" + PluginDownload.this.files.size());
            PluginDownload.this.progress1.setValue(100 * this.n);
            if (this.url == null) {
                JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, PluginDownload.this);
                if (dlg != null) {
                    dlg.dispose();
                }
            } else {
                String file = this.url.getFile();
                int pos = file.lastIndexOf(47);
                if (pos > 0) {
                    file = file.substring(pos + 1);
                }
                PluginDownload.this.label2.setText(this.message + " " + file + "...");
            }
            PluginDownload.this.actionPerformed(null);
        }
    }
}

