import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.drivers.auxelex.Bfr
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VC
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VD
import org.lsst.ccs.drivers.auxelex.Pdu5V
import org.lsst.ccs.drivers.auxelex.ComCamPdu48V
import org.lsst.ccs.subsystem.power.ComCamQuadBox
import org.lsst.ccs.subsystem.power.BfrComCamDevice
import org.lsst.ccs.subsystem.power.Pdu5vDevice
import org.lsst.ccs.subsystem.power.ComCamPdu24vcDevice
import org.lsst.ccs.subsystem.power.ComCamPdu24vdDevice
import org.lsst.ccs.subsystem.power.ComCamPdu48vDevice
import org.lsst.ccs.subsystem.power.RebBulkPsDevice
import org.lsst.ccs.monitor.Alarm
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page

CCSBuilder builder = ["comcam-quadbox"]

builder.main (ComCamQuadBox) {

ProtectionCurrentTooHigh  (Alarm, description:"ProtectionCurrentTooHigh", eventParm:0)
Clean_5_24VCurrentTooHigh  (Alarm, description:"Clean_5_24VCurrentTooHigh", eventParm:0)
V24DCurrentTooHigh  (Alarm, description:"24VDCurrentTooHigh", eventParm:0)
V48CurrentTooHigh  (Alarm, description:"48VCurrentTooHigh", eventParm:0)
REBPSCurrentTooHigh  (Alarm, description:"REBPSCurrentTooHigh", eventParm:0)
Pdu5VoltageTooLow  (Alarm, description:"Pdu5VoltageTooLow", eventParm:0)
Pdu24VCVoltageTooLow  (Alarm, description:"Pdu24VCVoltageTooLow", eventParm:0)
Pdu24VDVoltageTooLow  (Alarm, description:"Pdu24VDVoltageTooLow", eventParm:0)
Pdu48VVoltageTooLow  (Alarm, description:"Pdu48VVoltageTooLow", eventParm:0)

    BFR (BfrComCamDevice) {

        Protection_I (Channel, description: "Protection system current", units: "mA", format: ".1f",
                      hwChan:Bfr.SENSOR_PROT, scale: 1000.0,checkHi:"alarm", limitHi:2000.0, dbandHi:2.0, alarmHi:"ProtectionCurrentTooHigh")

        Clean_5_24V_I (Channel, description: "Clean 5 and 24V current", units: "mA", format: ".1f",
                       hwChan:Bfr.SENSOR_PWS_20_21, scale: 1000.0,checkHi:"alarm", limitHi:2000.0, dbandHi:2.0, alarmHi:"Clean_5_24VCurrentTooHigh")

        Dirty_24V_I (Channel, description: "Dirty 24V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_3, scale: 1000.0,checkHi:"alarm", limitHi:2000.0, dbandHi:2.0, alarmHi:"V24DCurrentTooHigh")

        Dirty_48V_I (Channel, description: "Dirty 48V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_1, scale: 1000.0,checkHi:"alarm", limitHi:2000.0, dbandHi:2.0, alarmHi:"V48CurrentTooHigh")

        RebPs_0 (Channel, description: "REB PS 0-2 current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_16, scale: 1000.0,checkHi:"alarm", limitHi:2000.0, dbandHi:2.0, alarmHi:"REBPSCurrentTooHigh")

/*
"cryoturbo", RELAY_VCR_CMC_PCT_00);
        relayMap.put("scrollpump", RELAY_DPP_01);
*/

        Dirty_28V_I (Channel, description: "Dirty 28V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_4, scale: 1000.0)
/*
    SENSOR_PWS_1 = 1,
        SENSOR_PWS_3 = 7,
        SENSOR_PWS_4 = 3,
        SENSOR_PWS_16 = 8,
        SENSOR_PWS_17 = 5,
        SENSOR_PWS_18 = 6,
        SENSOR_PWS_19 = 7,
        SENSOR_PWS_25 = 8,
        SENSOR_PWS_20_21 = 9,
        SENSOR_PROT = 10,
*/
        SENSOR_PWS_17_I (Channel, description: "SENSOR_PWS_17 current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_17, scale: 1000.0)

        Heater_I (Channel, description: "Heater current", units: "mA", format: ".1f",
                  hwChan:Bfr.SENSOR_HTRS, scale: 1000.0)

    }

    PDU_5V (Pdu5vDevice) {

        OTM_3_A_V (Channel, description: "OTM 3-A voltage", units: "Volt", format: ".2f",
                   hwChan:Pdu5V.CHAN_OTM_3_A, type:"VOLTAGE",checkLo:"alarm", limitLo:0.0, dbandLo:2.0, alarmLo:"Pdu5VoltageTooLow")

        OTM_3_A_I (Channel, description: "OTM 3-A current", units: "mA", format: ".1f",
                   hwChan:Pdu5V.CHAN_OTM_3_A, type:"CURRENT", scale: 1000.0)

        OTM_3_B_V (Channel, description: "OTM 3-B voltage", units: "Volt", format: ".2f",
                   hwChan:Pdu5V.CHAN_OTM_3_B, type:"VOLTAGE",checkLo:"alarm", limitLo:0.0, dbandLo:2.0, alarmLo:"Pdu5VoltageTooLow")

        OTM_3_B_I (Channel, description: "OTM 3-B current", units: "mA", format: ".1f",
                   hwChan:Pdu5V.CHAN_OTM_3_B, type:"CURRENT", scale: 1000.0)

    }

    PDU_24VC (ComCamPdu24vcDevice) {
        
        "Main_V" (Channel, description: "24V Clean PDU main voltage", units: "Volt", format: ".2f",
                       type:"MAINVOLT",checkLo:"alarm", limitLo:0.0, dbandLo:2.0, alarmLo:"Pdu24VCVoltageTooLow")

        "Main_I" (Channel, description: "24V Clean PDU main current", units: "mA", format: ".1f",
                       type:"MAINCURR", scale: 1000.0)

        "Main_T" (Channel, description: "24V Clean PDU main temperature", units: "\u00b0C", format: ".1f",
                       type:"MAINTEMP")

        "Board_T" (Channel, description: "24V Clean PDU board temperature", units: "\u00b0C", format: ".1f",
                        type:"BOARDTEMP")

        "FPGA_T" (Channel, description: "24V Clean PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                       type:"FPGATEMP")

        Pwr_Cry_HCU_V (Channel, description: "Power/cryo HCU voltage", units: "Volt", format: ".2f",
                       hwChan:ComCamPdu24VC.CHAN_J15, type:"VOLTAGE")

        Pwr_Cry_HCU_I (Channel, description: "Power/cryo HCU current", units: "mA", format: ".1f",
                       hwChan:ComCamPdu24VC.CHAN_J15, type:"CURRENT", scale: 1000.0)

        Fes_Shu_HCU_V (Channel, description: "FES/shutter HCU voltage", units: "Volt", format: ".2f",
                       hwChan:ComCamPdu24VC.CHAN_J16, type:"VOLTAGE")

        Fes_Shu_HCU_I (Channel, description: "FES/shutter HCU current", units: "mA", format: ".1f",
                       hwChan:ComCamPdu24VC.CHAN_J16, type:"CURRENT", scale: 1000.0)


        Body_Purge_V (Channel, description: "Body purge voltage", units: "Volt", format: ".2f",
                      hwChan:ComCamPdu24VC.CHAN_J12, type:"VOLTAGE")

        Body_Purge_I (Channel, description: "Body purge current", units: "mA", format: ".1f",
                      hwChan:ComCamPdu24VC.CHAN_J12, type:"CURRENT", scale: 1000.0)

        Bpu_Maq20_V (Channel, description: "Body purge MAQ20 voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu24VC.CHAN_BPU_MAQ20, type:"VOLTAGE")

        Bpu_Maq20_I (Channel, description: "Body purge MAQ20 current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu24VC.CHAN_BPU_MAQ20, type:"CURRENT", scale: 1000.0)

        Gauges_V (Channel, description: "Gauges voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J11, type:"VOLTAGE")

        Gauges_I (Channel, description: "Gauges current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J11, type:"CURRENT", scale: 1000.0)

        Ion_Pumps_V (Channel, description: "Ion pumps voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu24VC.CHAN_J5, type:"VOLTAGE")

        Ion_Pumps_I (Channel, description: "Ion pumps current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu24VC.CHAN_J5, type:"CURRENT", scale: 1000.0)

/*
        J5_V (Channel, description: "J5 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J5, type:"VOLTAGE")

        J5_I (Channel, description: "J5 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J5, type:"CURRENT", scale: 1000.0)
*/
        J6_V (Channel, description: "J6 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J6, type:"VOLTAGE")

        J6_I (Channel, description: "J6 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J6, type:"CURRENT", scale: 1000.0)

        J7_V (Channel, description: "J7 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J7, type:"VOLTAGE")

        J7_I (Channel, description: "J7 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J7, type:"CURRENT", scale: 1000.0)

        J9_V (Channel, description: "J9 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J9, type:"VOLTAGE")

        J9_I (Channel, description: "J9 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J9, type:"CURRENT", scale: 1000.0)

        J10_V (Channel, description: "J10 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J10, type:"VOLTAGE")

        J10_I (Channel, description: "J10 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J10, type:"CURRENT", scale: 1000.0)

        J11_V (Channel, description: "J11 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J11, type:"VOLTAGE")

        J11_I (Channel, description: "J11 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J11, type:"CURRENT", scale: 1000.0)

        J12_V (Channel, description: "J12 voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J12, type:"VOLTAGE")

        J12_I (Channel, description: "J12 current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J12, type:"CURRENT", scale: 1000.0)

    }

    PDU_24VD (ComCamPdu24vdDevice) {
        
        "Main_V" (Channel, description: "24V Dirty PDU main voltage", units: "Volt", format: ".2f",
                       type:"MAINVOLT",checkLo:"alarm", limitLo:0.0, dbandLo:2.0, alarmLo:"Pdu24VDVoltageTooLow")

        "Main_I" (Channel, description: "24V Dirty PDU main current", units: "mA", format: ".1f",
                       type:"MAINCURR", scale: 1000.0)

        "Main_T" (Channel, description: "24V Dirty PDU main temperature", units: "\u00b0C", format: ".1f",
                       type:"MAINTEMP")

        "Board_T" (Channel, description: "24V Dirty PDU board temperature", units: "\u00b0C", format: ".1f",
                        type:"BOARDTEMP")

        "FPGA_T" (Channel, description: "24V Dirty PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                       type:"FPGATEMP")


/*
        Cryo_Turbo_V (Channel, description: "Cryo turbo pump voltage", units: "Volt", format: ".2f",
                      hwChan:ComCamPdu24VD.CHAN_CRYO_TURBO, type:"VOLTAGE")

        Cryo_Turbo_I (Channel, description: "Cryo turbo pump current", units: "mA", format: ".1f",
                      hwChan:ComCamPdu24VD.CHAN_CRYO_TURBO, type:"CURRENT", scale: 1000.0)
*/

        FES_V (Channel, description: "FES voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu24VD.CHAN_FES, type:"VOLTAGE")

        FES_I (Channel, description: "FES current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu24VD.CHAN_FES, type:"CURRENT", scale: 1000.0)
/*
        SW_ION_PUMP      = ComCamPdu24VD.CHAN_ION_PUMP + 256 * DEVC_PDU_24VD,
        SW_CRYO_TURBO    = ComCamPdu24VD.CHAN_CRYO_TURBO + 256 * DEVC_PDU_24VD,
        SW_PFTURBO       = ComCamPdu24VD.CHAN_PFTURBO + 256 * DEVC_PDU_24VD,
        SW_PFSCROLL      = ComCamPdu24VD.CHAN_PFSCROLL + 256 * DEVC_PDU_24VD,
        SW_FES           = ComCamPdu24VD.CHAN_FES + 256 * DEVC_PDU_24VD,
*/
    }

    PDU_48V (ComCamPdu48vDevice) {
        
        "Main_V" (Channel, description: "48V PDU main voltage", units: "Volt", format: ".2f",
                      type:"MAINVOLT",checkLo:"alarm", limitLo:0.0, dbandLo:2.0, alarmLo:"Pdu48VVoltageTooLow")

        "Main_I" (Channel, description: "48V PDU main current", units: "mA", format: ".1f",
                      type:"MAINCURR", scale: 1000.0)

        "Main_T" (Channel, description: "48V PDU main temperature", units: "\u00b0C", format: ".1f",
                      type:"MAINTEMP")

        "Board_T" (Channel, description: "48V PDU board temperature", units: "\u00b0C", format: ".1f",
                       type:"BOARDTEMP")

        "FPGA_T" (Channel, description: "48V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                      type:"FPGATEMP")
/*
        SW_CRYOTEL_CTRL0  = ComCamPdu48V.CHAN_CRYOTEL_CTRL0 + 256 * DEVC_PDU_48V,
        SW_CRYOTEL_CTRL1  = ComCamPdu48V.CHAN_CRYOTEL_CTRL1 + 256 * DEVC_PDU_48V,
        SW_CRYOTEL_CTRL2  = ComCamPdu48V.CHAN_CRYOTEL_CTRL2 + 256 * DEVC_PDU_48V,
        SW_UTC            = ComCamPdu48V.CHAN_UTC           + 256 * DEVC_PDU_48V,
        SW_REB_BULK_0     = ComCamPdu48V.CHAN_REB_BULK      + 256 * DEVC_PDU_48V;
*/


        CryoTel0_V (Channel, description: "CryoTel0 voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu48V.CHAN_CRYOTEL_CTRL0, type:"VOLTAGE")

        CryoTel0_I (Channel, description: "CryoTel0 current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu48V.CHAN_CRYOTEL_CTRL0, type:"CURRENT", scale: 1000.0)

        CryoTel1_V (Channel, description: "CryoTel1 voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu48V.CHAN_CRYOTEL_CTRL1, type:"VOLTAGE")

        CryoTel1_I (Channel, description: "CryoTel1 current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu48V.CHAN_CRYOTEL_CTRL1, type:"CURRENT", scale: 1000.0)

        CryoTel2_V (Channel, description: "CryoTel2 voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu48V.CHAN_CRYOTEL_CTRL2, type:"VOLTAGE")

        CryoTel2_I (Channel, description: "CryoTel2 current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu48V.CHAN_CRYOTEL_CTRL2, type:"CURRENT", scale: 1000.0)

        REB_BULK_V (Channel, description: "REB_BULK voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu48V.CHAN_REB_BULK, type:"VOLTAGE")

        REB_BULK_I (Channel, description: "REB_BULK current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu48V.CHAN_REB_BULK, type:"CURRENT", scale: 1000.0)


//        Purge_Fan_V (Channel, description: "Purge fan voltage", units: "Volt", format: ".2f",
//                     hwChan:ComCamPdu48V.CHAN_PURGE_FAN, type:"VOLTAGE")

//        Purge_Fan_I (Channel, description: "Purge fan current", units: "mA", format: ".1f",
//                     hwChan:ComCamPdu48V.CHAN_PURGE_FAN, type:"CURRENT", scale: 1000.0)

    }

    REB_Bulk_PS (RebBulkPsDevice) {

//        RebBulkPs_Brd_T (Channel, description: "REB Bulk PS board temperature", units: "\u00b0C", format: ".1f",
//                         type:"BOARDTEMP")

//        RebBulkPs_0_V (Channel, description: "REB Bulk PS voltage", units: "Volt", format: ".1f",
//                         hwChan:0, type:"VOLTAGE")

//        RebBulkPs_0_I (Channel, description: "REB Bulk PS current", units: "mA", format: ".1f",
//                         hwChan:0, type:"CURRENT", scale: 1000.0)

//        RebBulkPs_0_T (Channel, description: "REB Bulk PS temperature", units: "\u00b0C", format: ".1f",
//                         hwChan:0, type:"TEMP")

    }

}
