/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.lambda.Cpfe1000;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.PowerDevice;

public class CpfeDevice
extends PowerDevice {
    private static final int TYPE_STATUS = 0;
    private static final int TYPE_TEMPERATURE = 1;
    private static final int TYPE_VOLTAGE = 2;
    private static final int TYPE_CURRENT = 3;
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private final Cpfe1000 cpfe;

    public CpfeDevice() {
        super("CPFE1000F", (PowerSupplyDriver)new Cpfe1000(), null, null, 160, 9, 0, 0);
        this.cpfe = (Cpfe1000)this.psd;
    }

    @Override
    protected void initDevice() {
        super.initDevice();
        this.fullName = "CPFE1000 (" + this.devcId + ":" + this.devcParm + ")";
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        try {
            switch (type) {
                case 0: {
                    value = this.cpfe.readStatus();
                    break;
                }
                case 1: {
                    value = this.cpfe.readTemperature();
                    break;
                }
                case 2: {
                    value = this.cpfe.readVoltage();
                    break;
                }
                case 3: {
                    value = this.cpfe.readCurrent();
                }
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading CPFE1000 data: {0}", e);
            this.setOnline(false);
        }
        return value;
    }

    static {
        typeMap.put("STATUS", 0);
        typeMap.put("TEMP", 1);
        typeMap.put("VOLTAGE", 2);
        typeMap.put("CURRENT", 3);
    }
}

