/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.daq.ims.Camera;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Emulator;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.RegisterClient;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.services.AgentExecutionService;
import org.lsst.ccs.subsystem.focalplane.CCSPlayList;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.SequencerType;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.utilities.readout.ReadOutParametersNew;

public class SequencerConfig
implements ConfigurationBulkChangeHandler {
    private static final Logger LOG = Logger.getLogger(SequencerConfig.class.getName());
    private static final int UNDEFINED = -1;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentExecutionService executionService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(category="Sequencer", maxLength=3)
    private volatile Map<SequencerType, String> sequencer = new HashMap<SequencerType, String>();
    @ConfigurationParameter(category="Sequencer", isReadOnly=true, maxLength=75)
    private volatile Map<SequencerType, Long> sequencerChecksums = new HashMap<SequencerType, Long>();
    @ConfigurationParameter(category="Sequencer", description="Names of meta-data related registers which must be in the sequencer", maxLength=16)
    private volatile String[] metaDataRegisters = ReadOutParametersNew.DEFAULT_NAMES;
    @ConfigurationParameter(category="Sequencer")
    private volatile int preCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int underCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int readCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int postCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int readCols2 = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int overCols = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int preRows = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int readRows = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int postRows = -1;
    @ConfigurationParameter(category="Sequencer")
    private volatile int overRows = -1;
    @ConfigurationParameter(category="Sequencer", description="True if the sequencer is in scan mode", units="unitless")
    private volatile boolean scanMode = false;
    @ConfigurationParameter(category="Sequencer", description="True if the ASPIC is in transparent mode", units="unitless")
    private volatile int transparentMode = -1;
    @ConfigurationParameter(category="Sequencer", description="Name of the clear main", units="unitless")
    private volatile String clearMain = "Clear";
    @ConfigurationParameter(category="Sequencer", description="Name of the idle flush main", units="unitless")
    private volatile String idleFlushMain = "Idle";
    @ConfigurationParameter(category="Sequencer", description="Name of the integrate main", units="unitless")
    private volatile String integrateMain = "Integrate";
    @ConfigurationParameter(category="Sequencer", description="Name of the row shift reverse main", units="unitless")
    private volatile String rowShiftReverseMain = "RowShiftR";
    @ConfigurationParameter(category="Sequencer", description="Name of the row shift forward main", units="unitless")
    private volatile String rowShiftForwardMain = "RowShiftF";
    @ConfigurationParameter(category="Sequencer", description="Name of the read main", units="unitless")
    private volatile String readMain = "Read";
    @ConfigurationParameter(category="Sequencer", description="Name of the pseudo read main", units="unitless")
    private volatile String pseudoReadMain = "PseudoRead";
    @ConfigurationParameter(category="Sequencer", description="Idle time in milliseconds before sequencer will enter IDLE_FLUSH. Can be zero (enter immeidately) or negative (never)", units="unitless")
    private volatile long idleFlushTimeout = -1L;
    @ConfigurationParameter(category="Sequencer", description="Name of the clear count parameter", units="unitless")
    private volatile String clearCountParameter = "ClearCount";
    @ConfigurationParameter(category="Sequencer", description="Name of the shift count parameter", units="unitless")
    private volatile String shiftCountParameter = "ShiftCount";
    @ConfigurationParameter(category="Sequencer", description="Read all registers in parallel when waiting for sequencers to stop", units="unitless")
    private volatile boolean useParallelRegisters = false;
    @ConfigurationParameter(category="Sequencer", description="Perform a step rather than stop after integrate", units="unitless")
    private volatile boolean stepAfterIntegrate = false;
    @ConfigurationParameter(category="DAQ", description="Folder in 2-day store where images will be created", units="unitless")
    private volatile String daqFolder = "raw";
    @ConfigurationParameter(category="DAQ", description="DAQ partition", units="unitless")
    private volatile String daqPartition = "camera";
    @ConfigurationParameter(category="DAQ", description="True when using an emulated DAQ", units="unitless")
    private volatile boolean emulatedDAQ = false;
    @ConfigurationParameter(category="DAQ", description="Number of bad pixels allowed before alarm raised", units="unitless")
    private volatile int badPixelAlarmLimit = 20000;
    private volatile List<ImageListener> imageListeners = new CopyOnWriteArrayList<ImageListener>();
    private volatile Map<SequencerType, Long> newChecksums;
    private volatile Store store;
    private CCSPlayList currentPlaylist;

    public Map<SequencerType, String> getSequencers() {
        return this.sequencer;
    }

    public String[] getMetaDataRegisters() {
        return this.metaDataRegisters;
    }

    void setTestSequencers(Map<SequencerType, String> sequencers) {
        this.sequencer = sequencers;
        this.pseudoReadMain = "PsuedoRead";
    }

    public String getDAQFolder() {
        return this.daqFolder;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        Map sequencerMap = (Map)parametersView.get("sequencer");
        if (sequencerMap.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequencer map");
        }
        this.newChecksums = new HashMap<SequencerType, Long>();
        sequencerMap.forEach((sequencerType, SequencerName) -> {
            try {
                List<String> mains = Arrays.asList(parametersView.get("clearMain").toString(), parametersView.get("idleFlushMain").toString(), parametersView.get("integrateMain").toString(), parametersView.get("pseudoReadMain").toString(), parametersView.get("readMain").toString(), parametersView.get("rowShiftForwardMain").toString(), parametersView.get("rowShiftReverseMain").toString());
                ArrayList<String> parameters = new ArrayList<String>(Arrays.asList((String[])parametersView.get("metaDataRegisters")));
                parameters.addAll(Arrays.asList(parametersView.get("clearCountParameter").toString(), parametersView.get("shiftCountParameter").toString()));
                FPGA2Model model = Sequencers.validate(mains, parameters, SequencerName);
                this.newChecksums.put((SequencerType)sequencerType, model.computeCheckSum());
            }
            catch (IOException | REBException | RaftException ex) {
                throw new IllegalArgumentException("Invalid sequencer file " + SequencerName, ex);
            }
        });
    }

    public void setParameterBulk(Map<String, Object> parametersView) {
        if (parametersView.containsKey("daqPartition")) {
            try {
                if (this.store != null) {
                    this.store.close();
                    if (!this.imageListeners.isEmpty()) {
                        this.store = new Store(parametersView.get("daqPartition").toString(), (ExecutorService)this.executionService);
                        for (ImageListener l : this.imageListeners) {
                            this.store.addImageListener(l);
                        }
                    } else {
                        this.store = null;
                    }
                }
            }
            catch (DAQException ex) {
                LOG.log(Level.WARNING, "Unable to close old DAQ store", ex);
            }
        }
        super.setParameterBulk(parametersView);
        this.sequencerChecksums = this.newChecksums;
    }

    Map<String, Integer> loadParameters(FPGA2Model model, SequencerProc seq) throws REBException, RaftException {
        LinkedHashMap<String, Integer> cache = new LinkedHashMap<String, Integer>();
        this.setParameter(seq, model, cache, "PreCols", this.preCols);
        this.setParameter(seq, model, cache, "UnderCols", this.underCols);
        this.setParameter(seq, model, cache, "ReadCols", this.readCols);
        this.setParameter(seq, model, cache, "PostCols", this.postCols);
        this.setParameter(seq, model, cache, "ReadCols2", this.readCols2);
        this.setParameter(seq, model, cache, "OverCols", this.overCols);
        this.setParameter(seq, model, cache, "PreRows", this.preRows);
        this.setParameter(seq, model, cache, "ReadRows", this.readRows);
        this.setParameter(seq, model, cache, "PostRows", this.postRows);
        this.setParameter(seq, model, cache, "OverRows", this.overRows);
        seq.enableScan(this.scanMode);
        return cache;
    }

    private void setParameter(SequencerProc seq, FPGA2Model model, Map<String, Integer> cache, String name, int value) throws REBException, RaftException {
        FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)model.getPointerMap().get(name);
        if (pi == null) {
            throw new RaftException("Invalid pointer " + name);
        }
        int actualValue = value != -1 ? value : pi.getValue();
        seq.setParameter(name, actualValue);
        cache.put(name, actualValue);
    }

    boolean hasEmulatedDAQ() {
        return this.emulatedDAQ;
    }

    boolean isScanMode() {
        return this.scanMode;
    }

    Store getStore() throws DAQException {
        if (this.store == null) {
            this.store = new Store(this.daqPartition, (ExecutorService)this.executionService);
        }
        return this.store;
    }

    Camera getCamera() throws DAQException {
        return this.getStore().getCamera();
    }

    Emulator getEmulator() throws DAQException {
        return this.getStore().getEmulator();
    }

    RegisterClient getRegisterClient() throws DAQException {
        return this.getStore().getRegisterClient();
    }

    String getPartition() {
        return this.daqPartition;
    }

    Boolean getTranparentMode() {
        return this.transparentMode == -1 ? null : Boolean.valueOf(this.transparentMode == 1);
    }

    public String getClearMain() {
        return this.clearMain;
    }

    public String getIdleFlushMain() {
        return this.idleFlushMain;
    }

    public String getIntegrateMain() {
        return this.stepAfterIntegrate ? "IntegrateRead" : this.integrateMain;
    }

    public String getRowShiftReverseMain() {
        return this.rowShiftReverseMain;
    }

    public String getRowShiftForwardMain() {
        return this.rowShiftForwardMain;
    }

    public String getPseudoReadMain() {
        return this.pseudoReadMain;
    }

    public String getClearCountParameter() {
        return this.clearCountParameter;
    }

    public List<String> getRequiredMains() {
        return Arrays.asList(this.clearMain, this.idleFlushMain, this.integrateMain, this.pseudoReadMain, this.readMain, this.rowShiftForwardMain, this.rowShiftReverseMain);
    }

    public List<String> getRequiredParameters() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(this.metaDataRegisters));
        result.addAll(Arrays.asList(this.clearCountParameter, this.shiftCountParameter));
        return result;
    }

    public String getShiftCountParameter() {
        return this.shiftCountParameter;
    }

    public String getReadMain() {
        return this.readMain;
    }

    public long getIdleFlushTimeout() {
        return this.idleFlushTimeout;
    }

    public boolean useParallelRegisters() {
        return this.useParallelRegisters;
    }

    public boolean useStepAfterIntegrate() {
        return this.stepAfterIntegrate;
    }

    public String getIntegrateAfterPointer() {
        return "AfterIntegrate";
    }

    public String getReadSubroutine() {
        return "ReadFrame";
    }

    String getPseudoSubroutine() {
        return "PseudoFrame";
    }

    String getNoOpSubroutine() {
        return "NoOp";
    }

    void commitBulkChange() {
        this.sce.commitBulkChange();
    }

    int getBadPixelAlarmLimit() {
        return this.badPixelAlarmLimit;
    }

    Path getPlaylistBaseDir() throws IOException {
        Path patternDir = Paths.get(System.getProperty("user.home"), "playlists");
        Files.createDirectories(patternDir, new FileAttribute[0]);
        return patternDir;
    }

    void addDAQImageListener(ImageListener imageListener) throws DAQException {
        this.getStore().addImageListener(imageListener);
        this.imageListeners.add(imageListener);
    }

    void removeDAQImageListener(ImageListener imageListener) throws DAQException {
        this.getStore().removeImageListener(imageListener);
        this.imageListeners.remove(imageListener);
    }

    CCSPlayList getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    void setCurrentPlaylist(CCSPlayList cpl) {
        this.currentPlaylist = cpl;
    }
}

