import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.mmm.MMM;
import org.lsst.ccs.subsystem.mmm.Minion;
import org.lsst.ccs.subsystem.mmm.MinionGroup;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertHandler;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.AlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.EmailAlertDeliveryStrategy;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher.CommandAlertAction;
import org.lsst.ccs.subsystem.mmm.AlertDispatcher;
import org.lsst.ccs.subsystem.mmm.AlertNotification;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.bus.states.AlertState;
import java.util.function.Predicate;
import java.time.Duration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

CCSBuilder builder = ["ats-mmm"]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def isSimulated = props.getProperty("org.lsst.ccs.run.mode", "normal").equals("simulation")


def fromEmail = isSimulated ? "SIMULATED-ccs-alarm@lsst-mmm.slac.stanford.edu" : "ats@lsst.org"
def replyToEmail = isSimulated ? "SIMULATED-lsstcam-opsprob@slac.stanford.edu" : "tonyj@stanford.edu";

def infrastructureList = ["turri@slac.stanford.edu", "tonyj@stanford.edu"];
def atsList = isSimulated ? infrastructureList : ["turri@slac.stanford.edu","tonyj@stanford.edu"];



builder.
    main(MMM, 
        minions:[(MinionGroup.INFRASTRUCTURE):["localdb":Minion.LOCALBD, "rest-server":Minion.REST_SERVER, "ats-mmm":Minion.MMM, "cluster-monitor":Minion.CLUSTER_MONITOR],
                 (MinionGroup.ATS) :["ats":Minion.VACUUM, "ats-fp":Minion.FOCAL_PLANE, "ats-power":Minion.POWER,
                           "ats-ih":Minion.IMAGE_HANDLER, "ats-daq-monitor":Minion.DAQ_MONITOR, "bonn-shutter":Minion.SHUTTER,
                           "mcm-atcamera":Minion.MCM, "ocs-bridge-atcamera":Minion.OCSBRIDGE]
                ] ) {

    infrastructure (AlertDispatcher, group: MinionGroup.INFRASTRUCTURE) {
        infrastructureEmailNotification (AlertHandler, handlerName: "infrastructureEmailNotification") {
            infrastructurePublicMailAction (EmailAlertAction, emailList: infrastructureList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", smtpHost:"mail.lsst.org") {
                localDbEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: false, origin:"localdb", maxAccumulation: Duration.ofMinutes(30))
                defaultEmailStrategy (EmailAlertDeliveryStrategy, sendFirstEmail: true, origin:".*", maxAccumulation: Duration.ofMinutes(0))
            }
        }        
    }
    

    ats (AlertDispatcher, group: MinionGroup.ATS) {
        atsEmailNotification (AlertHandler, handlerName: "atsEmailNotification") {
             atsPublicMailAction (EmailAlertAction, emailList: atsList, fromEmail:"$fromEmail", replyToEmail:"$replyToEmail", smtpHost:"mail.lsst.org")
        }        
    }
}