/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.sal.SAL;
import org.lsst.sal.atcamera.ATCamera;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.SALCamera;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.cccamera.CCCamera;

public class OCSBridgeConfig {
    @ConfigurationParameter
    private Device device = Device.CAMERA;
    @ConfigurationParameter
    private final int numCCDs = 9;
    @ConfigurationParameter
    private final boolean hasFilterChanger = true;
    @ConfigurationParameter
    private String mcmName = "mcm";
    @ConfigurationParameter
    private String[] listenSubsystems = new String[0];
    @ConfigurationParameter
    private String ccdNames;
    @ConfigurationParameter
    private ImageReadoutParametersEvent.CcdType[] ccdType;
    @ConfigurationParameter
    private int[] overRows;
    @ConfigurationParameter
    private int[] overCols;
    @ConfigurationParameter
    private int[] readRows;
    @ConfigurationParameter
    private int[] readCols;
    @ConfigurationParameter
    private int[] readCols2;
    @ConfigurationParameter
    private int[] preCols;
    @ConfigurationParameter
    private int[] preRows;
    @ConfigurationParameter
    private int[] postCols;

    public boolean hasFilterChanger() {
        return true;
    }

    public int numCCDs() {
        return 9;
    }

    public String ccdNames() {
        return this.ccdNames;
    }

    public ImageReadoutParametersEvent.CcdType[] ccdType() {
        return this.ccdType;
    }

    public int[] overRows() {
        return this.overRows;
    }

    public int[] overCols() {
        return this.overCols;
    }

    public int[] readRows() {
        return this.readRows;
    }

    public int[] readCols() {
        return this.readCols;
    }

    public int[] readCols2() {
        return this.readCols2;
    }

    public int[] preCols() {
        return this.preCols;
    }

    public int[] preRows() {
        return this.preRows;
    }

    public int[] postCols() {
        return this.postCols;
    }

    public String getMCMName() {
        return this.mcmName;
    }

    public Device getDevice() {
        return this.device;
    }

    public String[] getListenSubsystems() {
        return this.listenSubsystems;
    }

    SAL<CameraCommand, CameraEvent, CameraTelemetry> getSALManager() {
        return OCSBridgeConfig.createSALManager(this.device);
    }

    static SAL<CameraCommand, CameraEvent, CameraTelemetry> createSALManager(Device device) {
        switch (device) {
            case CAMERA: {
                return SALCamera.create();
            }
            case AUXTEL: {
                return ATCamera.create();
            }
            case COMCAM: {
                return CCCamera.create();
            }
        }
        throw new UnsupportedOperationException("Device not yet supported: " + (Object)((Object)device));
    }

    static OCSBridgeConfig createDefaultConfig() {
        OCSBridgeConfig config = new OCSBridgeConfig();
        CharSequence[] ccdNameArray = new String[]{"E2V-CCD250-260", "E2V-CCD250-182", "E2V-CCD250-175", "E2V-CCD250-167", "E2V-CCD250-195", "E2V-CCD250-201", "E2V-CCD250-222", "E2V-CCD250-213", "E2V-CCD250-177"};
        config.ccdNames = String.join((CharSequence)":", ccdNameArray);
        config.ccdType = new ImageReadoutParametersEvent.CcdType[]{ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V, ImageReadoutParametersEvent.CcdType.E2V};
        config.overRows = new int[]{46, 46, 46, 46, 46, 46, 46, 46, 46};
        config.overCols = new int[]{53, 53, 53, 53, 53, 53, 53, 53, 53};
        config.readRows = new int[]{2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002};
        config.readCols = new int[]{512, 512, 512, 512, 512, 512, 512, 512, 512};
        config.readCols2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        config.preCols = new int[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
        config.preRows = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        config.postCols = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        return config;
    }

    public static enum Device {
        CAMERA,
        AUXTEL,
        COMCAM;

    }
}

