/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_BFRTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VCTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_24VDTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_48VTelemetry;
import org.lsst.sal.cccamera.telemetry.Quadbox_PDU_5VTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Rebpower_RebpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class ComCamTelemetrySender
extends TelemetrySender {
    private final GenericConverter converter;

    public ComCamTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        HashMap<String, String> nameChange = new HashMap<String, String>();
        nameChange.put("ionpumpsvoltage", "ionpumpvoltage");
        nameChange.put("ionpumpscurrent", "ionpumpcurrent");
        nameChange.put("turborpm", "rpm");
        nameChange.put("pdu5votm3bi", "otm0bi");
        nameChange.put("pdu5votm3bv", "otm0bv");
        nameChange.put("pdu5votm3ai", "otm0ai");
        nameChange.put("pdu5votm3av", "otm0av");
        HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
        subSystemClasses.put(Vacuum_Cold1Telemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_Cold2Telemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_CryoTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_TurboTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_VQMonitorTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_IonPumpsTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Rebpower_RebTelemetry.class, "comcam-rebpower");
        subSystemClasses.put(Rebpower_RebpsTelemetry.class, "comcam-rebpower");
        subSystemClasses.put(Quadbox_BFRTelemetry.class, "comcam-quadbox");
        subSystemClasses.put(Quadbox_PDU_24VCTelemetry.class, "comcam-quadbox");
        subSystemClasses.put(Quadbox_PDU_24VDTelemetry.class, "comcam-quadbox");
        subSystemClasses.put(Quadbox_PDU_48VTelemetry.class, "comcam-quadbox");
        subSystemClasses.put(Quadbox_PDU_5VTelemetry.class, "comcam-quadbox");
        subSystemClasses.put(Daq_monitor_StoreTelemetry.class, "comcam-daq-monitor");
        subSystemClasses.put(Fp_CcdTelemetry.class, "comcam-fp");
        subSystemClasses.put(Fp_RebTelemetry.class, "comcam-fp");
        subSystemClasses.put(Fp_RebTotalPowerTelemetry.class, "comcam-fp");
        this.converter = new GenericConverter(subSystemClasses, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return this.converter;
    }
}

