/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.daq;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.daq.ims.DAQDriverStats;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQFirmwareStats;
import org.lsst.ccs.daq.ims.DAQRdsStats;
import org.lsst.ccs.daq.ims.DAQRmsStats;
import org.lsst.ccs.daq.ims.Stats;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.daq.alerts.DaqSubsystemAlerts;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class DaqStatsMonitor
implements HasLifecycle,
ConfigurationBulkChangeHandler,
HasDataProviderInfos {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dataProviderDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alert;
    private String partition;
    private String fullName;
    private boolean online;
    private boolean inited = false;
    private boolean firstRead = true;
    private boolean alertWarning = false;
    private Stats stats;
    private Store store;
    private static final Logger LOG = Logger.getLogger(DaqStatsMonitor.class.getName());
    private final LocationSet locSetAll;
    private LocationSet locSet = this.locSetAll = LocationSet.all();
    private final Duration publishInterval = Duration.ofSeconds(15L);
    private Map<String, Long> currentSums = new HashMap<String, Long>(40);
    private Map<String, Long> previousSums = new HashMap<String, Long>(40);
    @ConfigurationParameter(isBuild=true, description="enable periodic publication")
    volatile boolean enablePeriodicPublication;
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=15, description="Driver Stats for sums over location")
    protected volatile List<String> sumDriverStats = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=30, description="Firmware Stats for sums over location")
    protected volatile List<String> sumFirmwareStats = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=15, description="Rds Stats for sums over location")
    protected volatile List<String> sumRdsStats = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=15, description="Rms Stats for sums over location")
    protected volatile List<String> sumRmsStats = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=15, description="Driver Stats for warnings on sums")
    protected volatile List<String> sumDriverChecks = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=30, description="Firmware Stats for warnings on sums")
    protected volatile List<String> sumFirmwareChecks = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=15, description="Rds Stats for warnings on sums")
    protected volatile List<String> sumRdsChecks = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true, category="Statistics", maxLength=15, description="Rms Stats for warnings on sums")
    protected volatile List<String> sumRmsChecks = new ArrayList<String>();
    @ConfigurationParameter(category="Statistics", description="minimum difference between successive reads to put warning in log")
    protected volatile Integer minDiffLogWarning;
    @ConfigurationParameter(category="Statistics", description="minimum difference between successive reads to raise Alert at warning level")
    protected volatile Integer minDiffAlertWarning;

    public boolean isOnline() {
        return this.online;
    }

    public void build() {
        Runnable publishStats = new Runnable(){

            @Override
            public void run() {
                try {
                    for (Location loc : DaqStatsMonitor.this.locSet) {
                        DaqStatsMonitor.this.agent.publishSubsystemDataOnStatusBus(DaqStatsMonitor.this.getDataForLocation(loc));
                    }
                    DaqStatsMonitor.this.agent.publishSubsystemDataOnStatusBus(DaqStatsMonitor.this.getSummedData());
                    if (!DaqStatsMonitor.this.firstRead) {
                        DaqStatsMonitor.this.checkDifferences(DaqStatsMonitor.this.currentSums, DaqStatsMonitor.this.previousSums);
                    } else {
                        DaqStatsMonitor.this.firstRead = false;
                    }
                    DaqStatsMonitor.this.previousSums.putAll(DaqStatsMonitor.this.currentSums);
                }
                catch (DAQException ex) {
                    LOG.warning("DAQ Exception while acquiring data for publication: " + (Object)((Object)ex));
                }
            }
        };
        if (this.enablePeriodicPublication) {
            AgentPeriodicTask periodicTask = new AgentPeriodicTask("publishStats", publishStats).withPeriod(this.publishInterval);
            this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
            LOG.info(this.name + "  publication of trending data is enabled");
        } else {
            LOG.info(this.name + "  publication of trending data is disabled");
        }
    }

    void setPartition(String pname) {
        this.partition = pname;
    }

    public void init() {
        this.fullName = this.name + ": (partition" + this.partition + ")";
        try {
            if (this.stats != null) {
                this.close();
            }
            this.stats = new Stats(this.partition);
            this.online = true;
            LOG.info("\n " + this.name + " Connected to DAQ partition " + this.partition);
            this.store = new Store(this.partition);
            this.locSet = this.store.getConfiguredSources();
            this.store.close();
            LOG.info(this.name + String.format(":  using %d DAQ configured locations", this.locSet.size()));
            if (!this.locSet.iterator().hasNext()) {
                throw new RuntimeException(this.name + ":  there are no configured locations");
            }
            Location loc = (Location)this.locSet.iterator().next();
            Map map = this.stats.getDAQDriverStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumDriverStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumDriverStats", (String)(par + " is invalid entry"));
            }
            map = this.stats.getDAQFirmwareStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumFirmwareStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumFirmwareStats", (String)(par + " is invalid entry"));
            }
            map = this.stats.getDAQRdsStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumRdsStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumRdsStats", (String)(par + " is invalid entry"));
            }
            map = this.stats.getDAQRmsStats(loc, Stats.Clear.NO).getMap();
            for (String par : this.sumRmsStats) {
                if (map.containsKey(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumRmsStats", (String)(par + " is invalid entry"));
            }
            for (String par : this.sumDriverChecks) {
                if (this.sumDriverStats.contains(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumDriverChecks", (String)(par + "is invalid entry"));
            }
            for (String par : this.sumFirmwareChecks) {
                if (this.sumFirmwareStats.contains(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumFirmwareChecks", (String)(par + "is invalid entry"));
            }
            for (String par : this.sumRdsChecks) {
                if (this.sumRdsStats.contains(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumRdsChecks", (String)(par + "is invalid entry"));
            }
            for (String par : this.sumRmsChecks) {
                if (this.sumRmsStats.contains(par)) continue;
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"sumRmsChecks", (String)(par + "is invalid entry"));
            }
        }
        catch (DAQException ex) {
            if (!this.inited) {
                throw new RuntimeException("DAQException while connecting to " + this.fullName + ":  " + ex.getMessage());
            }
            try {
                this.close();
            }
            catch (DAQException map) {
                // empty catch block
            }
        }
        this.inited = true;
        if (this.enablePeriodicPublication) {
            for (Location loc : this.locSet) {
                this.registerDataForLocation(loc);
            }
            LOG.info(this.name + " Registration of Stats data complete");
        }
    }

    void close() throws DAQException {
        if (this.stats != null) {
            this.stats.close();
            this.stats = null;
            this.online = false;
        }
    }

    public void validateBulkChange(Map<String, Object> params) {
        String msg;
        Integer logWarningParam = (Integer)params.get("minDiffLogWarning");
        Integer alertWarningParam = (Integer)params.get("minDiffAlertWarning");
        if (logWarningParam == null || logWarningParam <= 0) {
            msg = " is invalid";
            if (this.inited) {
                throw new RuntimeException(this.name + ": minDiffLogWarning" + msg);
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"minDiffLogWarning", (String)msg);
        }
        if (alertWarningParam == null || alertWarningParam <= 0) {
            msg = " is invalid";
            if (this.inited) {
                throw new RuntimeException(this.name + ": minDiffAlertWarning" + msg);
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"minDiffAlertWarning", (String)msg);
        }
        if (alertWarningParam < logWarningParam) {
            msg = " shou;d not be less than mindiffLogwarning";
            if (this.inited) {
                throw new RuntimeException(this.name + ": minDiffAlertWarning" + msg);
            }
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"minDiffAlertWarning", (String)msg);
        }
    }

    private KeyValueData getDataForLocation(Location location) throws DAQException {
        KeyValueDataList list = new KeyValueDataList();
        String lname = location.toString();
        list.addData(lname + "/Rms", (Serializable)this.stats.getDAQRmsStats(location, Stats.Clear.NO));
        list.addData(lname + "/Rds", (Serializable)this.stats.getDAQRdsStats(location, Stats.Clear.NO));
        list.addData(lname + "/Driver", (Serializable)this.stats.getDAQDriverStats(location, Stats.Clear.NO));
        list.addData(lname + "/Firmware", (Serializable)this.stats.getDAQFirmwareStats(location, Stats.Clear.NO));
        return list;
    }

    private void registerDataForLocation(Location location) {
        String lname = location.toString();
        this.dataProviderDictionaryService.registerClass(DAQRmsStats.class, lname + "/Rms");
        this.dataProviderDictionaryService.registerClass(DAQRdsStats.class, lname + "/Rds");
        this.dataProviderDictionaryService.registerClass(DAQDriverStats.class, lname + "/Driver");
        this.dataProviderDictionaryService.registerClass(DAQFirmwareStats.class, lname + "/Firmware");
    }

    private KeyValueData getSummedData() throws DAQException {
        long sum;
        KeyValueDataList list = new KeyValueDataList();
        for (String key : this.sumDriverStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQDriverStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Driver/" + key, (Serializable)Long.valueOf(sum));
            if (!this.sumDriverChecks.contains(key)) continue;
            this.currentSums.put("Sum/Driver/" + key, sum);
        }
        for (String key : this.sumFirmwareStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQFirmwareStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Firmware/" + key, (Serializable)Long.valueOf(sum));
            if (!this.sumFirmwareChecks.contains(key)) continue;
            this.currentSums.put("Sum/Firmware/" + key, sum);
        }
        for (String key : this.sumRdsStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQRdsStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Rds/" + key, (Serializable)Long.valueOf(sum));
            if (!this.sumRdsChecks.contains(key)) continue;
            this.currentSums.put("Sum/Rds/" + key, sum);
        }
        for (String key : this.sumRmsStats) {
            sum = 0L;
            for (Location loc : this.locSet) {
                sum += this.stats.getDAQRmsStats(loc, Stats.Clear.NO).getStatistic(key).longValue();
            }
            list.addData("Sum/Rms/" + key, (Serializable)Long.valueOf(sum));
            if (!this.sumRmsChecks.contains(key)) continue;
            this.currentSums.put("Sum/Rms/" + key, sum);
        }
        return list;
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        DataProviderInfo dataProviderInfo;
        String path;
        HashMap<DataProviderInfo.Attribute, String> attributes = new HashMap<DataProviderInfo.Attribute, String>();
        attributes.put(DataProviderInfo.Attribute.UNITS, "unitless");
        ArrayList<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
        for (String key : this.sumDriverStats) {
            path = "Sum/Driver/" + key;
            dataProviderInfo = new DataProviderInfo(path, DataProviderInfo.Type.TRENDING, path, attributes);
            list.add(dataProviderInfo);
        }
        for (String key : this.sumFirmwareStats) {
            path = "Sum/Firmware/" + key;
            dataProviderInfo = new DataProviderInfo(path, DataProviderInfo.Type.TRENDING, path, attributes);
            list.add(dataProviderInfo);
        }
        for (String key : this.sumRdsStats) {
            path = "Sum/Rds/" + key;
            dataProviderInfo = new DataProviderInfo(path, DataProviderInfo.Type.TRENDING, path, attributes);
            list.add(dataProviderInfo);
        }
        for (String key : this.sumRmsStats) {
            path = "Sum/Rms/" + key;
            dataProviderInfo = new DataProviderInfo(path, DataProviderInfo.Type.TRENDING, path, attributes);
            list.add(dataProviderInfo);
        }
        return list;
    }

    public void publishDataProviderCurrentData(AgentInfo a) {
    }

    private void checkDifferences(Map<String, Long> currentSums, Map<String, Long> previousSums) {
        if (!currentSums.equals(previousSums)) {
            for (String key : currentSums.keySet()) {
                Long diff = currentSums.get(key) - previousSums.get(key);
                if (diff >= (long)this.minDiffAlertWarning.intValue()) {
                    this.alert.raiseAlert(DaqSubsystemAlerts.STATS_DIFF.newAlert(), AlertState.WARNING, key + " increment = " + Long.toString(diff));
                    this.alertWarning = true;
                    continue;
                }
                if (diff < (long)this.minDiffLogWarning.intValue()) continue;
                LOG.warning(this.name + ": " + key + " increment = " + Long.toString(diff));
            }
        } else if (this.alertWarning) {
            this.alert.raiseAlert(DaqSubsystemAlerts.STATS_DIFF.newAlert(), AlertState.NOMINAL, "");
            this.alertWarning = false;
        }
    }

    private String makeStatsTable(String sname, Map<String, Long> statMap, String location) {
        Set<String> keys = statMap.keySet();
        String table = "DAQ " + sname + " Stats for " + location + "\n" + this.timestamp() + "\n";
        for (String key : keys) {
            table = table + String.format("\n  %-22s %d", key, statMap.get(key));
        }
        table = table + "\n";
        return table;
    }

    @Command(type=Command.CommandType.QUERY, name="readAllStats", level=0, description="Read all sets of DAQ stats")
    public String readAllStats(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        return "\n" + this.readAllRms(location) + "\n" + this.readAllRds(location) + "\n" + this.readAllDriver(location) + "\n" + this.readAllFirmware(location) + "\n";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllStats", level=1, description="Read and clear all sets of DAQ stats for location")
    public String clearAllStats(@Argument(name="location", description="clearout board in format R<nn>/Reb<m>") String location) throws DAQException {
        return "\n" + this.clearAllRms(location) + "\n" + this.clearAllRds(location) + "\n" + this.clearAllDriver(location) + "\n" + this.clearAllFirmware(location) + "\n";
    }

    @Command(type=Command.CommandType.ACTION, name="clearStatsAllLocations", level=1, description="Clear all DAQ stats for all locations")
    public String clearStatsAllLocations() throws DAQException {
        String readStats = "";
        for (Location loc : this.locSet) {
            readStats = readStats + this.clearAllStats(loc.toString());
        }
        return "DAQ Stats registers cleared for all locations";
    }

    @Command(type=Command.CommandType.QUERY, name="readAllRms", level=0, description="Read all DAQ Rms stats")
    public String readAllRms(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = rmsStats.getMap();
        return this.makeStatsTable("Rms", statMap, location);
    }

    @Command(type=Command.CommandType.QUERY, name="readAllRds", level=0, description="Read all DAQ Rds stats")
    public String readAllRds(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = rdsStats.getMap();
        return this.makeStatsTable("Rds", statMap, location);
    }

    @Command(type=Command.CommandType.QUERY, name="readAllDriver", level=0, description="Read all DAQ Driver stats")
    public String readAllDriver(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = driverStats.getMap();
        return this.makeStatsTable("Driver", statMap, location);
    }

    @Command(type=Command.CommandType.QUERY, name="readAllFirmware", level=0, description="Read all DAQ Firmware stats")
    public String readAllFirmware(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.NO);
        Map statMap = firmwareStats.getMap();
        return this.makeStatsTable("Firmware", statMap, location);
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllRms", level=1, description="Read and clear DAQ Rms stats")
    public String clearAllRms(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = rmsStats.getMap();
        return this.makeStatsTable("Rms", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllRds", level=1, description="Read and clear DAQ Rds stats")
    public String clearAllRds(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = rdsStats.getMap();
        return this.makeStatsTable("Rds", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllDriver", level=1, description="Read and clear DAQ Driver stats")
    public String clearAllDriver(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = driverStats.getMap();
        return this.makeStatsTable("Driver", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.ACTION, name="clearAllFirmware", level=1, description="Read and clear DAQ Firmware stats")
    public String clearAllFirmware(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.YES);
        Map statMap = firmwareStats.getMap();
        return this.makeStatsTable("Firmware", statMap, location) + "Cleared";
    }

    @Command(type=Command.CommandType.QUERY, name="readRmsStat", level=0, description="read specified DAQ Rms statistic for specified locaation")
    public String readRmsStat(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQRmsStats rmsStats = this.stats.getDAQRmsStats(Location.of((String)location), Stats.Clear.NO);
        return rmsStats.getStatistic(quantity).toString();
    }

    @Command(type=Command.CommandType.QUERY, name="readRdsStat", level=0, description="read specified DAQ Rds statistic for specified locaation")
    public String readRdsStat(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQRdsStats rdsStats = this.stats.getDAQRdsStats(Location.of((String)location), Stats.Clear.NO);
        return rdsStats.getStatistic(quantity).toString();
    }

    @Command(type=Command.CommandType.QUERY, name="readDriverStat", level=0, description="read specified DAQ Driver statistic for specified locaation")
    public String readDriverStat(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQDriverStats driverStats = this.stats.getDAQDriverStats(Location.of((String)location), Stats.Clear.NO);
        return driverStats.getStatistic(quantity).toString();
    }

    @Command(type=Command.CommandType.QUERY, name="readFirmwareStat", level=0, description="read specified DAQ Firmware statistic for specified locaation")
    public String readFirmwareStat(@Argument(name="location", description="readout board in format R<nn>/Reb<m>") String location, @Argument(name="statistic name") String quantity) throws DAQException {
        DAQFirmwareStats firmwareStats = this.stats.getDAQFirmwareStats(Location.of((String)location), Stats.Clear.NO);
        return firmwareStats.getStatistic(quantity).toString();
    }

    @Command(name="timestamp", description="Prints current time", type=Command.CommandType.QUERY, level=0)
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }
}

