/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.TPG361;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class Pfeiffer361Device
extends Device {
    public static final int CHAN_PRESSURE = 0;
    public static final int NUM_CHANS = 1;
    private String devcName;
    private int baudRate = 0;
    private static final Logger LOG = Logger.getLogger((String)Pfeiffer361Device.class.getName());
    private final TPG361 tpg = new TPG361();

    protected void initDevice() {
        if (this.devcName == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcName", (String)"is not specified");
        }
        this.fullName = "Pfeiffer TPC361 (" + this.devcName + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.tpg.openSerial(this.devcName, this.baudRate);
                this.initSensors();
                this.setOnline(true);
                LOG.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    public void close() {
        try {
            this.tpg.close();
        }
        catch (DriverException e) {
            LOG.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 1) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        double value = Double.NaN;
        try {
            switch (chan) {
                case 0: {
                    value = this.tpg.readPressure()[0];
                }
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading channel " + chan + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
        return value;
    }
}

