import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.ats.AtsMain
import org.lsst.ccs.subsystem.ats.CryoCon24cMonDevice
import org.lsst.ccs.subsystem.ats.Pfeiffer361Device
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["ats"]

builder.main (AtsMain) {

    CryoCon (CryoCon24cMonDevice, host:"192.168.1.5") {

        TempCCD       (Channel, description:"CCD temperature", units:"\u00b0C", hwChan:CryoCon24cMonDevice.CHAN_TEMP_A, offset:-273.15)

        TempCryoHead  (Channel, description:"Cryo head temperature", units:"\u00b0C", hwChan:CryoCon24cMonDevice.CHAN_TEMP_B, offset:-273.15)

        TempColdPlate (Channel, description:"Cold plate temperature", units:"\u00b0C", hwChan:CryoCon24cMonDevice.CHAN_TEMP_C, offset:-273.15)

    }

    Pfeiffer (Pfeiffer361Device, devcName:"/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_AH05GXXF-if00-port0") {

        Vacuum (Channel, description:"Cryo vacuum", units:"Torr", format:".3g", hwChan:Pfeiffer361Device.CHAN_PRESSURE)

    }

}
