/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CryoCon24cMonDevice
extends Device {
    public static final int CHAN_CURR_TEMP = 0;
    public static final int CHAN_RUN_TEMP = 1;
    public static final int CHAN_TEMP_STDDEV = 2;
    public static final int CHAN_HTR_1 = 3;
    public static final int CHAN_HTR_2 = 4;
    public static final int CHAN_TEMP_A = 5;
    public static final int CHAN_TEMP_B = 6;
    public static final int CHAN_TEMP_C = 7;
    public static final int CHAN_TEMP_D = 8;
    public static final int CHAN_PID_P_1 = 9;
    public static final int CHAN_PID_I_1 = 10;
    public static final int CHAN_PID_D_1 = 11;
    public static final int CHAN_PID_P_2 = 12;
    public static final int CHAN_PID_I_2 = 13;
    public static final int CHAN_PID_D_2 = 14;
    public static final int CHAN_TEMP_CHNG = 15;
    public static final int CHAN_SETPOINT_1 = 16;
    public static final int CHAN_SETPOINT_2 = 17;
    public static final int NUM_CHANS = 18;
    private final M24C m24c = new M24C();
    public String current_channel = "B";
    public String current_channel2 = "C";
    public int current_loop = 1;
    List<Double> temperature_data_A = new ArrayList<Double>();
    List<Double> temperature_time_A = new ArrayList<Double>();
    List<Double> temperature_data_B = new ArrayList<Double>();
    List<Double> temperature_time_B = new ArrayList<Double>();
    List<Double> temperature_data_C = new ArrayList<Double>();
    List<Double> temperature_time_C = new ArrayList<Double>();
    List<Double> temperature_data_D = new ArrayList<Double>();
    List<Double> temperature_time_D = new ArrayList<Double>();
    Map<String, List<Double>> tempDataMap = new HashMap<String, List<Double>>();
    Map<String, List<Double>> tempTimeMap = new HashMap<String, List<Double>>();
    private static final Logger LOG = Logger.getLogger((String)CryoCon24cMonDevice.class.getName());
    @ConfigurationParameter
    protected Map<String, String> channelTypes;
    @ConfigurationParameter
    protected Map<String, String> channelUnits;
    DriverConstants.ConnType connType = DriverConstants.ConnType.NET;
    String host;
    int port = 5000;

    public CryoCon24cMonDevice() {
        this.tempDataMap.put("A", this.temperature_data_A);
        this.tempTimeMap.put("A", this.temperature_time_A);
        this.tempDataMap.put("B", this.temperature_data_B);
        this.tempTimeMap.put("B", this.temperature_time_B);
        this.tempDataMap.put("C", this.temperature_data_C);
        this.tempTimeMap.put("C", this.temperature_time_C);
        this.tempDataMap.put("D", this.temperature_data_D);
        this.tempTimeMap.put("D", this.temperature_time_D);
    }

    protected void initDevice() {
        if (this.host == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"host", (String)"is not specified");
        }
        this.fullName = "Cryocon M24C (" + this.host + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.m24c.open(this.connType, this.host, this.port);
                this.initSensors();
                this.setOnline(true);
                LOG.info((Object)("Connected to " + this.fullName));
            }
            catch (DriverException e) {
                if (this.inited) break block2;
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        this.inited = true;
    }

    public void close() {
        try {
            this.m24c.close();
        }
        catch (DriverException e) {
            LOG.error((Object)("Error disconnecting from " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 18) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        try {
            switch (chan) {
                case 0: {
                    value = this.getTemp(this.current_channel);
                    break;
                }
                case 1: {
                    value = 0.0;
                    break;
                }
                case 2: {
                    value = this.getTempStdDev();
                    break;
                }
                case 3: {
                    value = this.m24c.getHtrRead(1);
                    break;
                }
                case 4: {
                    value = this.m24c.getHtrRead(2);
                    break;
                }
                case 5: {
                    value = this.getTemp("A");
                    break;
                }
                case 6: {
                    value = this.getTemp("B");
                    break;
                }
                case 7: {
                    value = this.getTemp("C");
                    break;
                }
                case 8: {
                    value = this.getTemp("D");
                    break;
                }
                case 9: {
                    value = this.m24c.getPID_P(1);
                    break;
                }
                case 10: {
                    value = this.m24c.getPID_I(1);
                    break;
                }
                case 11: {
                    value = this.m24c.getPID_D(1);
                    break;
                }
                case 12: {
                    value = this.m24c.getPID_P(2);
                    break;
                }
                case 13: {
                    value = this.m24c.getPID_I(2);
                    break;
                }
                case 14: {
                    value = this.m24c.getPID_D(2);
                    break;
                }
                case 15: {
                    value = this.getTempChange();
                    break;
                }
                case 16: {
                    value = this.m24c.getSetPoint(1);
                    break;
                }
                case 17: {
                    value = this.m24c.getSetPoint(2);
                }
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading channel " + chan + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
        return value;
    }

    @Command(name="showident", description="Show Temp Control 24C identification")
    public String showIdentification() throws DriverException {
        String[] ident = this.m24c.getIdentification();
        return "Manufacturer:  " + ident[0] + "\nModel name:    " + ident[1] + "\nSerial number: " + ident[2] + "\nF/W version:   " + ident[3];
    }

    @Command(type=Command.CommandType.QUERY, name="getMaxSetPoint", description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getMaxSetPoint(loop);
    }

    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSetPoint(loop);
    }

    @Command(name="getHtrRead", description="Retrieve heater reading for loop")
    public double getHtrRead(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHtrRead(loop);
    }

    @Command(name="getPID_P", description="Retrieve PID parameter P for loop")
    public double getPID_P(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPID_P(loop);
    }

    @Command(name="getPID_I", description="Retrieve PID parameter I for loop")
    public double getPID_I(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPID_I(loop);
    }

    @Command(name="getPID_D", description="Retrieve PID parameter D for loop")
    public double getPID_D(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getPID_D(loop);
    }

    @Command(type=Command.CommandType.QUERY, name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSource(loop);
    }

    @Command(name="getHeaterRange", description="Get heater range for loop")
    public String getHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterRange(loop);
    }

    @Command(name="getHeaterMax", description="Get maximum heater power for loop")
    public double getHeaterMax(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterMax(loop);
    }

    @Command(type=Command.CommandType.QUERY, name="getTemp", description="Retrieve temperature info")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        double value = this.m24c.getTemp(channel.charAt(0));
        if (value > -274.0) {
            List<Double> tempData = this.tempDataMap.get(channel);
            List<Double> tempTime = this.tempTimeMap.get(channel);
            tempData.add(value);
            tempTime.add((double)System.currentTimeMillis() / 60000.0);
            if (tempData.size() > 120) {
                tempData.remove(0);
                tempTime.remove(0);
            }
        }
        return value;
    }

    @Command(type=Command.CommandType.QUERY, description="Return the standard deviation of the temperature values")
    public double getTempStdDev() {
        int ntemp = 0;
        double tempsum = 0.0;
        double tempsqsum = 0.0;
        for (double tempval : this.tempDataMap.get(this.current_channel)) {
            tempsum += tempval;
            tempsqsum += tempval * tempval;
            ++ntemp;
        }
        double ovrstd = 0.0;
        if (ntemp > 0) {
            ovrstd = Math.sqrt(tempsqsum / (double)ntemp - tempsum * tempsum / (double)(ntemp * ntemp));
        }
        return ovrstd;
    }

    @Command(type=Command.CommandType.QUERY, description="Return the temperature change over the sample period in degrees/minute")
    public double getTempChange() {
        double deltaTime;
        double slope = 0.0;
        List<Double> tempData = this.tempDataMap.get(this.current_channel);
        List<Double> tempTime = this.tempTimeMap.get(this.current_channel);
        if (tempData.size() > 1 && (deltaTime = tempTime.get(tempTime.size() - 1) - tempTime.get(0)) > 0.0) {
            slope = (tempData.get(tempData.size() - 1) - tempData.get(0)) / deltaTime;
        }
        return slope;
    }

    @Command(type=Command.CommandType.QUERY, name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getUnit(channel.charAt(0));
    }

    @Command(name="getType", description="Get sensor type")
    public String getType(@Argument(name="channel", description="Temp Channel to set") String channel) throws DriverException {
        return this.m24c.getType(channel.charAt(0));
    }

    @Command(name="isOtdEnabled", description="Get whether OTD system enabled")
    public boolean isOtdEnabled() throws DriverException {
        return this.m24c.isOtdEnabled();
    }

    @Command(name="getOtdSource", description="Get source channel for the OTD system")
    public char getOtdSource() throws DriverException {
        return this.m24c.getOtdSource();
    }

    @Command(name="getOtdTemp", description="Get temperature limit for the OTD system")
    public double getOtdTemp() throws DriverException {
        return this.m24c.getOtdTemp();
    }

    @Command(name="isInControl", description="is the CryoCon24c in control mode")
    public boolean isInControl() throws DriverException {
        return this.m24c.isInControl();
    }

    @Command
    public String getCurrent_channel() {
        return this.current_channel;
    }

    @Command
    public String getCurrent_channel2() {
        return this.current_channel2;
    }

    @Command
    public int getCurrent_loop() {
        return this.current_loop;
    }
}

