/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.PaddingException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;

public class UndefinedData
extends Data {
    private static final int BITS_PER_BYTE = 8;
    private byte[] data;

    public UndefinedData(Header h) throws FitsException {
        int naxis = h.getIntValue(Standard.NAXIS);
        int size = naxis > 0 ? 1 : 0;
        for (int i = 0; i < naxis; ++i) {
            size *= h.getIntValue(Standard.NAXISn.n(i + 1));
        }
        size += h.getIntValue(Standard.PCOUNT);
        if (h.getIntValue(Standard.GCOUNT) > 1) {
            size *= h.getIntValue(Standard.GCOUNT);
        }
        this.data = new byte[size *= Math.abs(h.getIntValue(Standard.BITPIX) / 8)];
    }

    public UndefinedData(Object x) {
        this.data = new byte[(int)ArrayFuncs.computeLSize(x)];
        ArrayFuncs.copyInto(x, this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillHeader(Header head) {
        try {
            Standard.context(UndefinedData.class);
            head.setXtension("UNKNOWN");
            head.setBitpix(8);
            head.setNaxes(1);
            head.addValue(Standard.NAXISn.n(1), this.data.length);
            head.addValue((IFitsHeader)Standard.PCOUNT, 0);
            head.addValue((IFitsHeader)Standard.GCOUNT, 1);
            head.addValue((IFitsHeader)Standard.EXTEND, true);
        }
        catch (HeaderCardException e) {
            System.err.println("Unable to create unknown header:" + e);
        }
        finally {
            Standard.context(null);
        }
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public Object getData() {
        return this.data;
    }

    @Override
    protected long getTrueSize() {
        return this.data.length;
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        this.setFileOffset(i);
        try {
            i.readFully(this.data);
        }
        catch (IOException e) {
            throw new FitsException("Unable to read unknown data:" + e);
        }
        int pad = FitsUtil.padding(this.getTrueSize());
        try {
            i.skipAllBytes(pad);
        }
        catch (EOFException e) {
            throw new PaddingException("EOF skipping padding in undefined data", this);
        }
        catch (IOException e) {
            throw new FitsException("Error skipping padding in undefined data");
        }
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        try {
            o.write(this.data);
        }
        catch (IOException e) {
            throw new FitsException("IO Error on unknown data write" + e);
        }
        FitsUtil.pad(o, this.getTrueSize());
    }
}

