/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.RaftsSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

public class MCMSubsystem
implements HasLifecycle {
    private final CCS ccs = new CCS();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MCMConfig config;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    private MCM mcm;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsystem;

    public void postStart() {
        this.mcm = new MCM(this.ccs, this.config, this.imageNameService);
        if (this.config.getRaftsSubsystemName() != null && !this.config.getRaftsSubsystemName().trim().isEmpty()) {
            this.mcm.getRafts().setRaftsSubsystem(new RaftsSubsystemLayer(this.subsystem, this.ccs, this.config));
        }
        if (this.config.getShutterSubsystemName() != null && !this.config.getShutterSubsystemName().trim().isEmpty()) {
            this.mcm.getShutter().setShutterSubsystem(new ShutterSubsystemLayer(this.subsystem, this.ccs, this.config));
        }
        this.ccs.addStateChangeListener((state, oldState) -> this.subsystem.updateAgentState(new Enum[]{state}));
        ArrayList initialStates = new ArrayList();
        this.ccs.getAggregateStatus().getStates().forEach(state -> initialStates.add(state.getState()));
        this.subsystem.updateAgentState(initialStates.toArray(new Enum[initialStates.size()]));
        this.ccs.addStatusMessageListener(msg -> this.subsystem.getMessagingAccess().sendStatusMessage(msg));
        this.ccs.addEventListener(event -> this.subsystem.publishSubsystemDataOnStatusBus(new KeyValueData("CCSEvent", (Serializable)event)));
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initImage(@Argument(description="Time in seconds") double delta) throws Exception {
        CCSCommand.CCSInitImageCommand initImage = new CCSCommand.CCSInitImageCommand(delta);
        this.executeAndHandleResponse(initImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void startImage(String imageSequenceName, boolean shutter, boolean wfs, boolean science, boolean guide, double timeout) throws Exception {
        CCSCommand.CCSStartImageCommand startImage = new CCSCommand.CCSStartImageCommand(imageSequenceName, shutter, wfs, guide, science, timeout);
        this.executeAndHandleResponse(startImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void takeImages(double expTime, int numImages, boolean shutter, boolean science, boolean wfs, boolean guide, String imageSequenceName) throws Exception {
        CCSCommand.CCSTakeImagesCommand takeImages = new CCSCommand.CCSTakeImagesCommand(expTime, numImages, shutter, science, wfs, guide, imageSequenceName);
        this.executeAndHandleResponse(takeImages);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void setFilter(String name) throws Exception {
        CCSCommand.CCSSetFilterCommand setFilter = new CCSCommand.CCSSetFilterCommand(name);
        this.executeAndHandleResponse(setFilter);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void initGuiders(String roiSpec) throws Exception {
        CCSCommand.CCSInitGuidersCommand initGuiders = new CCSCommand.CCSInitGuidersCommand(roiSpec);
        this.executeAndHandleResponse(initGuiders);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void endImage() throws Exception {
        CCSCommand.CCSEndImageCommand endImage = new CCSCommand.CCSEndImageCommand();
        this.executeAndHandleResponse(endImage);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void clear(int nClears) throws Exception {
        CCSCommand.CCSClearCommand clear = new CCSCommand.CCSClearCommand(nClears);
        this.executeAndHandleResponse(clear);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void discardRows(int nRows) throws Exception {
        CCSCommand.CCSDiscardRowsCommand discardRows = new CCSCommand.CCSDiscardRowsCommand(nRows);
        this.executeAndHandleResponse(discardRows);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void start(String configuration) throws Exception {
        CCSCommand.CCSStartCommand start = new CCSCommand.CCSStartCommand(configuration);
        this.executeAndHandleResponse(start);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void enableCalibration() throws Exception {
        CCSCommand.CCSEnableCalibrationCommand enableCalibration = new CCSCommand.CCSEnableCalibrationCommand();
        this.executeAndHandleResponse(enableCalibration);
    }

    @Command(type=Command.CommandType.ACTION, autoAck=false, level=0)
    public void disableCalibration() throws Exception {
        CCSCommand.CCSDisableCalibrationCommand disableCalibration = new CCSCommand.CCSDisableCalibrationCommand();
        this.executeAndHandleResponse(disableCalibration);
    }

    private void executeAndHandleResponse(CCSCommand command) throws Exception {
        CCSCommand.CCSCommandResponse response = this.mcm.execute(command);
        CCSCommand.CCSAckOrNack can = response.waitForAckOrNack();
        if (can.isNack()) {
            this.subsystem.sendNack((Serializable)((Object)can.getReason()));
        } else {
            this.subsystem.sendAck(can.getDuration().plus(Duration.ofMillis(1000L)));
            response.waitForCompletion();
        }
    }
}

