/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.sal.SAL;
import org.lsst.sal.SALException;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;

public class OCSBridgeSALLayer
extends OCSCommandExecutor {
    private final OCSBridge bridge;
    private final SAL<CameraCommand, CameraEvent, CameraTelemetry> mgr;
    private boolean shutdown = false;
    private static final Logger logger = Logger.getLogger(OCSBridgeSALLayer.class.getName());
    private Thread runThread;
    private SALReceivedCommand<CameraCommand> currentCommand;

    OCSBridgeSALLayer(OCSBridge bridge) {
        super(bridge);
        this.bridge = bridge;
        this.mgr = bridge.getConfig().getSALManager();
    }

    public void start() {
        Thread t = new Thread("SALCommandReceiver"){

            @Override
            public void run() {
                try {
                    OCSBridgeSALLayer.this.runCommandLoop();
                }
                catch (Exception x) {
                    logger.log(Level.WARNING, "Failed to initialize SAL communication layer, check that SAL has been setup correctly. Reverting to standalone mode.", x);
                }
            }
        };
        t.start();
    }

    private void runCommandLoop() throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        try {
            this.runThread = Thread.currentThread();
            while (!this.shutdown) {
                this.currentCommand = this.mgr.getNextCommand(Duration.ofMinutes(1L));
                if (this.currentCommand == null) {
                    logger.info("Still waiting for a command");
                    continue;
                }
                this.bridge.execute(this.currentCommand.getCommand());
            }
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while waiting for commands", ex);
        }
        finally {
            this.runThread = null;
        }
    }

    private void shutdown() throws InterruptedException {
        this.shutdown = true;
        this.runThread.join();
    }

    @Override
    protected void reportComplete(OCSCommandExecutor.OCSExecutor command) {
        super.reportComplete(command);
        try {
            this.currentCommand.reportComplete();
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    protected void reportError(OCSCommandExecutor.OCSExecutor command, Exception ex) {
        super.reportError(command, ex);
        try {
            this.currentCommand.reportError(ex);
        }
        catch (SALException x) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", x);
        }
    }

    @Override
    protected void acknowledgeCommand(OCSCommandExecutor.OCSExecutor command, Duration timeout) {
        super.acknowledgeCommand(command, timeout);
        try {
            this.currentCommand.acknowledgeCommand(timeout);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    protected void rejectCommand(OCSCommandExecutor.OCSExecutor command, String reason) {
        super.rejectCommand(command, reason);
        try {
            this.currentCommand.rejectCommand(reason, 0);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error while responding to command", ex);
        }
    }

    @Override
    void sendEvent(CameraEvent event) {
        super.sendEvent(event);
        try {
            this.mgr.logEvent(event);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error sending event to SAL", ex);
        }
    }

    @Override
    void sendTelemetry(CameraTelemetry telemetry) {
        try {
            this.mgr.sendTelemetry(telemetry);
        }
        catch (SALException ex) {
            logger.log(Level.SEVERE, "Unexpected error sending telemetry to SAL", ex);
        }
    }
}

