/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.subsystem.power.constants.QuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;
import org.lsst.ccs.utilities.logging.Logger;

public class QuadBox
implements HasLifecycle {
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.power");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    private final SwitchControl[] swDevices = new SwitchControl[5];
    private final QuadBoxState qbState = new QuadBoxState();

    public void build() {
    }

    public void postInit() {
        this.subsys.setAgentProperty("quadBoxAgent", this.getClass().getCanonicalName());
        boolean error = false;
        Iterator<SwitchControl> iterator = this.swDeviceList.iterator();
        while (iterator.hasNext()) {
            SwitchControl sd;
            this.swDevices[sd.getSwitchDevice()] = sd = iterator.next();
        }
        for (int j = 0; j < this.swDevices.length; ++j) {
            if (this.swDevices[j] != null) continue;
            this.log.error((Object)("The " + typeMap.get(j) + " device has not been specified"));
            error = true;
        }
        if (error) {
            throw new RuntimeException("Fatal initialization error");
        }
    }

    public void postStart() {
        this.updateState();
        this.publishState();
        this.log.info((Object)"Quad Box subsystem started");
    }

    public void periodicBroadcast() {
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        int devNum = sw >> 8;
        byte swNum = (byte)sw;
        if (devNum < 0 || devNum >= 5 || swNum >= QuadBoxSwitches.NUM_SWITCHES[devNum]) {
            throw new PowerException("Invalid switch number: " + sw);
        }
        if (on) {
            this.swDevices[devNum].switchOn(swNum);
            if (sw == 10) {
                this.swDevices[2].initialize();
            } else if (sw == 3) {
                this.swDevices[3].initialize();
            } else if (sw == 2) {
                this.swDevices[4].initialize();
            }
        } else {
            this.swDevices[devNum].switchOff(swNum);
        }
        this.updateState();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        Integer sw = QuadBoxSwitches.switchNames.get(name);
        if (sw == null) {
            throw new PowerException("Invalid switch name: " + name);
        }
        this.setSwitchOn(sw, on);
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of switch names")
    public List<String> getSwitchNames() {
        return new ArrayList<String>(QuadBoxSwitches.switchNames.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public QuadBoxState getFullState() throws PowerException {
        this.updateState();
        this.qbState.setTickMillis(this.getTickPeriod());
        return this.qbState;
    }

    private void updateState() {
        for (int devNum = 0; devNum < 5; ++devNum) {
            for (int swNum = -1; swNum < QuadBoxSwitches.NUM_SWITCHES[devNum]; ++swNum) {
                Boolean st = this.swDevices[devNum].isSwitchOn(swNum);
                SwitchState ss = st == null ? SwitchState.OFFLINE : (st != false ? SwitchState.ON : SwitchState.OFF);
                this.qbState.setSwitchState(devNum, swNum, ss);
            }
        }
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void publishState() {
        this.qbState.setTickMillis(this.getTickPeriod());
        KeyValueData kvd = new KeyValueData("QuadBoxState", (Serializable)this.qbState);
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    static {
        typeMap.put(0, "BFR");
        typeMap.put(1, "5V PDU");
        typeMap.put(2, "24V clean PDU");
        typeMap.put(3, "24V dirty PDU");
        typeMap.put(4, "48V PDU");
    }

    static class DummyDevice
    implements SwitchControl {
        DummyDevice() {
        }

        @Override
        public int getSwitchDevice() {
            return 0;
        }

        @Override
        public void initialize() {
        }

        @Override
        public Boolean isSwitchOn(int sw) {
            return null;
        }

        @Override
        public void switchOn(int sw) {
        }

        @Override
        public void switchOff(int sw) {
        }
    }
}

