/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.plotter.DefaultPage;
import org.freehep.jas.plugin.plotter.DefaultPlotter;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.plotter.JAS3Plot;
import org.freehep.jas.plugin.plotter.PlotterAdapterLookup;
import org.freehep.jas.plugin.xmlio.XMLPluginIO;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.jas.services.PlotterAdapter;
import org.freehep.jas.services.PlotterProvider;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.io.XMLIOFactory;
import org.freehep.xml.io.XMLIOManager;
import org.freehep.xml.io.XMLIOProxy;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class PlotterPlugin
extends Plugin
implements PlotFactory,
PlotterProvider,
XMLPluginIO {
    private int nPage = 0;
    private PlotterAdapterLookup plotterLookup;

    public void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        app.getLookup().add((Object)this);
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("Plotter.menus");
        builder.build(xml);
        app.getCommandTargetManager().add((CommandGroup)new PlotterCommands());
        this.plotterLookup = new PlotterAdapterLookup();
        app.getLookup().add((Object)this.plotterLookup);
        app.getLookup().add((Object)new PlotPageFactoryAndProxy(this));
        app.getLookup().add((Object)new JAS3PlotFactoryAndProxy(this));
        app.getLookup().add((Object)new DefaultPlotterFactory(this));
    }

    protected PlotterAdapterLookup plotterAdapterLookup() {
        return this.plotterLookup;
    }

    @Override
    public PlotPage createPage(String name) {
        if (name == null) {
            name = "Page " + ++this.nPage;
        }
        return new DefaultPage(this.getApplication(), this, name);
    }

    @Override
    public Plotter createPlotterFor(Class dataType) {
        PlotterProvider pp = this.findPlotProvider(dataType);
        return pp == null ? null : pp.create();
    }

    @Override
    public Plotter createPlotterFor(Class[] dataType) {
        PlotterProvider pp = this.findPlotProvider(dataType);
        return pp == null ? null : pp.create();
    }

    @Override
    public boolean canCreatePlotterFor(Class dataType) {
        return this.findPlotProvider(dataType) != null;
    }

    @Override
    public boolean canCreatePlotterFor(Class[] dataType) {
        return this.findPlotProvider(dataType) != null;
    }

    private PlotterProvider findPlotProvider(Class dataType) {
        Lookup.Template template = new Lookup.Template(PlotterProvider.class);
        Lookup.Result result = this.getApplication().getLookup().lookup(template);
        for (PlotterProvider pp : result.allInstances()) {
            if (!pp.supports(dataType)) continue;
            return pp;
        }
        return null;
    }

    private PlotterProvider findPlotProvider(Class[] dataType) {
        Lookup.Template template = new Lookup.Template(PlotterProvider.class);
        Lookup.Result result = this.getApplication().getLookup().lookup(template);
        block0: for (PlotterProvider pp : result.allInstances()) {
            for (Class type : dataType) {
                if (!pp.supports(type)) continue block0;
            }
            return pp;
        }
        return null;
    }

    @Override
    public PlotPage currentPage() {
        PageContext context = this.getApplication().getPageManager().getSelectedPage();
        if (context == null) {
            return null;
        }
        Component page = context.getPage();
        return page instanceof PlotPage ? (PlotPage)((Object)page) : null;
    }

    @Override
    public void registerAdapter(PlotterAdapter adapter, Class from, Class to) {
        this.plotterLookup.registerAdapter(adapter, from, to);
    }

    @Override
    public List<PlotPage> pages() {
        List pages = this.getApplication().getPageManager().pages();
        ArrayList<PlotPage> result = new ArrayList<PlotPage>(pages.size());
        for (Object page : pages) {
            if (!(page instanceof PlotPage)) continue;
            result.add((PlotPage)page);
        }
        return result;
    }

    @Override
    public Plotter create() {
        return new DefaultPlotter(this);
    }

    @Override
    public boolean supports(Class klass) {
        return JAS3DataSource.class.isAssignableFrom(klass);
    }

    @Override
    public int restore(int level, XMLIOManager manager, Element el) {
        switch (level) {
            case 0: {
                return 60;
            }
            case 60: {
                List pages = el.getChildren("PlotPage");
                for (int i = 0; i < pages.size(); ++i) {
                    manager.restore((Element)pages.get(i));
                }
                this.nPage = Integer.parseInt(el.getAttributeValue("nPages"));
                return -1;
            }
        }
        throw new IllegalArgumentException("Level " + level + " is not supported");
    }

    @Override
    public void save(XMLIOManager manager, Element el) {
        el.setAttribute("nPages", String.valueOf(this.nPage));
        Studio app = this.getApplication();
        List pages = app.getPageManager().pages();
        for (int i = 0; i < pages.size(); ++i) {
            PageContext pageContext = (PageContext)pages.get(i);
            if (!(pageContext.getPage() instanceof PlotPage)) continue;
            PlotPage page = (PlotPage)((Object)pageContext.getPage());
            el.addContent((Content)manager.saveAs((Object)page, PlotPage.class));
        }
    }

    private class DefaultPlotterFactory
    implements XMLIOFactory {
        private PlotterPlugin thePlugin;
        private Class[] classes = new Class[]{DefaultPlotter.class};

        DefaultPlotterFactory(PlotterPlugin thePlugin) {
            this.thePlugin = thePlugin;
        }

        public Class[] XMLIOFactoryClasses() {
            return this.classes;
        }

        public Object createObject(Class objClass) throws IllegalArgumentException {
            if (objClass == DefaultPlotter.class) {
                return this.thePlugin.create();
            }
            throw new IllegalArgumentException("Cannot create class " + objClass);
        }
    }

    private class JAS3PlotFactoryAndProxy
    implements XMLIOFactory,
    XMLIOProxy {
        private PlotterPlugin plugin;
        private Class[] classes = new Class[]{JAS3Plot.class};

        public JAS3PlotFactoryAndProxy(PlotterPlugin plugin) {
            this.plugin = plugin;
        }

        public Class[] XMLIOFactoryClasses() {
            return this.classes;
        }

        public Class[] XMLIOProxyClasses() {
            return this.classes;
        }

        public Object createObject(Class objClass) throws IllegalArgumentException {
            if (objClass == JAS3Plot.class) {
                return new JAS3Plot();
            }
            throw new IllegalArgumentException("Cannot create class " + objClass);
        }

        public void restore(Object obj, XMLIOManager xmlioManager, Element nodeEl) throws IllegalArgumentException {
            JAS3Plot plot = (JAS3Plot)obj;
            List children = nodeEl.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element childEl = (Element)children.get(i);
                JAS3DataSource data = (JAS3DataSource)xmlioManager.restore(childEl);
                if (data.dataSource() == null) continue;
                plot.addJAS3Data(data);
                plot.addData(data.dataSource());
            }
        }

        public void save(Object obj, XMLIOManager xmlioManager, Element nodeEl) throws IllegalArgumentException {
            List<JAS3DataSource> data = ((JAS3Plot)obj).data();
            for (int i = 0; i < data.size(); ++i) {
                nodeEl.addContent((Content)xmlioManager.save((Object)data.get(i)));
            }
        }
    }

    private class PlotPageFactoryAndProxy
    implements XMLIOFactory,
    XMLIOProxy {
        private PlotterPlugin plugin;
        private Class[] classes = new Class[]{PlotPage.class};

        public PlotPageFactoryAndProxy(PlotterPlugin plugin) {
            this.plugin = plugin;
        }

        public Class[] XMLIOFactoryClasses() {
            return this.classes;
        }

        public Class[] XMLIOProxyClasses() {
            return this.classes;
        }

        public Object createObject(Class objClass) throws IllegalArgumentException {
            return this.plugin.createPage(null);
        }

        public void restore(Object obj, XMLIOManager xmlioManager, Element nodeEl) throws IllegalArgumentException {
            String addString;
            DefaultPage page = (DefaultPage)obj;
            page.setTitle(nodeEl.getAttributeValue("title"));
            String colString = nodeEl.getAttributeValue("columns");
            if (colString != null) {
                int columns = Integer.valueOf(colString);
                int rows = Integer.valueOf(nodeEl.getAttributeValue("rows"));
                page.createRegions(columns, rows);
            }
            if ((addString = nodeEl.getAttributeValue("addedRegions")) != null) {
                int addedRegions = Integer.valueOf(addString);
                for (int i = 0; i < addedRegions; ++i) {
                    page.addRegion();
                }
            }
            int currentRegion = Integer.parseInt(nodeEl.getAttributeValue("currentRegion"));
            page.showPage();
            page.setCurrentRegion(page.region(currentRegion));
            List plotRegions = nodeEl.getChildren("PlotRegion");
            for (int i = 0; i < plotRegions.size(); ++i) {
                Element plotRegionEl = (Element)plotRegions.get(i);
                List children = plotRegionEl.getChildren();
                Plotter plotter = (Plotter)xmlioManager.restore((Element)children.get(0));
                int n = Integer.valueOf(plotRegionEl.getAttributeValue("n"));
                page.region(n).showPlot(plotter);
            }
        }

        public void save(Object obj, XMLIOManager xmlioManager, Element nodeEl) throws IllegalArgumentException {
            int addRows;
            DefaultPage page = (DefaultPage)obj;
            nodeEl.setAttribute("title", page.title());
            nodeEl.setAttribute("nRegions", String.valueOf(page.numberOfRegions()));
            int cols = page.columns();
            if (cols > 0) {
                nodeEl.setAttribute("columns", String.valueOf(cols));
                nodeEl.setAttribute("rows", String.valueOf(page.rows()));
            }
            if ((addRows = page.addedRegions()) > 0) {
                nodeEl.setAttribute("addedRegions", String.valueOf(addRows));
            }
            for (int i = 0; i < page.numberOfRegions(); ++i) {
                PlotRegion region = page.region(i);
                Plotter plotter = region.currentPlot();
                if (plotter != null) {
                    Element regEl = new Element("PlotRegion");
                    regEl.setAttribute("n", String.valueOf(i));
                    regEl.addContent((Content)xmlioManager.save((Object)plotter));
                    nodeEl.addContent((Content)regEl);
                }
                if (page.region(i) != page.currentRegion()) continue;
                nodeEl.setAttribute("currentRegion", String.valueOf(i));
                break;
            }
        }
    }

    public class PlotterCommands
    extends CommandProcessor {
        public void onNewPlotPage() {
            PlotPage page = PlotterPlugin.this.createPage(null);
            page.createRegions(1, 1);
            page.showPage();
        }
    }
}

