/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SALKafkaHashTable {
    private static final Logger LOG = Logger.getLogger(SALKafkaHashTable.class.getName());
    private String xmlVersion;
    private final HashMap<String, String> map;

    static SALKafkaHashTable read(String cscName) {
        SALKafkaHashTable result;
        InputStream in;
        ObjectMapper mapper = new ObjectMapper();
        try {
            in = SALKafkaHashTable.class.getResourceAsStream("/avro/" + cscName + "_hash_table.avsc");
            try {
                result = new SALKafkaHashTable(mapper, in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading hash table", x);
        }
        try {
            in = SALKafkaHashTable.class.getResourceAsStream("/xml_version.json");
            try {
                TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                HashMap readValue = (HashMap)mapper.readValue(in, (TypeReference)typeRef);
                result.xmlVersion = (String)readValue.get("xml_version");
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "Unable to read XML version", x);
            result.xmlVersion = "Unknown";
        }
        return result;
    }

    private SALKafkaHashTable(ObjectMapper mapper, InputStream in) throws IOException {
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        this.map = (HashMap)mapper.readValue(in, (TypeReference)typeRef);
    }

    String getRevCode(String salClassName) {
        int index = salClassName.indexOf(".");
        return this.map.get(salClassName.substring(index + 1));
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }
}

