/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

public class CRC16 {
    private static final int stdPoly = 40961;
    private static final int TABLE_SIZE = 256;
    private static final int[] stdTable = new int[256];
    private final int[] table = new int[256];

    public CRC16(int poly) {
        CRC16.makeTable(poly, this.table);
    }

    public int generate(byte[] data) {
        return CRC16.generateCRC(this.table, data, 0, data.length);
    }

    public int generate(byte[] data, int offset, int length) {
        return CRC16.generateCRC(this.table, data, offset, length);
    }

    public void generate(byte[] data, byte[] output, int outoff) {
        this.generate(data, 0, data.length, output, outoff);
    }

    public void generate(byte[] data, int offset, int length, byte[] output, int outoff) {
        int crc = CRC16.generateCRC(this.table, data, offset, length);
        output[outoff] = (byte)crc;
        output[outoff + 1] = (byte)(crc >> 8);
    }

    public static int generateStd(byte[] data) {
        return CRC16.generateCRC(stdTable, data, 0, data.length);
    }

    public static int generateStd(byte[] data, int offset, int length) {
        return CRC16.generateCRC(stdTable, data, offset, length);
    }

    public static void generateStd(byte[] data, byte[] output, int outoff) {
        CRC16.generateStd(data, 0, data.length, output, outoff);
    }

    public static void generateStd(byte[] data, int offset, int length, byte[] output, int outoff) {
        int crc = CRC16.generateCRC(stdTable, data, offset, length);
        output[outoff] = (byte)crc;
        output[outoff + 1] = (byte)(crc >> 8);
    }

    private static void makeTable(int poly, int[] table) {
        for (int j = 0; j < table.length; ++j) {
            int crc = j;
            for (int k = 0; k < 8; ++k) {
                crc = crc >>> 1 ^ ((crc & 1) == 0 ? 0 : poly);
            }
            table[j] = crc;
        }
    }

    private static int generateCRC(int[] table, byte[] data, int offset, int length) {
        int crc = 65535;
        for (int j = 0; j < length; ++j) {
            crc = crc >>> 8 ^ table[(crc ^ data[offset + j]) & 0xFF];
        }
        return crc;
    }

    public static void main(String[] args) {
        String arg;
        int leng;
        if (args.length == 0) {
            System.out.println("No argument supplied");
            System.exit(0);
        }
        if (((leng = (arg = args[0]).length()) & 1) != 0) {
            System.out.println("Argument must have an even number of digits");
            System.exit(0);
        }
        byte[] data = new byte[leng / 2];
        for (int j = 0; j < leng; j += 2) {
            try {
                int value = Integer.decode("0x" + arg.substring(j, j + 2));
                data[j / 2] = (byte)value;
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid hexadecimal digit found");
                System.exit(0);
            }
        }
        System.out.format("CRC16 = %04x\n", CRC16.generateStd(data));
    }

    static {
        CRC16.makeTable(40961, stdTable);
    }
}

