/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.lsst.ccs.subsystem.common.PIController;

public class PITest {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("No output file specified");
            System.exit(1);
        }
        FileWriter out = new FileWriter(new File(args[0]));
        int steps = 400;
        double sTmp = 290.0;
        double sTa = 290.0;
        double sGn = 10.0;
        double sTc = 5000.0;
        double sSm = 200.0;
        double sTime = 0.0;
        Refrigerator myFrig = new Refrigerator();
        LoadSim myLoad = new LoadSim(sTmp, sTa, sTime, myFrig);
        PIController myPI = new PIController(sGn, sTc);
        myPI.setSmoothTime(sSm);
        double[] mTmp = new double[]{sTmp};
        Object outText = "Time, Temperature, Smoothed, Heat, Integral, Rout \r\n";
        out.write((String)outText);
        for (int j = 0; j < steps; ++j) {
            double tm = 100.0 * (double)j + sTime;
            double hout = myPI.performPI(mTmp, tm);
            mTmp[0] = myLoad.newT(hout, tm);
            double smT = myPI.getSmooth();
            double intE = myPI.getIntegral();
            double outR = myFrig.getRout();
            outText = tm + ", " + mTmp[0] + "," + smT + ", " + hout + ", " + intE + ", " + outR + "\r\n";
            out.write((String)outText);
        }
    }

    static class Refrigerator {
        private double[][] R = new double[][]{{0.0, 105.0}, {13.0, 106.8}, {32.0, 109.3}, {51.0, 111.8}, {72.0, 115.8}, {86.0, 120.7}, {92.0, 123.0}, {96.0, 126.7}, {101.0, 130.7}, {104.0, 135.7}, {106.0, 143.7}, {109.0, 153.6}, {110.0, 154.8}, {111.0, 164.4}, {112.0, 180.0}, {113.0, 188.8}, {116.0, 194.8}, {126.0, 202.1}, {146.0, 210.0}, {155.0, 213.8}, {165.0, 220.0}, {400.0, 289.0}};
        private double Rout;
        private double Tanom = 290.0;
        private int len = this.R.length - 1;

        public double Refrig(double Tl, double Th) {
            if (Tl <= this.R[0][1]) {
                this.Rout = -this.R[0][0];
            } else if (Tl >= this.R[this.len][1]) {
                this.Rout = -this.R[this.len][0];
            } else {
                for (int j = 1; j <= this.len; ++j) {
                    if (!(Tl > this.R[j - 1][1]) || !(Tl <= this.R[j][1])) continue;
                    this.Rout = -((Tl - this.R[j - 1][1]) * this.R[j][0] + (this.R[j][1] - Tl) * this.R[j - 1][0]) / (this.R[j][1] - this.R[j - 1][1]);
                    break;
                }
            }
            return this.Rout;
        }

        public double getRout() {
            return this.Rout;
        }
    }

    static class LoadSim {
        private double C = 9608.0;
        private double k = 0.1;
        private double A = 0.3;
        private final double sigma = 5.67E-8;
        private double epsl = 0.06;
        private double epsc = 0.09;
        private double T = 281.0;
        private double Ta = 281.0;
        private double t = 0.0;
        private double tMax = 10.0;
        private Refrigerator refrig;

        public LoadSim(double init_T, double init_Ta, double init_t, Refrigerator frig) {
            this.T = init_T;
            this.Ta = init_Ta;
            this.t = init_t;
            this.refrig = frig;
        }

        public double newT(double P, double tNew) {
            int n = (int)((tNew - this.t) / this.tMax);
            double dt = (tNew - this.t) / (double)(n + 1);
            int i = 0;
            do {
                double Rt = this.refrig.Refrig(this.T, this.Ta);
                this.T += dt / this.C * (P + this.k * (this.Ta - this.T) + this.epsl * this.epsc / (this.epsl + this.epsc - this.epsl * this.epsc) * 5.67E-8 * this.A * (this.Ta * this.Ta * this.Ta * this.Ta - this.T * this.T * this.T * this.T) + this.refrig.Refrig(this.T, this.Ta));
            } while (++i < n);
            this.t = tNew;
            return this.T;
        }

        public void setC(double sC) {
            this.C = sC;
        }

        public void setk(double sk) {
            this.k = sk;
        }

        public void setA(double sA) {
            this.A = sA;
        }

        public void setTa(double sTa) {
            this.Ta = sTa;
        }

        public void settMax(double stMax) {
            this.tMax = stMax;
        }

        public void setepsl(double sepsl) {
            this.epsl = sepsl;
        }

        public void setepsc(double sepsc) {
            this.epsc = sepsc;
        }

        public double getC() {
            return this.C;
        }

        public double getk() {
            return this.k;
        }

        public double getA() {
            return this.A;
        }

        public double getTa() {
            return this.Ta;
        }

        public double gettMax() {
            return this.tMax;
        }

        public double getepsl() {
            return this.epsl;
        }

        public double getepsc() {
            return this.epsc;
        }
    }
}

