/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.behavior.IDiscoveryListener;

public class LateralTCPDiscoveryListener
implements IDiscoveryListener {
    private static final Log log = LogManager.getLog(LateralTCPDiscoveryListener.class);
    private final ConcurrentMap<String, LateralCacheNoWaitFacade<?, ?>> facades = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<String> knownDifferentlyConfiguredRegions = new CopyOnWriteArrayList();
    private final String factoryName;
    private final ICompositeCacheManager cacheManager;

    protected LateralTCPDiscoveryListener(String factoryName, ICompositeCacheManager cacheManager) {
        this.factoryName = factoryName;
        this.cacheManager = cacheManager;
    }

    public boolean addNoWaitFacade(String cacheName, LateralCacheNoWaitFacade<?, ?> facade) {
        boolean isNew = !this.containsNoWaitFacade(cacheName);
        this.facades.put(cacheName, facade);
        this.knownDifferentlyConfiguredRegions.remove(cacheName);
        return isNew;
    }

    public boolean containsNoWaitFacade(String cacheName) {
        return this.facades.containsKey(cacheName);
    }

    public <K, V> boolean containsNoWait(String cacheName, LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        if (facade == null) {
            return false;
        }
        return facade.containsNoWait(noWait);
    }

    protected <K, V> boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        log.debug("addNoWait > Got facade for {0} = {1}", noWait.getCacheName(), facade);
        if (facade != null) {
            boolean isNew = facade.addNoWait(noWait);
            log.debug("Called addNoWait, isNew = {0}", isNew);
            return isNew;
        }
        if (this.knownDifferentlyConfiguredRegions.addIfAbsent(noWait.getCacheName())) {
            log.info("addNoWait > Different nodes are configured differently or region [{0}] is not yet used on this side.", () -> noWait.getCacheName());
        }
        return false;
    }

    protected <K, V> boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade facade = (LateralCacheNoWaitFacade)this.facades.get(noWait.getCacheName());
        log.debug("removeNoWait > Got facade for {0} = {1}", noWait.getCacheName(), facade);
        if (facade != null) {
            boolean removed = facade.removeNoWait(noWait);
            log.debug("Called removeNoWait, removed {0}", removed);
            return removed;
        }
        if (this.knownDifferentlyConfiguredRegions.addIfAbsent(noWait.getCacheName())) {
            log.info("addNoWait > Different nodes are configured differently or region [{0}] is not yet used on this side.", () -> noWait.getCacheName());
        }
        return false;
    }

    @Override
    public void addDiscoveredService(DiscoveredService service) {
        ArrayList<String> regions = service.getCacheNames();
        String serverAndPort = service.getServiceAddress() + ":" + service.getServicePort();
        if (regions != null) {
            for (String cacheName : regions) {
                ITCPLateralCacheAttributes lca;
                AuxiliaryCacheAttributes aca;
                AuxiliaryCache ic = this.cacheManager.getAuxiliaryCache(this.factoryName, cacheName);
                log.debug("Got cache, ic = {0}", ic);
                if (ic == null || (aca = ic.getAuxiliaryCacheAttributes()) instanceof ITCPLateralCacheAttributes && ((lca = (ITCPLateralCacheAttributes)aca).getTransmissionType() != ILateralCacheAttributes.Type.TCP || !serverAndPort.equals(lca.getTcpServer()))) continue;
                this.addNoWait((LateralCacheNoWait)ic);
                log.debug("Called addNoWait for cacheName [{0}]", cacheName);
            }
        } else {
            log.warn("No cache names found in message {0}", service);
        }
    }

    @Override
    public void removeDiscoveredService(DiscoveredService service) {
        ArrayList<String> regions = service.getCacheNames();
        String serverAndPort = service.getServiceAddress() + ":" + service.getServicePort();
        if (regions != null) {
            for (String cacheName : regions) {
                ITCPLateralCacheAttributes lca;
                AuxiliaryCacheAttributes aca;
                AuxiliaryCache ic = this.cacheManager.getAuxiliaryCache(this.factoryName, cacheName);
                log.debug("Got cache, ic = {0}", ic);
                if (ic == null || (aca = ic.getAuxiliaryCacheAttributes()) instanceof ITCPLateralCacheAttributes && ((lca = (ITCPLateralCacheAttributes)aca).getTransmissionType() != ILateralCacheAttributes.Type.TCP || !serverAndPort.equals(lca.getTcpServer()))) continue;
                this.removeNoWait((LateralCacheNoWait)ic);
                log.debug("Called removeNoWait for cacheName [{0}]", cacheName);
            }
        } else {
            log.warn("No cache names found in message {0}", service);
        }
    }
}

