/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.console;

import java.awt.Component;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsolePreferences;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.jas.plugin.console.StudioConsole;
import org.freehep.jas.plugin.console.StudioOutputStream;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.FreeHEPLookup;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.xml.sax.SAXException;

public class ConsolePlugin
extends Plugin
implements ConsoleService {
    private Map<String, Console> consoles = new HashMap<String, Console>();
    private Map<Console, PageContext> contexts = new HashMap<Console, PageContext>();
    private static final String STD_OUT_CONSOLE_NAME = "Standard Output";
    private static final String STD_ERR_CONSOLE_NAME = "Standard Error";
    private PerThreadOutputStream stdoutThreadedOutput;
    private SwitchedOutputStream stdoutSwitchedOutput;
    private SwitchedOutputStream stderrSwitchedOutput;
    private ConsolePreferences pref;
    private StudioOutputStream stdoutOutput;
    private StudioOutputStream stderrOutput;

    @Override
    public Console getConsole(String name) {
        return this.consoles.get(name);
    }

    @Override
    public Console createConsole(String name, Icon icon) {
        return this.createConsole(name, icon, null);
    }

    @Override
    public Console createConsole(String name, Icon icon, HasPopupItems popupItems) {
        StudioConsole console = new StudioConsole((Application)this.getApplication(), this, popupItems);
        console.setMaxScrollback(this.pref.getDefaultScrollback());
        PageContext context = this.getApplication().getConsoleManager().openPage((Component)new JScrollPane(console), name, icon, name, false);
        context.addPageListener((PageListener)console);
        if (this.getApplication().getConsoleManager().getSelectedPage() == context) {
            console.setSelected(true);
        }
        this.consoles.put(name, console);
        this.contexts.put(console, context);
        return console;
    }

    void closeMe(Console console) {
        PageContext context = this.contexts.get(console);
        if (context != null) {
            context.close();
        }
    }

    void consoleIsClosed(Console console) {
        PageContext context = this.contexts.remove(console);
        String name = context.getTitle();
        this.consoles.remove(name);
    }

    @Override
    public ConsoleOutputStream getConsoleOutputStream(String name, Icon icon) throws IOException {
        return this.getConsoleOutputStream(name, icon, null);
    }

    @Override
    public ConsoleOutputStream getConsoleOutputStream(String name, Icon icon, AttributeSet set) throws IOException {
        return new StudioOutputStream(this, name, icon, set);
    }

    protected void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        FreeHEPLookup lookup = app.getLookup();
        lookup.add((Object)this);
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = this.getClass().getResource("Console.menus");
        builder.build(xml);
        this.stdoutOutput = new StudioOutputStream(this, STD_OUT_CONSOLE_NAME, null, null, false);
        this.stderrOutput = new StudioOutputStream(this, STD_ERR_CONSOLE_NAME, null, null, false);
        this.stdoutSwitchedOutput = new SwitchedOutputStream(this.stdoutOutput, System.out);
        this.stderrSwitchedOutput = new SwitchedOutputStream(this.stderrOutput, System.err);
        this.stdoutThreadedOutput = new PerThreadOutputStream(this.stdoutSwitchedOutput);
        this.pref = new ConsolePreferences(this);
        lookup.add((Object)this.pref);
        this.preferencesChanged(this.pref);
        System.setOut(new PrintStream(this.stdoutThreadedOutput, true));
        System.setErr(new PrintStream(this.stderrSwitchedOutput, true));
    }

    @Override
    public void redirectStandardOutputOnThreadToConsole(Thread thread, ConsoleOutputStream out) {
        this.stdoutThreadedOutput.mapThreadToOutputStream(thread, out);
    }

    synchronized ConsoleOutputStream getStreamToWriteTo(StudioOutputStream out) throws IOException {
        try {
            String name = out.getName();
            Console console = this.consoles.get(name);
            if (console == null) {
                ConsoleCreator cc = new ConsoleCreator(name, out.getIcon());
                if (SwingUtilities.isEventDispatchThread()) {
                    cc.run();
                } else {
                    SwingUtilities.invokeAndWait(cc);
                }
                console = cc.getConsole();
            }
            return console.getOutputStream(out.getAttributeSet(), out.isAutoShow());
        }
        catch (InvocationTargetException x) {
            throw new IOException(x.getTargetException());
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
    }

    synchronized void showMe(Console console) {
        final PageContext context = this.contexts.get(console);
        if (context != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    context.requestShow();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    }

    @Override
    public void showConsole(Console console) {
        this.showMe(console);
    }

    @Override
    public PageContext getPageContextForConsole(Console console) {
        return this.contexts.get(console);
    }

    void preferencesChanged(ConsolePreferences pref) {
        this.stdoutSwitchedOutput.setUseOne(pref.isRedirectStandardOutput());
        this.stderrSwitchedOutput.setUseOne(pref.isRedirectStandardError());
        this.stdoutOutput.setAutoShow(pref.isAutoShowStandardOutput());
        this.stderrOutput.setAutoShow(pref.isAutoShowStandardError());
    }

    private static class SwitchedOutputStream
    extends OutputStream {
        private final OutputStream one;
        private final OutputStream two;
        private boolean useOne = true;

        SwitchedOutputStream(OutputStream one, OutputStream two) {
            this.one = one;
            this.two = two;
        }

        @Override
        public void write(int b) throws IOException {
            (this.useOne ? this.one : this.two).write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            (this.useOne ? this.one : this.two).write(b, off, len);
        }

        public boolean isUseOne() {
            this.useOne = true;
            return true;
        }

        public void setUseOne(boolean useOne) {
            this.useOne = useOne;
        }
    }

    private static class PerThreadOutputStream
    extends OutputStream {
        private final OutputStream fallback;
        private Map<Thread, OutputStream> threadOutputs = new WeakHashMap<Thread, OutputStream>();

        PerThreadOutputStream(OutputStream fallback) {
            this.fallback = fallback;
        }

        @Override
        public void write(int b) throws IOException {
            OutputStream out = this.threadOutputs.get(Thread.currentThread());
            (out == null ? this.fallback : out).write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            OutputStream out = this.threadOutputs.get(Thread.currentThread());
            (out == null ? this.fallback : out).write(b, off, len);
        }

        void mapThreadToOutputStream(Thread t, OutputStream out) {
            this.threadOutputs.put(t, out);
        }
    }

    private class ConsoleCreator
    implements Runnable {
        private String name;
        private Icon icon;
        private Console console;

        ConsoleCreator(String name, Icon icon) {
            this.name = name;
            this.icon = icon;
        }

        @Override
        public void run() {
            this.console = ConsolePlugin.this.createConsole(this.name, this.icon);
        }

        Console getConsole() {
            return this.console;
        }
    }
}

