/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree.utils.linkNode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Plugin;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeEvent;
import org.freehep.jas.plugin.tree.FTreeNodeListener;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeStructureProvider;
import org.freehep.jas.plugin.tree.FTreeNodeTransferable;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.plugin.tree.utils.linkNode.LinkNode;
import org.freehep.jas.plugin.tree.utils.linkNode.LinkNodeIcon;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.images.ImageHandler;

public class LinkNodePlugin
extends Plugin {
    private static final Icon brokenLinkIcon = ImageHandler.getIcon((String)"images/BrokenLink.gif", LinkNode.class);

    protected void postInit() {
        FTreeProvider treeProvider = (FTreeProvider)this.getApplication().getLookup().lookup(FTreeProvider.class);
        treeProvider.treeNodeAdapterRegistry().registerNodeAdapter(new LinkNodeAdapter(), LinkNode.class);
    }

    class LinkNodeAdapter
    extends DefaultFTreeNodeAdapter {
        public LinkNodeAdapter() {
            super(1000);
        }

        @Override
        public Icon icon(FTreeNode node, Icon oldIcon, boolean selected, boolean expanded) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode == null) {
                return brokenLinkIcon;
            }
            Icon icon = node.tree().adapterForClass(linkedNode.type()).icon(linkedNode, oldIcon, selected, expanded);
            if (node.objectForClass(LinkNode.class) instanceof DefaultLink) {
                return icon;
            }
            return new LinkNodeIcon(icon);
        }

        @Override
        public boolean doubleClick(FTreeNode node) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).doubleClick(linkedNode);
            }
            return false;
        }

        @Override
        public String statusMessage(FTreeNode node, String oldMessage) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).statusMessage(linkedNode, oldMessage);
            }
            FTreePath path = ((LinkNode)node.objectForClass(LinkNode.class)).linkedPath();
            return "Broken Link [" + path + "]";
        }

        @Override
        public String toolTipMessage(FTreeNode node, String oldMessage) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).toolTipMessage(linkedNode, oldMessage);
            }
            FTreePath path = ((LinkNode)node.objectForClass(LinkNode.class)).linkedPath();
            return "Broken Link [" + path + "]";
        }

        @Override
        public String text(FTreeNode node, String oldText) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).text(linkedNode, oldText);
            }
            return null;
        }

        @Override
        public boolean allowsChildren(FTreeNode node, boolean allowsChildren) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).allowsChildren(linkedNode, allowsChildren);
            }
            return false;
        }

        @Override
        public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
            FTreeNode[] linkedNodes = new FTreeNode[nodes.length];
            for (int i = 0; i < linkedNodes.length; ++i) {
                linkedNodes[i] = this.linkedNode(nodes[0]);
            }
            if (linkedNodes[0] != null) {
                menu = nodes[0].tree().adapterForClass(linkedNodes[0].type()).modifyPopupMenu(linkedNodes, menu);
            }
            return menu;
        }

        @Override
        public FTreeNodeTransferable modifyTransferable(FTreeNode[] nodes, FTreeNodeTransferable transferable) {
            FTreeNode[] linkedNodes = new FTreeNode[nodes.length];
            for (int i = 0; i < linkedNodes.length; ++i) {
                linkedNodes[i] = this.linkedNode(nodes[0]);
            }
            if (linkedNodes[0] != null) {
                return nodes[0].tree().adapterForClass(linkedNodes[0].type()).modifyTransferable(linkedNodes, transferable);
            }
            return null;
        }

        @Override
        public Component treeCellRendererComponent(Component component, FTreeNode node, boolean sel, boolean expanded, boolean leaf, boolean hasFocus) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).treeCellRendererComponent(component, linkedNode, sel, expanded, leaf, hasFocus);
            }
            return component;
        }

        @Override
        public boolean mouseClicked(FTreeNode node, MouseEvent mouseEvent, Dimension dimension) {
            FTreeNode linkedNode = this.linkedNode(node);
            if (linkedNode != null) {
                return node.tree().adapterForClass(linkedNode.type()).mouseClicked(linkedNode, mouseEvent, dimension);
            }
            return false;
        }

        @Override
        public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
            FTreeNode[] linkedNodes = new FTreeNode[selectedNodes.length];
            for (int i = 0; i < linkedNodes.length; ++i) {
                linkedNodes[i] = this.linkedNode(selectedNodes[0]);
            }
            if (linkedNodes[0] != null) {
                return selectedNodes[0].tree().adapterForClass(linkedNodes[0].type()).commandProcessor(linkedNodes);
            }
            return null;
        }

        @Override
        public void checkForChildren(FTreeNode node) {
            FTreeNode linkedNode;
            Object obj = node.value("linkChildrenChecked");
            if (obj == null && (linkedNode = this.linkedNode(node)) != null) {
                node.addKey("linkChildrenChecked", new Boolean(true));
                FTreeNodeStructureProvider provider = node.tree().adapterForClass(linkedNode.type()).nodeStructureProvider(linkedNode);
                List child = provider.nodes();
                int nChild = child.size();
                if (nChild == 0) {
                    node.tree().adapterForClass(linkedNode.type()).checkForChildren(linkedNode);
                } else {
                    for (int i = 0; i < nChild; ++i) {
                        FTreeNode c = (FTreeNode)child.get(i);
                        node.tree().treeChanged(new FTreeNodeAddedNotification((Object)this, node.path().pathByAddingChild(c.path().getLastPathComponent()), (Object)new DefaultLink(c.path(), node.tree())));
                    }
                }
            }
        }

        private FTreeNode linkedNode(FTreeNode node) {
            FTreeNode linkedNode;
            LinkNode link = (LinkNode)node.objectForClass(LinkNode.class);
            Object obj = node.value("linkedNode");
            if (obj == null) {
                try {
                    FTreePath path = link.linkedPath();
                    FTree tree = link.tree();
                    linkedNode = tree.findNode(path);
                    node.addKey("linkedNode", linkedNode);
                    linkedNode.parent().addFTreeNodeListener(new LinkedNodeListener(node));
                }
                catch (RuntimeException re) {
                    linkedNode = null;
                }
            } else {
                linkedNode = (FTreeNode)obj;
            }
            return linkedNode;
        }

        private class LinkedNodeListener
        implements FTreeNodeListener {
            private FTreeNode node;

            LinkedNodeListener(FTreeNode node) {
                this.node = node;
            }

            @Override
            public void nodeChanged(FTreeNodeEvent event) {
                FTreeNode linkedNode = (FTreeNode)this.node.value("linkedNode");
                if (event.eventId() == 1) {
                    if (event.node() == linkedNode) {
                        if (this.node.objectForClass(LinkNode.class) instanceof DefaultLink) {
                            FTreePath removedPath = this.node.path();
                            this.node.tree().treeChanged(new FTreeNodeRemovedNotification((Object)this, removedPath));
                        } else {
                            this.node.removeKey("linkedNode");
                        }
                    }
                } else if (event.eventId() == 0 && event.source() == linkedNode) {
                    FTreeNode addedNode = event.node();
                    FTreePath newNodePath = this.node.path();
                    newNodePath = newNodePath.pathByAddingChild(addedNode.path().getLastPathComponent());
                    this.node.tree().treeChanged(new FTreeNodeAddedNotification((Object)this, newNodePath, (Object)new DefaultLink(addedNode.path(), this.node.tree())));
                }
            }
        }

        private class DefaultLink
        implements LinkNode {
            private FTreePath linkedPath;
            private FTree tree;

            DefaultLink(FTreePath linkedPath, FTree tree) {
                this.linkedPath = linkedPath;
                this.tree = tree;
            }

            @Override
            public FTreePath linkedPath() {
                return this.linkedPath;
            }

            @Override
            public FTree tree() {
                return this.tree;
            }
        }
    }
}

