/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.MutedAlertRequest;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.alert.AckDialog;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;
import org.lsst.ccs.gconsole.plugins.alert.MuteDialog;
import org.lsst.ccs.gconsole.plugins.alert.MuteListDialog;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.services.lock.Locker;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.util.swing.CompositeIcon;
import org.lsst.ccs.gconsole.util.tree.TreeUtil;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;

public class AlertViewer
implements AlertListener {
    private final LsstAlertPlugin plugin;
    private Descriptor config;
    private AlertTree tree;
    private JTextPane infoPanel;
    private JPanel rightPanel;
    private JScrollPane leftPanel;
    private JSplitPane rootPanel;
    private Action clearAction;
    private Action ackAction;
    private Action muteAction;
    private MuteListDialog muteListDialog;
    private JCheckBox freezeBox;
    private JButton muteButton;
    boolean historyProp;
    boolean soundProp;
    boolean toFrontProp;
    boolean selectNewProp;
    boolean ignoreMutedProp;
    boolean ignoreAckProp;
    private StyledDocument document;
    private Style attBase;
    private Style attBlack;
    private Style attBlackBold;
    private final EnumMap<AlertState, Style> attPlane = new EnumMap(AlertState.class);
    private final EnumMap<AlertState, Style> attBold = new EnumMap(AlertState.class);
    private StatusMessageListener messageListener;
    private final TreeMap<String, TreeMap<String, MutedAlertRequest>> muteRequests = new TreeMap();
    private static final String MUTE_ALL = ".*";
    private LockService.Listener lockListener;
    private final Map<String, Locker> lockers = new HashMap<String, Locker>();
    static final EnumMap<AlertState, Color> COLOR = new EnumMap(AlertState.class);
    private static final ImageIcon ACK_ICON;
    private static final ImageIcon MUTE_ICON;

    public AlertViewer(LsstAlertPlugin plugin, Descriptor configuration) {
        this.plugin = plugin;
        this.config = configuration == null ? new Descriptor() : configuration;
        this.soundProp = (Boolean)plugin.getServices().getProperty("sound");
        this.toFrontProp = (Boolean)plugin.getServices().getProperty("toFront");
        this.selectNewProp = (Boolean)plugin.getServices().getProperty("selectLast");
        this.ignoreAckProp = (Boolean)plugin.getServices().getProperty("ignoreAck");
        this.ignoreMutedProp = (Boolean)plugin.getServices().getProperty("ignoreMuted");
    }

    private void start() {
        HashMap<String, Serializable> data;
        this.muteAction = new AbstractAction("Mute"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node == null || node == AlertViewer.this.tree.getRoot()) {
                    return;
                }
                boolean toMute = "Mute".equals(this.getValue("Name").toString());
                String agent = node.getAgentName();
                if (toMute) {
                    Object regEx;
                    if (node.getLevel() == 1) {
                        regEx = AlertViewer.MUTE_ALL;
                    } else if (node instanceof IDNode) {
                        IDNode idNode = (IDNode)node;
                        regEx = idNode.getID();
                    } else {
                        regEx = node.getIDPrefix() + AlertViewer.MUTE_ALL;
                    }
                    MuteDialog.show(AlertViewer.this.rootPanel, agent, (String)regEx);
                } else {
                    MutedAlertRequest r = node.getMuteRequest();
                    if (r != null) {
                        AlertViewer.sendCommandToMMM("cancelMutedAlertRequest", r.getUniqueId());
                    } else if (node.getLevel() == 1) {
                        AlertViewer.sendCommandToMMM("cancelAllMutedAlertRequestForSubsystem", node.getAgentName());
                    }
                }
            }
        };
        Box buttonPanel = Box.createHorizontalBox();
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node == null) {
                    return;
                }
                final String agent = node.getAgentName();
                final String[] alerts = node.getIDs();
                final AlertState maxSeverity = node.getAlertLevel();
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        AlertViewer.this.plugin.clearAlerts(agent, maxSeverity, alerts);
                        return null;
                    }
                }.execute();
            }
        };
        this.clearAction.putValue("ShortDescription", "Clear selected alerts.");
        buttonPanel.add(new JButton(this.clearAction));
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.muteButton = new JButton("Mute");
        this.muteButton.setToolTipText("Edit mute requests.");
        this.muteButton.addActionListener(e -> {
            AlertNode node = this.tree.getSelectedNode();
            String agent = null;
            String regex = null;
            if (node != null) {
                agent = node.getAgentName();
                MutedAlertRequest r = node.getMuteRequest();
                if (r != null) {
                    regex = r.getAlertIdRegEx();
                }
            }
            this.muteListDialog = MuteListDialog.show(this.rootPanel, this.muteRequests, agent, regex);
            this.muteListDialog.setVisible(true);
            this.muteListDialog = null;
        });
        buttonPanel.add(this.muteButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        this.ackAction = new AbstractAction("Acknowledge"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node == null) {
                    return;
                }
                AckDialog d = AckDialog.show(node, AlertViewer.this.rootPanel);
                if (d != null) {
                    final String message = d.message;
                    final String[] toAck = d.alertsToAck;
                    final String[] toNack = d.alertsToNack;
                    final String agent = node.getAgentName();
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            AlertViewer.this.plugin.ackAlerts(message, agent, toAck, toNack);
                            return null;
                        }
                    }.execute();
                }
            }
        };
        this.ackAction.putValue("ShortDescription", "Acknowledge or un-acknowledge selected alerts.");
        this.freezeBox = new JCheckBox("Freeze");
        this.freezeBox.setSelected(false);
        this.freezeBox.addActionListener(e -> {
            if (!this.freezeBox.isSelected()) {
                this.tree.getSelectedNode().fillInfoPanel(this);
            }
        });
        this.freezeBox.setToolTipText("Freeze information panel content");
        buttonPanel.add(this.freezeBox);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        JButton settingsButton = new JButton("Settings");
        settingsButton.addActionListener(e -> {
            SettingsPanel sp = new SettingsPanel();
            int out = JOptionPane.showConfirmDialog(settingsButton, sp, "Alert Viewer Settings", 2);
            if (out == 0) {
                sp.save();
            }
        });
        settingsButton.setToolTipText("Modify alert viewer settings");
        buttonPanel.add(settingsButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(20, 5)));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree = new AlertTree();
        this.tree.init();
        this.tree.addTreeSelectionListener(e -> {
            AlertNode node = this.tree.getSelectedNode();
            if (node == null) {
                if (!this.freezeBox.isSelected()) {
                    this.infoPanel.setText("");
                }
            } else if (!this.freezeBox.isSelected()) {
                node.fillInfoPanel(this);
            }
            this.enableActions();
        });
        this.tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AlertViewer.this.freezeBox.isSelected()) {
                    AlertViewer.this.freezeBox.doClick();
                }
            }
        });
        this.infoPanel = new JTextPane();
        this.infoPanel.setEditable(false);
        this.infoPanel.setContentType("text/plain");
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        try {
            DefaultCaret caret = (DefaultCaret)this.infoPanel.getCaret();
            caret.setUpdatePolicy(1);
        }
        catch (ClassCastException caret) {
            // empty catch block
        }
        this.infoPanel.setText("");
        this.document = this.infoPanel.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.attBase = this.document.addStyle("attBase", style);
        this.attBlack = this.document.addStyle("attBlack", this.attBase);
        this.attBlackBold = this.document.addStyle("attBlackBold", this.attBase);
        StyleConstants.setBold(this.attBlackBold, true);
        for (AlertState state : AlertState.values()) {
            style = this.document.addStyle(state.name(), this.attBase);
            StyleConstants.setForeground(style, COLOR.get(state));
            this.attPlane.put(state, style);
            style = this.document.addStyle(state.name(), style);
            StyleConstants.setBold(style, true);
            this.attBold.put(state, style);
        }
        this.rightPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.infoPanel);
        this.rightPanel.add((Component)scroll, "Center");
        this.rightPanel.add((Component)buttonPanel, "South");
        this.leftPanel = new JScrollPane(this.tree);
        this.rootPanel = new JSplitPane(1, this.leftPanel, this.rightPanel);
        Dimension minimumSize = new Dimension(100, 50);
        this.leftPanel.setMinimumSize(minimumSize);
        this.rightPanel.setMinimumSize(minimumSize);
        this.rootPanel.setOneTouchExpandable(false);
        this.rootPanel.setResizeWeight(0.3);
        this.rootPanel.resetToPreferredSizes();
        HashMap<Object, Object> par = new HashMap<Object, Object>();
        DataPanelDescriptor panDesc = this.config.getPage();
        if (panDesc != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
            par.putAll(data);
        }
        par.put(Panel.TITLE, "Alerts");
        Consumer<JComponent> onClose = c -> this.stop();
        par.put(Panel.ON_CLOSE, onClose);
        Console.getConsole().getPanelManager().open((Component)this.rootPanel, par);
        this.messageListener = msg -> {
            try {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                String key = ssd.getDataKey();
                if ("MutedAlertRequestPublicationKey".equals(key)) {
                    KeyValueData kv = ssd.getSubsystemData();
                    List mutes = (List)((Object)kv.getValue());
                    SwingUtilities.invokeLater(() -> this.update(new ArrayList<MutedAlertRequest>(mutes)));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        };
        AgentMessagingLayer aml = this.plugin.getConsole().getMessagingAccess();
        aml.addStatusMessageListener(this.messageListener, msg -> msg.getOriginAgentInfo().getType() == AgentInfo.AgentType.MMM && msg instanceof StatusSubsystemData);
        AlertViewer.sendCommandToMMM("publishListOfMutedAlerts", new Object[0]);
        this.lockListener = new LockService.Listener(){

            @Override
            public void agentsAdded(Locker ... agents) {
                for (Locker a : agents) {
                    AlertViewer.this.lockers.put(a.getName(), a);
                }
                AlertViewer.this.enableActions();
            }

            @Override
            public void agentsRemoved(Locker ... agents) {
                for (Locker a : agents) {
                    AlertViewer.this.lockers.remove(a.getName());
                }
                AlertViewer.this.enableActions();
            }

            @Override
            public void agentsUpdated(Locker ... agents) {
                this.agentsAdded(agents);
            }

            @Override
            public void userChanged(String oldUserID, String newUserID) {
                AlertViewer.this.enableActions();
            }
        };
        LockService.getService().addListener(this.lockListener);
    }

    void stop() {
        if (this.rootPanel == null) {
            return;
        }
        this.plugin.getConsole().getMessagingAccess().removeStatusMessageListener(this.messageListener);
        LockService.getService().removeListener(this.lockListener);
        this.lockListener = null;
        this.config = this.save();
        this.clearAction = null;
        this.tree = null;
        this.infoPanel = null;
        this.rightPanel = null;
        this.leftPanel = null;
        this.rootPanel = null;
    }

    void destroy() {
        if (this.rootPanel != null) {
            Console.getConsole().getPanelManager().close(this.rootPanel);
        }
    }

    JComponent getGUI() {
        return this.rootPanel;
    }

    public void onAlert(AlertEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.update(event);
        } else {
            SwingUtilities.invokeLater(() -> this.update(event));
        }
    }

    private void update(AlertEvent event) {
        TreePath path;
        String id;
        String source = event.getSource();
        RaisedAlertSummary summary = event.getSummary();
        if (summary == null) {
            AlertNode sourceNode;
            if (this.tree != null && (sourceNode = this.getAgentNode(source)) != null) {
                sourceNode.removeFromParent();
                this.tree.getModel().reload();
                this.tree.clearSelection();
            }
            return;
        }
        Set currentAlerts = summary.getAllRaisedAlertHistories();
        if (this.tree == null) {
            if (currentAlerts.isEmpty()) {
                return;
            }
            this.start();
        }
        TreePath selPath = this.tree.getSelectionPath();
        AlertNode sourceNode = this.getAgentNode(source);
        if (sourceNode == null) {
            if (currentAlerts.isEmpty()) {
                return;
            }
            sourceNode = new AlertNode(source);
            for (Object h2 : currentAlerts) {
                this.updateAlert(sourceNode, (RaisedAlertHistory)h2);
            }
            this.tree.getRoot().add(sourceNode);
        } else {
            HashMap id2history = new HashMap(currentAlerts.size() * 2);
            currentAlerts.forEach(h -> id2history.put(h.getLatestAlert().getAlertId(), h));
            for (IDNode idNode : sourceNode.getLeaves()) {
                id = idNode.getID();
                RaisedAlertHistory history = (RaisedAlertHistory)id2history.remove(id);
                if (history == null) {
                    this.removeAlert(idNode);
                    continue;
                }
                this.updateAlert(sourceNode, history);
            }
            for (RaisedAlertHistory h3 : id2history.values()) {
                this.updateAlert(sourceNode, h3);
            }
        }
        ArrayList<TreePath> state = TreeUtil.saveExpansionState(this.tree);
        this.tree.getModel().reload();
        TreeUtil.restoreExpansionState(this.tree, state);
        boolean ignore = this.ignore(event);
        if (this.selectNewProp && !ignore) {
            Object[] objectArray;
            IDNode idNode;
            id = "";
            Alert alert = event.getAlert();
            if (alert == null) {
                for (String clearedID : event.getClearedIds()) {
                    try {
                        if (!event.isPartialClear(clearedID)) continue;
                        id = clearedID;
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                }
            } else {
                id = alert.getAlertId();
            }
            IDNode iDNode = idNode = id.isEmpty() ? null : this.tree.findID(sourceNode, id);
            if (idNode == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.tree.getRoot();
                objectArray = objectArray2;
                objectArray2[1] = sourceNode;
            } else {
                objectArray = idNode.getPath();
            }
            path = new TreePath(objectArray);
        } else {
            path = selPath;
        }
        if (this.isValidPath(path)) {
            this.tree.setSelectionPath(path);
            this.tree.expandPath(path);
        } else {
            this.tree.clearSelection();
        }
        if (!ignore && !this.soundProp) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.toFrontProp && !ignore) {
            this.toFront();
        }
    }

    private void update(List<MutedAlertRequest> mutes) {
        this.muteRequests.clear();
        mutes.forEach(r -> {
            String agent = r.getSubsystemName();
            TreeMap mm = this.muteRequests.computeIfAbsent(agent, a -> new TreeMap());
            mm.put(r.getAlertIdRegEx(), r);
        });
        if (this.tree == null) {
            return;
        }
        Enumeration<TreeNode> e = this.tree.getRoot().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            this.tree.getModel().nodeChanged(e.nextElement());
        }
        if (this.muteListDialog != null) {
            this.muteListDialog.update();
        }
    }

    void toFront() {
        if (this.rootPanel == null) {
            AlertService serv = (AlertService)this.plugin.getConsole().getAgentService(AlertService.class);
            LinkedList events = new LinkedList();
            AlertListener temp = e -> events.add(e);
            serv.addListener(temp);
            serv.removeListener(temp);
            events.forEach(e -> this.update((AlertEvent)e));
        } else {
            PanelManager panMan = this.plugin.getConsole().getPanelManager();
            try {
                panMan.set(this.rootPanel, Panel.SELECTED, true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private AlertNode getAgentNode(String agentName) {
        AlertNode root = this.tree.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            AlertNode node = root.getChildAt(i);
            if (!node.getUserObject().equals(agentName)) continue;
            return node;
        }
        return null;
    }

    public static String formatTimeStamp(Instant instant) {
        return Const.DEFAULT_DT_FORMAT.format(instant);
    }

    public static String formatTimeStamp(long time) {
        return AlertViewer.formatTimeStamp(Instant.ofEpochMilli(time));
    }

    private void updateAlert(AlertNode sourceNode, RaisedAlertHistory history) {
        String id = history.getLatestAlert().getAlertId();
        String[] ss = id.split("/");
        ArrayList<String> tokens = new ArrayList<String>(ss.length);
        for (String s : ss) {
            if ((s = s.trim()).isEmpty()) continue;
            tokens.add(s);
        }
        if (tokens.isEmpty()) {
            return;
        }
        for (int i = 0; i < tokens.size() - 1; ++i) {
            String s = (String)tokens.get(i);
            AlertNode tokenNode = null;
            Enumeration<TreeNode> e = sourceNode.children();
            while (e.hasMoreElements()) {
                AlertNode node = (AlertNode)e.nextElement();
                if (node.isLeaf() || !node.getUserObject().equals(s)) continue;
                tokenNode = node;
                break;
            }
            if (tokenNode == null) {
                tokenNode = new AlertNode(s);
                sourceNode.add(tokenNode);
            }
            sourceNode = tokenNode;
        }
        IDNode idNode = null;
        Enumeration<TreeNode> e = sourceNode.children();
        while (e.hasMoreElements()) {
            IDNode node;
            TreeNode o = e.nextElement();
            if (!(o instanceof IDNode) || !(node = (IDNode)o).getID().equals(id)) continue;
            idNode = node;
            break;
        }
        if (idNode == null) {
            idNode = new IDNode(history);
            sourceNode.add(idNode);
        } else {
            idNode.setHistory(history);
        }
    }

    private void removeAlert(IDNode idNode) {
        AlertNode node = idNode;
        AlertNode parent;
        while ((parent = node.getParent()) != null) {
            if (parent.isRoot() || parent.getChildCount() > 1) {
                node.removeFromParent();
                return;
            }
            node = parent;
        }
        return;
    }

    private boolean isValidPath(TreePath path) {
        if (path == null) {
            return false;
        }
        int n = path.getPathCount();
        if (n == 0) {
            return false;
        }
        AlertNode child = (AlertNode)path.getLastPathComponent();
        for (int i = n - 2; i >= 0; --i) {
            AlertNode parentFromPath = (AlertNode)path.getPathComponent(i);
            AlertNode parentFromChild = child.getParent();
            if (parentFromPath == null || parentFromChild == null || !parentFromPath.equals(parentFromChild)) {
                return false;
            }
            child = parentFromPath;
        }
        return child.equals(this.tree.getRoot());
    }

    private boolean isAcknowledged(AlertEvent event) {
        RaisedAlertHistory hist;
        Alert alert;
        RaisedAlertSummary sum = event.getSummary();
        if (sum != null && (alert = event.getAlert()) != null && (hist = sum.getRaisedAlert(alert.getAlertId())) != null) {
            return hist.isAcknowledged();
        }
        return false;
    }

    private boolean isMuted(String agent, String alertID) {
        TreeMap<String, MutedAlertRequest> mm = this.muteRequests.get(agent);
        if (mm != null) {
            for (MutedAlertRequest r : mm.values()) {
                if (!r.isValid() || !r.matches(alertID)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ignore(AlertEvent event) {
        return switch (event.getType()) {
            case AlertEvent.AlertEventType.ALERT_RAISED -> {
                if (this.ignoreMutedProp && this.isMuted(event.getSource(), event.getAlert().getAlertId())) {
                    yield true;
                }
                if (this.ignoreAckProp && this.isAcknowledged(event)) {
                    yield true;
                }
                yield false;
            }
            case AlertEvent.AlertEventType.ALERT_CLEARED -> {
                if (this.ignoreMutedProp) {
                    String agent = event.getSource();
                    for (String alertID : event.getClearedIds()) {
                        if (this.isMuted(agent, alertID)) continue;
                        yield false;
                    }
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void enableActions() {
        AlertNode node = this.tree.getSelectedNode();
        String mmm = AlertViewer.getMmmName();
        if (node == null || node == this.tree.getRoot()) {
            if (this.clearAction != null) {
                this.clearAction.setEnabled(false);
            }
            if (this.ackAction != null) {
                this.ackAction.setEnabled(false);
            }
            if (this.muteAction != null) {
                this.muteAction.setEnabled(false);
            }
        } else {
            String agentName = node.getAgentName();
            Locker locker = this.lockers.get(agentName);
            if (this.clearAction != null) {
                if (locker == null) {
                    this.clearAction.setEnabled(false);
                } else {
                    this.clearAction.setEnabled(locker.getMaxLevel() != -1);
                }
            }
            if (this.ackAction != null) {
                this.ackAction.setEnabled(true);
            }
            if (this.muteAction != null) {
                if (mmm == null) {
                    this.muteAction.setEnabled(false);
                } else {
                    Locker mmmLocker = this.lockers.get(agentName);
                    this.muteAction.setEnabled(mmmLocker != null && mmmLocker.getMaxLevel() != -1 && (locker == null || locker.getMaxLevel() != -1));
                }
            }
        }
        if (this.muteButton != null) {
            this.muteButton.setEnabled(mmm != null);
        }
    }

    private static String getMmmName() {
        String mmm = null;
        AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
        if (aml != null) {
            for (AgentInfo ai : aml.getAgentPresenceManager().listConnectedAgents()) {
                if (ai.getType() != AgentInfo.AgentType.MMM) continue;
                mmm = ai.getName();
                break;
            }
        }
        return mmm;
    }

    static void sendCommandToMMM(final String command, final Object ... args) {
        new SwingWorker<CommandTask, Void>(){

            @Override
            protected CommandTask doInBackground() throws Exception {
                String mmmName = AlertViewer.getMmmName();
                if (mmmName == null) {
                    return null;
                }
                CommandService serv = CommandService.getService();
                if (args.length == 0) {
                    return serv.sendRaw(mmmName, command, new Object[0]);
                }
                Object[] aa = Arrays.copyOf(args, args.length + 1);
                aa[args.length] = new Options().withOption("w");
                return serv.sendRaw(mmmName, command, aa);
            }
        }.execute();
    }

    Descriptor save() {
        if (this.rootPanel != null) {
            this.config.setPage(DataPanelDescriptor.get(this.rootPanel));
        }
        return this.config;
    }

    static {
        COLOR.put(AlertState.NOMINAL, new Color(0, 170, 0));
        COLOR.put(AlertState.WARNING, new Color(0, 0, 170));
        COLOR.put(AlertState.ALARM, new Color(170, 0, 0));
        ACK_ICON = new ImageIcon(AlertViewer.class.getResource("check_16.png"), "acknowledged");
        MUTE_ICON = new ImageIcon(AlertViewer.class.getResource("mute_16.png"), "mute");
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private DataPanelDescriptor page;

        public DataPanelDescriptor getPage() {
            return this.page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }
    }

    private final class AlertTree
    extends JTree
    implements HasPopupItems {
        private AlertTree() {
        }

        private void init() {
            this.setModel(new AlertTreeModel());
            this.getSelectionModel().setSelectionMode(1);
            this.setCellRenderer(new AlertTreeRenderer());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public AlertNode getSelectedNode() {
            return (AlertNode)this.getLastSelectedPathComponent();
        }

        @Override
        public AlertTreeModel getModel() {
            return (AlertTreeModel)super.getModel();
        }

        AlertNode getRoot() {
            return this.getModel().getRoot();
        }

        IDNode findID(AlertNode sourceNode, String id) {
            if (sourceNode == null) {
                return null;
            }
            Enumeration<TreeNode> e = sourceNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode) || !((IDNode)node).getID().equals(id)) continue;
                return (IDNode)node;
            }
            return null;
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component cmpnt, Point point) {
            TreePath tp = this.getPathForLocation(point.x, point.y);
            if (tp != null) {
                this.setSelectionPath(tp);
                AlertNode node = this.getSelectedNode();
                if (node != null && node != this.getRoot()) {
                    menu.insert(new JSeparator(), 0);
                    menu.insert(AlertViewer.this.ackAction, 0);
                    menu.insert(AlertViewer.this.clearAction, 0);
                    AlertViewer.this.muteAction.putValue("Name", node.getMuteRequest() == null ? "Mute" : "Unmute");
                    menu.insert(AlertViewer.this.muteAction, 0);
                }
            }
            return menu;
        }
    }

    class AlertNode
    extends DefaultMutableTreeNode
    implements Comparable<AlertNode> {
        AlertNode(String userObject) {
            super(userObject);
        }

        @Override
        public String getUserObject() {
            return (String)super.getUserObject();
        }

        @Override
        public int compareTo(AlertNode other) {
            return this.getUserObject().compareTo(other.getUserObject());
        }

        @Override
        public void add(MutableTreeNode newChildNode) {
            AlertNode newChild = (AlertNode)newChildNode;
            Enumeration<TreeNode> e = this.children();
            int i = 0;
            boolean replace = false;
            while (e.hasMoreElements()) {
                AlertNode child = (AlertNode)e.nextElement();
                int c = newChild.compareTo(child);
                if (c > 0) {
                    ++i;
                    continue;
                }
                if (c != 0) break;
                replace = true;
                break;
            }
            if (replace) {
                this.remove(i);
            }
            this.insert(newChild, i);
        }

        @Override
        public AlertNode getParent() {
            return (AlertNode)super.getParent();
        }

        @Override
        public AlertNode getChildAt(int index) {
            return (AlertNode)super.getChildAt(index);
        }

        public List<IDNode> getLeaves() {
            ArrayList<IDNode> out = new ArrayList<IDNode>();
            Enumeration<TreeNode> e = this.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                if (!(node instanceof IDNode)) continue;
                IDNode idNode = (IDNode)node;
                out.add(idNode);
            }
            return out;
        }

        public String[] getIDs() {
            TreeSet ss = new TreeSet();
            this.getLeaves().stream().map(node -> node.getID()).forEach(id -> ss.add(id));
            return ss.toArray(new String[0]);
        }

        public String getIDPrefix() {
            Object[] pp = this.getUserObjectPath();
            return switch (pp.length) {
                case 1, 2 -> "";
                default -> {
                    ArrayList<String> ss = new ArrayList<String>(pp.length - 2);
                    for (int i = 2; i < pp.length; ++i) {
                        ss.add(pp[i].toString());
                    }
                    yield String.join((CharSequence)"/", ss);
                }
            };
        }

        void fillInfoPanel(AlertViewer v) {
            StyledDocument d = v.document;
            try {
                d.remove(0, d.getLength());
                d.insertString(d.getLength(), "Source: ", v.attBlack);
                d.insertString(d.getLength(), this.getAgentName() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Alerts selected: ", v.attBlack);
                d.insertString(d.getLength(), this.getLeafCount() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Highest alert level: ", v.attBlack);
                AlertState highestState = this.getAlertLevel();
                d.insertString(d.getLength(), highestState + "\n", v.attBold.get(highestState));
                d.insertString(d.getLength(), "Last changed at ", v.attBlack);
                d.insertString(d.getLength(), Const.DEFAULT_DT_FORMAT.format(this.getTimeStamp()) + "\n", v.attBlackBold);
                v.infoPanel.setCaretPosition(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        String getAgentName() {
            int level = this.getLevel();
            if (level > 1) {
                return this.getParent().getAgentName();
            }
            return this.getUserObject();
        }

        Instant getTimeStamp() {
            Instant out = Instant.EPOCH;
            if (this.children != null) {
                for (Object child : this.children) {
                    Instant time = ((AlertNode)child).getTimeStamp();
                    if (time.compareTo(out) <= 0) continue;
                    out = time;
                }
            }
            return out;
        }

        AlertState getAlertLevel() {
            AlertState childState;
            AlertState alertState = AlertState.NOMINAL;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements() && ((childState = ((AlertNode)e.nextElement()).getAlertLevel()).compareTo((Enum)alertState) <= 0 || !(alertState = childState).equals((Object)AlertState.ALARM))) {
            }
            return alertState;
        }

        ImageIcon getIcon() {
            return this.isMuted() ? MUTE_ICON : null;
        }

        boolean isMuted() {
            return this.getMuteRequest() != null;
        }

        MutedAlertRequest getMuteRequest() {
            Map mm = AlertViewer.this.muteRequests.get(this.getAgentName());
            if (mm == null) {
                return null;
            }
            String regex = this.getIDPrefix() + AlertViewer.MUTE_ALL;
            MutedAlertRequest r = (MutedAlertRequest)mm.get(regex);
            if (r != null && !r.isValid()) {
                mm.remove(regex);
                r = null;
            }
            return r;
        }
    }

    private class AlertTreeModel
    extends DefaultTreeModel {
        AlertTreeModel() {
            super(new AlertNode("CCS Alerts"){

                @Override
                ImageIcon getIcon() {
                    return null;
                }

                @Override
                void fillInfoPanel(AlertViewer v) {
                    int activeAlerts = 0;
                    if (this.children != null) {
                        for (Object child : this.children) {
                            if (((AlertNode)child).getAlertLevel() == AlertState.NOMINAL) continue;
                            ++activeAlerts;
                        }
                    }
                    StyledDocument d = v.document;
                    try {
                        d.remove(0, d.getLength());
                        d.insertString(d.getLength(), "CCS Control System\n\n", v.attBlackBold);
                        d.insertString(d.getLength(), "Subsystems with active alerts: ", v.attBlack);
                        d.insertString(d.getLength(), activeAlerts + "\n", v.attBlackBold);
                        d.insertString(d.getLength(), "Overall alert level: ", v.attBlack);
                        d.insertString(d.getLength(), this.getAlertLevel() + "\n", v.attBold.get(this.getAlertLevel()));
                        d.insertString(d.getLength(), "Last changed at ", v.attBlack);
                        d.insertString(d.getLength(), Const.DEFAULT_DT_FORMAT.format(this.getTimeStamp()) + "\n", v.attBlackBold);
                        v.infoPanel.setCaretPosition(0);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }

                @Override
                String getAgentName() {
                    throw new UnsupportedOperationException("Trying to look up source subsystem for the root node.");
                }
            });
        }

        @Override
        public AlertNode getRoot() {
            return (AlertNode)super.getRoot();
        }
    }

    final class IDNode
    extends AlertNode {
        private RaisedAlertHistory history;

        IDNode(RaisedAlertHistory history) {
            super(history.getLatestAlert().getAlertId());
            this.setHistory(history);
        }

        void setHistory(RaisedAlertHistory history) {
            this.history = history;
        }

        RaisedAlertHistory getHistory() {
            return this.history;
        }

        String getID() {
            return this.getUserObject();
        }

        @Override
        public String toString() {
            return this.getLastIdComponent();
        }

        @Override
        public String getIDPrefix() {
            return this.getParent().getIDPrefix();
        }

        String getLastIdComponent() {
            String[] ss = this.getID().split("/");
            int i = ss.length;
            while (i > 0) {
                String s;
                if ((s = ss[--i].trim()).isEmpty()) continue;
                return s;
            }
            return this.getID();
        }

        @Override
        void fillInfoPanel(AlertViewer v) {
            Alert alert = this.history.getLatestAlert();
            ArrayList alerts = this.history.getRaisedAlertInstancesList();
            StyledDocument d = v.document;
            try {
                d.remove(0, d.getLength());
                d.insertString(d.getLength(), "Source: ", v.attBlack);
                d.insertString(d.getLength(), this.getAgentName() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "ID: ", v.attBlack);
                d.insertString(d.getLength(), alert.getAlertId() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Description: ", v.attBlack);
                d.insertString(d.getLength(), alert.getDescription() + "\n", v.attBlackBold);
                d.insertString(d.getLength(), "Highest level: ", v.attBlack);
                d.insertString(d.getLength(), this.history.getHighestAlertState() + "\n", v.attBold.get(this.history.getHighestAlertState()));
                if (this.history.isAcknowledged()) {
                    d.insertString(d.getLength(), this.history.getAcknowledgement() + ".\n", v.attBlack);
                }
                if (this.isMuted()) {
                    Map mm;
                    Object req = this.getMuteRequest();
                    if (req == null && (mm = (Map)AlertViewer.this.muteRequests.get(this.getAgentName())) != null) {
                        String id = this.getID();
                        for (MutedAlertRequest r : mm.values()) {
                            if (!r.matches(id) || req != null && req.getExpirationMillis() >= r.getExpirationMillis()) continue;
                            req = r;
                        }
                    }
                    if (req != null) {
                        StringBuilder sb = new StringBuilder("Muted by ");
                        sb.append(req.getUserName()).append(" until ").append(Const.BRIEF_DT_FORMAT.format(Instant.ofEpochMilli(req.getExpirationMillis()))).append(".\n");
                        d.insertString(d.getLength(), sb.toString(), v.attBlack);
                    }
                }
                d.insertString(d.getLength(), "\n", v.attBlack);
                if (AlertViewer.this.historyProp) {
                    d.insertString(d.getLength(), "History:\n\n", v.attBlackBold);
                    for (RaisedAlertInstance nextAlert : alerts) {
                        d.insertString(d.getLength(), AlertViewer.formatTimeStamp(nextAlert.getCCSTimeStamp().getUTCInstant()) + " " + nextAlert.getAlertState() + "\n", v.attBold.get(nextAlert.getAlertState()));
                        d.insertString(d.getLength(), nextAlert.getCause() + "\n\n", v.attBlack);
                    }
                } else {
                    int n = alerts.size();
                    if (n > 1) {
                        RaisedAlertInstance last = (RaisedAlertInstance)alerts.get(n - 1);
                        d.insertString(d.getLength(), "Last raised: " + AlertViewer.formatTimeStamp(last.getCCSTimeStamp().getUTCInstant()) + " : ", v.attBlackBold);
                        d.insertString(d.getLength(), last.getAlertState() + "\n", v.attBold.get(this.history.getLatestAlertState()));
                        d.insertString(d.getLength(), last.getCause() + "\n\n", v.attBlack);
                    } else if (n > 0) {
                        d.insertString(d.getLength(), "Raised: " + AlertViewer.formatTimeStamp(this.history.getLatestAlertCCSTimeStamp().getUTCInstant()) + " : ", v.attBlackBold);
                        d.insertString(d.getLength(), this.history.getLatestAlertState() + "\n", v.attBold.get(this.history.getLatestAlertState()));
                        d.insertString(d.getLength(), ((RaisedAlertInstance)alerts.get(0)).getCause() + "\n", v.attBlack);
                    }
                }
                v.infoPanel.setCaretPosition(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        Instant getTimeStamp() {
            return this.history.getLatestAlertCCSTimeStamp().getUTCInstant();
        }

        @Override
        AlertState getAlertLevel() {
            return this.history.getHighestAlertState();
        }

        @Override
        ImageIcon getIcon() {
            ImageIcon out = super.getIcon();
            if (this.history != null && this.history.isAcknowledged()) {
                out = CompositeIcon.get(out, ACK_ICON);
            }
            return out;
        }

        @Override
        public List<IDNode> getLeaves() {
            return Collections.singletonList(this);
        }

        @Override
        public String[] getIDs() {
            return new String[]{this.getID()};
        }

        @Override
        MutedAlertRequest getMuteRequest() {
            Map mm = AlertViewer.this.muteRequests.get(this.getAgentName());
            if (mm == null) {
                return null;
            }
            String regex = this.getID();
            MutedAlertRequest r = (MutedAlertRequest)mm.get(regex);
            if (r != null && !r.isValid()) {
                mm.remove(regex);
                r = null;
            }
            return r;
        }

        @Override
        boolean isMuted() {
            Map mm = AlertViewer.this.muteRequests.get(this.getAgentName());
            if (mm == null) {
                return false;
            }
            String id = this.getID();
            for (MutedAlertRequest r : mm.values()) {
                if (!r.matches(id)) continue;
                return true;
            }
            return false;
        }
    }

    private class SettingsPanel
    extends JPanel {
        private final JCheckBox historyBox;
        private final JCheckBox muteBox;
        private final JCheckBox toFrontBox;
        private final JCheckBox selectNewBox;
        private final JCheckBox ignoreMutedBox;
        private final JCheckBox ignoreAckBox;

        SettingsPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            Box root = Box.createVerticalBox();
            this.add(root);
            this.historyBox = new JCheckBox("Show alert history in the information panel.");
            this.historyBox.setSelected(AlertViewer.this.historyProp);
            this.historyBox.setToolTipText("Display recent history of raised alerts for the selected ID, in addition to the current status.");
            this.historyBox.addActionListener(e -> {
                AlertViewer.this.historyProp = this.historyBox.isSelected();
                AlertNode node = AlertViewer.this.tree.getSelectedNode();
                if (node != null) {
                    node.fillInfoPanel(AlertViewer.this);
                }
            });
            root.add(this.historyBox);
            root.add(Box.createRigidArea(Const.VDIM));
            this.muteBox = new JCheckBox("Sound off");
            this.muteBox.setSelected(AlertViewer.this.soundProp);
            this.muteBox.setToolTipText("Disable all audio alerts.");
            root.add(this.muteBox);
            root.add(Box.createRigidArea(Const.VDIM2));
            Box newAlertBox = Box.createVerticalBox();
            newAlertBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            root.add(newAlertBox);
            newAlertBox.add(new JLabel("<html>What happens when a new alert is received from one of the subsystems?"));
            newAlertBox.add(Box.createRigidArea(new Dimension(10, 5)));
            this.toFrontBox = new JCheckBox("Bring the alert viewer to front.");
            this.toFrontBox.setSelected(AlertViewer.this.toFrontProp);
            this.toFrontBox.setToolTipText("Display the alert viewer and bring it to front whenever a new alert is received.");
            this.toFrontBox.addActionListener(e -> this.refresh());
            newAlertBox.add(this.toFrontBox);
            newAlertBox.add(Box.createRigidArea(Const.VDIM));
            this.selectNewBox = new JCheckBox("Select and display the new alert.");
            this.selectNewBox.setSelected(AlertViewer.this.selectNewProp);
            this.selectNewBox.setToolTipText("Automatically select and display any newly raised alert.");
            this.selectNewBox.addActionListener(e -> this.refresh());
            newAlertBox.add(this.selectNewBox);
            newAlertBox.add(Box.createRigidArea(Const.VDIM));
            this.ignoreMutedBox = new JCheckBox("Ignore muted alerts.");
            this.ignoreMutedBox.setSelected(AlertViewer.this.ignoreMutedProp);
            this.ignoreMutedBox.setToolTipText("Do not display the viewer or switch to the new alert if it has been muted by MMM.");
            newAlertBox.add(this.ignoreMutedBox);
            newAlertBox.add(Box.createRigidArea(Const.VDIM));
            this.ignoreAckBox = new JCheckBox("Ignore acknowledged alerts.");
            this.ignoreAckBox.setSelected(AlertViewer.this.ignoreAckProp);
            this.ignoreAckBox.setToolTipText("Do not display the viewer or switch to the new alert if it has been previously acknowledged, and will remain acknowledged.");
            newAlertBox.add(this.ignoreAckBox);
            root.add(Box.createVerticalGlue());
            this.refresh();
        }

        void save() {
            AlertViewer.this.historyProp = this.historyBox.isSelected();
            AlertViewer.this.plugin.getServices().setProperty("history", AlertViewer.this.historyProp);
            AlertViewer.this.soundProp = this.muteBox.isSelected();
            AlertViewer.this.plugin.getServices().setProperty("sound", AlertViewer.this.soundProp);
            AlertViewer.this.selectNewProp = this.selectNewBox.isSelected();
            AlertViewer.this.plugin.getServices().setProperty("selectLast", AlertViewer.this.selectNewProp);
            AlertViewer.this.toFrontProp = this.toFrontBox.isSelected();
            AlertViewer.this.plugin.getServices().setProperty("toFront", AlertViewer.this.toFrontProp);
            AlertViewer.this.ignoreMutedProp = this.ignoreMutedBox.isSelected();
            AlertViewer.this.plugin.getServices().setProperty("ignoreMuted", AlertViewer.this.ignoreMutedProp);
            AlertViewer.this.ignoreAckProp = this.ignoreAckBox.isSelected();
            AlertViewer.this.plugin.getServices().setProperty("ignoreAck", AlertViewer.this.ignoreAckProp);
        }

        private void refresh() {
            boolean attention = this.toFrontBox.isSelected() || this.selectNewBox.isSelected();
            this.ignoreMutedBox.setEnabled(attention);
            this.ignoreAckBox.setEnabled(attention);
        }
    }

    private static class AlertTreeRenderer
    extends DefaultTreeCellRenderer {
        private AlertTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            try {
                AlertNode node = (AlertNode)value;
                AlertState state = node.getAlertLevel();
                if (!sel) {
                    this.setForeground(COLOR.get(state));
                }
                if (leaf) {
                    this.setToolTipText(((IDNode)node).getHistory().getLatestAlert().getDescription());
                } else {
                    this.setToolTipText(null);
                }
            }
            catch (ClassCastException | NullPointerException node) {
                // empty catch block
            }
            try {
                this.setIcon(((AlertNode)value).getIcon());
            }
            catch (RuntimeException x) {
                this.setIcon(null);
            }
            this.setHorizontalTextPosition(10);
            return this;
        }
    }
}

