/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.lsst.ccs.utilities.logging.StackTraceFormats;

public class Logger {
    private final java.util.logging.Logger julDelegate;

    private Logger(java.util.logging.Logger delegate) {
        this.julDelegate = delegate;
        LogManager manager = LogManager.getLogManager();
        if (manager != null) {
            manager.addLogger(delegate);
        }
    }

    public static Logger getLogger(String name) {
        java.util.logging.Logger realLogger = java.util.logging.Logger.getLogger(name);
        return new Logger(realLogger);
    }

    public String getName() {
        return this.julDelegate.getName();
    }

    public Level getLevel() {
        return this.julDelegate.getLevel();
    }

    public void setLevel(Level level) {
        this.julDelegate.setLevel(level);
    }

    protected java.util.logging.Logger getParent() {
        return this.julDelegate.getParent();
    }

    public LogRecord createLogRecord(Level level, String message) {
        StackTraceElement[] stackTraceElements;
        LogRecord res = new LogRecord(level, message);
        for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
            String methodName;
            String className = stackTraceElement.getClassName();
            if (className.startsWith("org.lsst.ccs.utilities.logging") || className.startsWith("org.apache.log4j") || className.contains(".logging.") || "getStackTrace".equals(methodName = stackTraceElement.getMethodName())) continue;
            res.setSourceClassName(className);
            res.setSourceMethodName(methodName);
            break;
        }
        return res;
    }

    protected boolean logMessage(Level level, Object message) {
        this.julDelegate.log(level, String.valueOf(message));
        return true;
    }

    public boolean finest(Object message) {
        return this.logMessage(Level.FINEST, message);
    }

    public boolean debug(Object message) {
        return this.logMessage(Level.FINER, message);
    }

    public boolean fine(Object message) {
        return this.logMessage(Level.FINE, message);
    }

    public boolean info(Object message) {
        return this.logMessage(Level.INFO, message);
    }

    public boolean warn(Object message) {
        return this.logMessage(Level.WARNING, message);
    }

    public boolean warning(Object message) {
        return this.logMessage(Level.WARNING, message);
    }

    public void error(Object message) {
        this.logMessage(Level.SEVERE, message);
    }

    public void fatal(Object message) {
        this.logMessage(Level.SEVERE, message);
    }

    public void severe(Object message) {
        this.logMessage(Level.SEVERE, message);
    }

    public boolean isDebugEnabled() {
        return this.julDelegate.isLoggable(Level.FINER);
    }

    public boolean isInfoEnabled() {
        return this.julDelegate.isLoggable(Level.INFO);
    }

    protected void logSimpleThrowable(Level level, Object message, Throwable throwable) {
        this.julDelegate.log(level, String.valueOf(message), throwable);
    }

    public void fatal(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable);
    }

    public void severe(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable);
    }

    public void error(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.SEVERE, message, throwable);
    }

    public void warn(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.WARNING, message, throwable);
    }

    public void warning(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.WARNING, message, throwable);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable throwable) {
        this.julDelegate.throwing(sourceClass, sourceMethod, throwable);
    }

    public void info(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.INFO, message, throwable);
    }

    public void debug(Object message, Throwable throwable) {
        this.logSimpleThrowable(Level.FINER, message, throwable);
    }

    public boolean isLoggable(Level level) {
        return this.julDelegate.isLoggable(level);
    }

    public void log(LogRecord record) {
        record.setLoggerName(this.julDelegate.getName());
        try {
            this.julDelegate.log(record);
        }
        catch (Exception e) {
            System.out.println("Problem logging record due to exception: " + StackTraceFormats.toString(e));
        }
    }

    @Deprecated
    public void decoupledLog(long delay, LogRecord record) {
        this.log(record);
    }

    public boolean log(Level level, String message, Object argument) {
        this.julDelegate.log(level, message, argument);
        return true;
    }

    @Deprecated
    public boolean decoupledLog(long delay, Level level, String message, Object argument) {
        this.log(level, message, argument);
        return true;
    }

    public boolean log(Level level, String message, Object[] arguments) {
        this.julDelegate.log(level, message, arguments);
        return true;
    }

    @Deprecated
    public boolean decoupledLog(long delay, Level level, String message, Object[] arguments) {
        this.log(level, message, arguments);
        return true;
    }

    public void log(Level level, String message, Throwable throwable) {
        this.julDelegate.log(level, message, throwable);
    }

    @Deprecated
    public void decoupledLog(long delay, Level level, String message, Throwable throwable) {
        this.log(level, message, throwable);
    }
}

