/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.LsstCommandBrowserPlugin;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.util.swing.BoxedComboBox;
import org.lsst.ccs.gconsole.util.swing.BoxedFormattedTextField;
import org.lsst.ccs.gconsole.util.swing.BoxedTextField;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;

class UserManager {
    private Action menuAction;
    private CommandSender sender;
    public Map<String, Map<String, String>> config;

    UserManager() {
    }

    void initialize(LsstCommandBrowserPlugin plugin) {
        this.menuAction = new AbstractAction("Manage users..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserManager.this.sender = CommandService.getService().getSender();
                CommandHandle handle = new CommandHandle(){

                    @Override
                    public void onSuccess(Object result, CommandTask source) {
                        try {
                            Type type = UserManager.class.getField("config").getGenericType();
                            UserManager.this.config = (Map)InputConversionEngine.convertArgToType((String)((String)result), (Type)type);
                            HashSet groups = new HashSet();
                            UserManager.this.config.keySet().forEach(key -> {
                                if (key.startsWith("@")) {
                                    groups.add(key.substring(1));
                                }
                            });
                            groups.forEach(key -> UserManager.this.config.remove(key));
                            GUI gui = new GUI();
                            gui.pack();
                            gui.setLocationRelativeTo(gui.getOwner());
                            gui.setVisible(true);
                        }
                        catch (ClassCastException | NoSuchFieldException | TypeConversionException x) {
                            Console.getConsole().error("Unable to fetch current settings from the lock manager", (Exception)x);
                        }
                    }
                };
                UserManager.this.sender.send(handle, Duration.ofSeconds(3L), "lockmanager getConfigurationParameterValue / maxLevelMap");
            }
        };
        AgentLoginService loginServ = (AgentLoginService)Console.getConsole().getAgentService(AgentLoginService.class);
        loginServ.addAgentLoginUpdateListener(new AgentLoginService.AgentLoginUpdateListener(){

            public void onAgentLoginUpdate(String oldUserId, String newUserId) {
                SwingUtilities.invokeLater(() -> UserManager.this.menuAction.setEnabled(((AgentLockService)Console.getConsole().getAgentService(AgentLockService.class)).getMaxLevel(newUserId, "lockmanager") >= 1));
            }
        });
        this.menuAction.setEnabled(((AgentLockService)Console.getConsole().getAgentService(AgentLockService.class)).getMaxLevel(loginServ.getUserId(), "lockmanager") >= 1);
        plugin.getServices().addMenu(this.menuAction, "400: CCS Tools :-1:5", "Command and Lock Browser:10");
    }

    private class GUI
    extends JDialog {
        JComboBox userOrGroupBox;
        BoxedFormattedTextField nameField;
        JLabel userStatusLabel;
        JButton deleteButton;
        JTextField settingsField;
        Box tablePanel;
        List<SettingsEntry> entries;
        Box groupsPanel;
        List<JCheckBox> groupBoxes;
        JButton saveConfigButton;
        JButton resetButton;
        JButton closeButton;
        JButton submitButton;
        final AgentStatusListener statusListener;
        String currentUser;
        String currentSettings;

        GUI() {
            super(Console.getConsole().getWindow(), "Manage authorized users", Dialog.ModalityType.APPLICATION_MODAL);
            this.tablePanel = Box.createHorizontalBox();
            this.entries = new LinkedList<SettingsEntry>();
            this.groupsPanel = Box.createVerticalBox();
            this.groupBoxes = new ArrayList<JCheckBox>();
            this.setDefaultCloseOperation(2);
            this.entries.add(new SettingsEntry("", ""));
            Box root = Box.createVerticalBox();
            root.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.add(root);
            Box line = Box.createHorizontalBox();
            this.userOrGroupBox = new BoxedComboBox<String>(new String[]{"User", "Group"});
            this.userOrGroupBox.addActionListener(e -> {
                this.nameField.setText("");
                this.onUserSelection("");
            });
            line.add(this.userOrGroupBox);
            line.add(Box.createRigidArea(Const.HDIM));
            this.nameField = new BoxedFormattedTextField();
            this.nameField.setFilter("[-a-zA-Z_0-9]*");
            final JPopupMenu popupMenu = new JPopupMenu();
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                private void updatePopup() {
                    String input = GUI.this.nameField.getText().toLowerCase();
                    popupMenu.setVisible(false);
                    popupMenu.removeAll();
                    List<String> choices = GUI.this.userCandidates(input);
                    if (!choices.isEmpty()) {
                        for (String choice : choices) {
                            JMenuItem item = new JMenuItem(choice);
                            item.addActionListener(ev -> {
                                GUI.this.nameField.setText(choice);
                                popupMenu.setVisible(false);
                            });
                            popupMenu.add(item);
                        }
                        if (popupMenu.getComponentCount() > 0) {
                            popupMenu.show(GUI.this.nameField, 0, GUI.this.nameField.getHeight());
                            GUI.this.nameField.requestFocusInWindow();
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updatePopup();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updatePopup();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.nameField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!popupMenu.isVisible()) {
                        GUI.this.nameField.getText();
                        String user = GUI.this.nameField.getText().strip();
                        if (!user.equals(GUI.this.currentUser)) {
                            GUI.this.onUserSelection(user);
                        }
                    }
                }
            });
            this.nameField.addActionListener(e -> this.onUserSelection(this.nameField.getText()));
            line.add(this.nameField);
            line.add(Box.createRigidArea(Const.HDIM));
            this.userStatusLabel = new JLabel("      ");
            line.add(this.userStatusLabel);
            line.add(Box.createRigidArea(Const.HDIM));
            this.deleteButton = new JButton("Delete");
            this.deleteButton.addActionListener(e -> {
                this.settingsField.setText("");
                this.updateFromSettings();
                this.submit();
            });
            line.add(this.deleteButton);
            line.add(Box.createHorizontalGlue());
            root.add(line);
            this.settingsField = new BoxedTextField(80);
            this.settingsField.addActionListener(e -> this.updateFromSettings());
            this.settingsField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    String settings = GUI.this.settingsField.getText().strip();
                    if (!settings.equals(GUI.this.currentSettings)) {
                        GUI.this.updateFromSettings();
                    }
                }
            });
            root.add(this.settingsField);
            line = Box.createHorizontalBox();
            this.populateTablePanel();
            this.tablePanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            line.add(new JScrollPane(this.tablePanel));
            line.add(Box.createRigidArea(Const.HDIM));
            this.updateGroupsPanel();
            this.groupsPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            line.add(new JScrollPane(this.groupsPanel));
            root.add(line);
            line = Box.createHorizontalBox();
            this.saveConfigButton = new JButton("Save Configuration");
            this.saveConfigButton.setToolTipText("Tell lock manager to permanently save current configuration");
            this.saveConfigButton.setEnabled(Console.getConsole().getStatusAggregator().getAgentState("lockmanager").isInState((Enum)ConfigurationState.DIRTY));
            this.saveConfigButton.addActionListener(e -> CommandService.getService().send("lockmanager saveCategories -w General"));
            line.add(this.saveConfigButton);
            line.add(Box.createHorizontalGlue());
            line.add(Box.createRigidArea(Const.HDIM));
            this.resetButton = new JButton("Reset");
            this.resetButton.setToolTipText("Discard unsubmitted changes for the current user.");
            this.resetButton.addActionListener(e -> this.onUserSelection(this.nameField.getText()));
            line.add(this.resetButton);
            line.add(Box.createRigidArea(Const.HDIM));
            this.closeButton = new JButton("Close");
            this.closeButton.setToolTipText("Close user manager");
            this.closeButton.addActionListener(e -> this.dispose());
            line.add(this.closeButton);
            line.add(Box.createRigidArea(Const.HDIM));
            this.submitButton = new JButton("Submit");
            this.submitButton.setToolTipText("Submit changes for the current user to lock manager");
            this.submitButton.addActionListener(e -> this.submit());
            line.add(this.submitButton);
            root.add(line);
            final String statePath = "lockmanager/states/ConfigurationState";
            final String configPath = "lockmanager/configuration/maxLevelMap";
            this.statusListener = new AgentStatusListener(){

                @Override
                public void statusChanged(AgentStatusEvent e) {
                    if (e.getAgentNames().contains("lockmanager")) {
                        for (AgentChannel ch : e.getStatusChanges().keySet()) {
                            String p = ch.getPath();
                            if (p.equals(statePath)) {
                                SwingUtilities.invokeLater(() -> GUI.this.saveConfigButton.setEnabled(ConfigurationState.DIRTY.name().equals(ch.get())));
                                continue;
                            }
                            if (!p.equals(configPath)) continue;
                            ConfigurationParameterInfo par = (ConfigurationParameterInfo)ch.get();
                            try {
                                Map updated = (Map)par.getCurrentValueObject();
                                SwingUtilities.invokeLater(() -> {
                                    UserManager.this.config = updated;
                                    GUI.this.updateGroupsPanel();
                                    String user = GUI.this.nameField.getText().strip();
                                    GUI.this.onUserSelection(user);
                                });
                            }
                            catch (RuntimeException x) {
                                Console.getConsole().getLogger().warn((Object)"Error updating User Manager", (Throwable)x);
                            }
                        }
                    }
                }
            };
            Console.getConsole().getStatusAggregator().addListener(this.statusListener, Collections.singletonList("lockmanager"), List.of(statePath, configPath));
        }

        @Override
        public void dispose() {
            Console.getConsole().getStatusAggregator().removeListener(this.statusListener);
            super.dispose();
        }

        private void updateGroupsPanel() {
            TreeSet<String> groups = new TreeSet<String>();
            if (UserManager.this.config != null) {
                for (String k : UserManager.this.config.keySet()) {
                    if (!k.startsWith("@")) continue;
                    groups.add(k.substring(1));
                }
            }
            this.groupBoxes.clear();
            groups.forEach(g -> {
                JCheckBox cb = new JCheckBox((String)g);
                cb.addActionListener(e -> this.updateToSettings());
                this.groupBoxes.add(cb);
            });
            this.groupsPanel.removeAll();
            this.groupsPanel.add(new JLabel("<html><b>Groups"));
            this.groupsPanel.add(Box.createRigidArea(Const.VDIM));
            this.groupBoxes.forEach(cb -> {
                this.groupsPanel.add((Component)cb);
                this.groupsPanel.add(Box.createRigidArea(Const.VDIM));
            });
        }

        private void populateTablePanel() {
            this.tablePanel.removeAll();
            Box agentsBox = Box.createVerticalBox();
            agentsBox.add(new JLabel("<html><b>Subsystem"));
            agentsBox.add(Box.createRigidArea(Const.VDIM));
            this.tablePanel.add(agentsBox);
            this.tablePanel.add(Box.createRigidArea(Const.HDIM));
            Box levelsBox = Box.createVerticalBox();
            levelsBox.add(new JLabel("<html><b>Maximum level"));
            levelsBox.add(Box.createRigidArea(Const.VDIM));
            this.tablePanel.add(levelsBox);
            for (SettingsEntry e : this.entries) {
                agentsBox.add(e.agentField);
                levelsBox.add(e.levelField);
            }
            agentsBox.add(Box.createVerticalGlue());
            levelsBox.add(Box.createVerticalGlue());
            this.tablePanel.revalidate();
            this.tablePanel.repaint();
        }

        private boolean updateFromSettings() {
            String s;
            this.currentSettings = s = this.settingsField.getText().strip();
            try {
                LinkedHashMap m = AgentLockService.User.levelsFromString((String)s);
                this.entries.clear();
                m.forEach((k, v) -> {
                    if (!v.isBlank()) {
                        this.entries.add(new SettingsEntry((String)k, (String)v));
                    }
                });
                this.entries.add(new SettingsEntry("", ""));
                this.populateTablePanel();
                this.groupBoxes.forEach(b -> b.setSelected(m.getOrDefault(b.getText(), "x").isBlank()));
                this.settingsField.setForeground(null);
                return true;
            }
            catch (IllegalArgumentException x) {
                this.settingsField.setForeground(Color.RED);
                return false;
            }
        }

        private boolean updateToSettings() {
            boolean out = true;
            int empty = 0;
            int invalid = 0;
            TreeMap<String, String> m = new TreeMap<String, String>();
            for (SettingsEntry e : this.entries) {
                if (e.isEmpty()) {
                    ++empty;
                    continue;
                }
                if (!e.isValid()) {
                    ++invalid;
                    out = false;
                    continue;
                }
                m.put(e.getAgent(), e.getLevel());
            }
            if (empty == 0 && invalid == 0) {
                this.entries.add(new SettingsEntry("", ""));
                this.populateTablePanel();
            } else if (empty > 1) {
                Iterator<SettingsEntry> it = this.entries.iterator();
                while (it.hasNext() && empty > 1) {
                    if (!it.next().isEmpty()) continue;
                    it.remove();
                    --empty;
                }
                this.populateTablePanel();
            }
            this.groupBoxes.forEach(b -> {
                if (b.isSelected()) {
                    m.put(b.getText(), "");
                }
            });
            if (out) {
                String s = AgentLockService.User.levelsToString(m, (boolean)false);
                this.settingsField.setText(s);
                this.settingsField.setForeground(null);
            }
            return out;
        }

        private void onUserSelection(String user) {
            Map<String, String> m;
            this.currentUser = user;
            if (this.isGroup()) {
                user = "@" + (String)user;
            }
            if ((m = UserManager.this.config.get(user)) == null) {
                this.userStatusLabel.setText("New");
                this.deleteButton.setEnabled(false);
                this.settingsField.setText("");
            } else {
                this.userStatusLabel.setText("   ");
                this.deleteButton.setEnabled(true);
                this.settingsField.setText(AgentLockService.User.levelsToString(m, (boolean)false));
            }
            this.updateFromSettings();
        }

        private void submit() {
            Object user = this.nameField.getText().strip();
            if (this.isGroup()) {
                user = "@" + (String)user;
            }
            try {
                LinkedHashMap settings = AgentLockService.User.levelsFromString((String)this.settingsField.getText());
                Map old = UserManager.this.config.getOrDefault(user, Collections.emptyMap());
                if (!settings.equals(old)) {
                    TreeMap<String, Map<String, String>> updated = new TreeMap<String, Map<String, String>>(UserManager.this.config);
                    if (settings.isEmpty()) {
                        updated.remove(user);
                    } else {
                        updated.put((String)user, settings);
                    }
                    CommandService.getService().sendRaw("lockmanager", "change", "/", "maxLevelMap", updated, new Options().withOption("withLock"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private boolean isGroup() {
            return this.userOrGroupBox.getSelectedIndex() == 1;
        }

        private List<String> userCandidates(String input) {
            if (UserManager.this.config == null || ((String)input).isBlank()) {
                return Collections.emptyList();
            }
            input = ((String)input).strip();
            int maxCandidates = 10;
            ArrayList<String> out = new ArrayList<String>(maxCandidates);
            int n = 0;
            if (this.isGroup()) {
                input = "@" + (String)input;
            }
            for (String key : UserManager.this.config.keySet()) {
                if (!key.startsWith((String)input)) continue;
                if (this.isGroup()) {
                    key = key.substring(1);
                }
                out.add(key);
                if (++n <= maxCandidates) continue;
                break;
            }
            return out;
        }

        private class SettingsEntry {
            static final Command.Level levelParser = new Command.Level().with((Enum)Command.Level.OnTooHigh.ON_TOO_HIGH_DEFAULT).withDefault(-1);
            final BoxedFormattedTextField agentField = new BoxedFormattedTextField();
            final BoxedFormattedTextField levelField;

            SettingsEntry(String key, String value) {
                this.agentField.setFilter("[-a-zA-Z_0-9*]*");
                this.agentField.setText(key.strip());
                this.levelField = new BoxedFormattedTextField();
                this.levelField.setFilter("[_0-9ENGIROUTADVCDXPMLengiroutadvcdxpml]*");
                value = value.strip();
                if (!value.isEmpty()) {
                    try {
                        int i = Integer.parseInt(value);
                        if (i > 99) {
                            value = Integer.toString(99);
                        }
                    }
                    catch (NumberFormatException x) {
                        value = value.toUpperCase();
                    }
                }
                this.levelField.setText(value);
                this.agentField.addActionListener(e -> GUI.this.updateToSettings());
                this.agentField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        GUI.this.updateToSettings();
                    }
                });
                this.levelField.addActionListener(e -> GUI.this.updateToSettings());
                this.levelField.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        GUI.this.updateToSettings();
                    }
                });
                this.levelField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        SettingsEntry.this.getLevel();
                    }
                });
            }

            String getAgent() {
                return this.agentField.getText().strip();
            }

            String getLevel() {
                String s = this.levelField.getText().strip().toUpperCase();
                int level = levelParser.getValue(s);
                if (level == -1) {
                    this.levelField.setForeground(Color.red);
                    return "";
                }
                this.levelField.setForeground(null);
                return s;
            }

            boolean isValid() {
                String agent = this.getAgent();
                String level = this.getLevel();
                return !agent.isBlank() && !level.isBlank() && agent.length() >= 1 && agent.length() <= 80;
            }

            boolean isEmpty() {
                return this.agentField.getText().isBlank() && this.levelField.getText().isBlank();
            }
        }
    }
}

