/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.localdb.statusdb.model.AlertData;
import org.lsst.ccs.localdb.statusdb.model.ClearedAlertData;

@Entity
@Table(indexes={@Index(columnList="time")})
public class RaisedAlertData
extends AlertData {
    private static final long serialVersionUID = -9007475175629577314L;
    private static final int CAUSE_lENGTH = 255;
    protected AlertState severity;
    private ClearedAlertData clearingAlert;
    private Boolean active = true;
    protected String alertCause;

    public RaisedAlertData() {
    }

    public RaisedAlertData(AlertState severity, String alertCause, long timestamp) {
        this.severity = severity;
        this.setAlertCause(alertCause);
        this.time = timestamp;
    }

    public void setSeverity(AlertState alertState) {
        this.severity = alertState;
    }

    @Enumerated(value=EnumType.STRING)
    public AlertState getSeverity() {
        return this.severity;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Column(length=255)
    public String getAlertCause() {
        return this.alertCause;
    }

    public void setAlertCause(String alertCause) {
        if (alertCause != null && alertCause.length() > 255) {
            alertCause = alertCause.substring(0, 255);
        }
        this.alertCause = alertCause;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    public ClearedAlertData getClearingAlert() {
        return this.clearingAlert;
    }

    public void setClearingAlert(ClearedAlertData clearingAlert) {
        this.clearingAlert = clearingAlert;
    }
}

