/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.dataformat.avro.AvroAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.avro.AvroSerializerModifier;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.deser.AvroUntypedDeserializer;
import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;

public class AvroModule
extends Module {
    protected static final AvroAnnotationIntrospector INTR = new AvroAnnotationIntrospector();
    protected AnnotationIntrospector _intr = INTR;

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public AvroModule withAnnotationIntrospector(AnnotationIntrospector intr) {
        this._intr = intr;
        return this;
    }

    public void setupModule(Module.SetupContext context) {
        this._addIntrospector(context);
        this._addModifiers(context);
        this._addDeserializers(context);
        this._addSerializers(context);
    }

    protected void _addIntrospector(Module.SetupContext context) {
        if (this._intr != null) {
            context.insertAnnotationIntrospector(this._intr);
        }
    }

    protected void _addModifiers(Module.SetupContext context) {
        context.addBeanSerializerModifier((BeanSerializerModifier)new AvroSerializerModifier());
    }

    protected void _addDeserializers(Module.SetupContext context) {
        SimpleDeserializers desers = new SimpleDeserializers();
        desers.addDeserializer(Object.class, (JsonDeserializer)new AvroUntypedDeserializer());
        context.addDeserializers((Deserializers)desers);
    }

    protected void _addSerializers(Module.SetupContext context) {
        SimpleSerializers sers = new SimpleSerializers();
        sers.addSerializer((JsonSerializer)new SchemaSerializer());
        sers.addSerializer(File.class, (JsonSerializer)new ToStringSerializer(File.class));
        context.addSerializers((Serializers)sers);
    }

    public static class SchemaSerializer
    extends StdSerializer<Schema> {
        private static final long serialVersionUID = 1L;

        public SchemaSerializer() {
            super(Schema.class);
        }

        public void serialize(Schema value, JsonGenerator gen, SerializerProvider prov) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

