/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.fitter;

import hep.aida.IFitParameterSettings;

public class FitParameterSettings
implements IFitParameterSettings {
    private String name;
    private double stepSize = Double.NaN;
    private double upperBound;
    private double lowerBound;
    private boolean isFixed;
    private final boolean isFixedDef = false;
    private final double upperBoundDef = Double.POSITIVE_INFINITY;
    private final double lowerBoundDef = Double.NEGATIVE_INFINITY;

    public FitParameterSettings(String name) {
        this.name = name;
        this.reset();
    }

    public String name() {
        return this.name;
    }

    public double stepSize() {
        return this.stepSize;
    }

    public double upperBound() {
        return this.upperBound;
    }

    public double lowerBound() {
        return this.lowerBound;
    }

    public boolean isBound() {
        return this.upperBound != Double.POSITIVE_INFINITY || this.lowerBound != Double.NEGATIVE_INFINITY;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setStepSize(double step) {
        if (!(step > 0.0)) {
            throw new IllegalArgumentException("Illegal step size " + step + " it has to be positive!");
        }
        this.stepSize = step;
    }

    public void setBounds(double lo, double up) {
        if (up < lo) {
            throw new IllegalArgumentException("Lower bound cannot be less than upper bound : " + lo + " > " + up);
        }
        this.upperBound = up;
        this.lowerBound = lo;
    }

    public void removeBounds() {
        this.upperBound = Double.POSITIVE_INFINITY;
        this.lowerBound = Double.NEGATIVE_INFINITY;
    }

    public void setFixed(boolean isFixed) {
        this.isFixed = isFixed;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void reset() {
        this.stepSize = Double.NaN;
        this.setFixed(false);
        this.setBounds(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }
}

