/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.CharacterUtils;
import com.wittams.gritty.Tty;
import java.awt.Dimension;
import java.io.IOException;

public class TtyChannel {
    private Tty tty;
    byte[] buf = new byte[1024];
    int offset = 0;
    int length = 0;
    int serial;

    public TtyChannel(Tty tty) {
        this.tty = tty;
        this.serial = 0;
    }

    public byte getChar() throws IOException {
        if (this.length == 0) {
            this.fillBuf();
        }
        --this.length;
        return this.buf[this.offset++];
    }

    public void appendBuf(StringBuffer sb, int begin, int length) {
        CharacterUtils.appendBuf(sb, this.buf, begin, length);
    }

    private void fillBuf() throws IOException {
        this.offset = 0;
        this.length = 0;
        this.length = this.tty.read(this.buf, this.offset, this.buf.length - this.offset);
        ++this.serial;
        if (this.length <= 0) {
            this.length = 0;
            throw new IOException("fillBuf");
        }
    }

    public void pushChar(byte b) throws IOException {
        if (this.offset == 0) {
            this.offset = this.buf.length - this.length;
            System.arraycopy(this.buf, 0, this.buf, this.offset, this.length);
        }
        ++this.length;
        this.buf[--this.offset] = b;
    }

    int advanceThroughASCII(int toLineEnd) throws IOException {
        int len;
        if (this.length == 0) {
            this.fillBuf();
        }
        int origLen = len = toLineEnd > this.length ? this.length : toLineEnd;
        while (len > 0) {
            byte tmp;
            if (32 <= (tmp = this.buf[this.offset++]) && tmp <= 127) {
                --this.length;
                --len;
                continue;
            }
            --this.offset;
            break;
        }
        return origLen - len;
    }

    public void sendBytes(byte[] bytes) throws IOException {
        this.tty.write(bytes);
    }

    public void postResize(Dimension termSize, Dimension pixelSize) {
        this.tty.resize(termSize, pixelSize);
    }

    public void pushBackBuffer(byte[] bytes, int len) throws IOException {
        for (int i = len - 1; i >= 0; --i) {
            this.pushChar(bytes[i]);
        }
    }
}

