/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.httpd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.astrogrid.samp.SampUtils;

public class HttpServer {
    private final ServerSocket serverSocket_;
    private boolean isDaemon_;
    private List handlerList_;
    private final URL baseUrl_;
    private volatile boolean started_;
    private volatile boolean stopped_;
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    private static final String HDR_CONTENT_LENGTH = "Content-Length";
    public static final int STATUS_OK = 200;
    private static final String URI_REGEX = "([^\\s\\?]*)\\??([^\\s\\?]*)";
    private static final String HTTP_VERSION_REGEX = "HTTP/[0-9]+\\.[0-9]+";
    private static final String HTTP_TOKEN_REGEX = "[a-zA-Z0-9_\\.\\-]+";
    private static final Pattern SIMPLE_REQUEST_PATTERN;
    private static final Pattern REQUEST_LINE_PATTERN;
    private static final Pattern HEADER_PATTERN;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HttpServer(ServerSocket socket) {
        this.serverSocket_ = socket;
        this.isDaemon_ = true;
        this.handlerList_ = Collections.synchronizedList(new ArrayList());
        StringBuffer ubuf = new StringBuffer().append("http://").append(SampUtils.getLocalhost());
        int port = socket.getLocalPort();
        if (port != 80) {
            ubuf.append(':').append(port);
        }
        try {
            this.baseUrl_ = new URL(ubuf.toString());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)"Bad scheme http:??");
        }
    }

    public HttpServer() throws IOException {
        this(new ServerSocket(0));
    }

    public void addHandler(Handler handler) {
        this.handlerList_.add(handler);
    }

    public void removeHandler(Handler handler) {
        this.handlerList_.remove(handler);
    }

    public ServerSocket getSocket() {
        return this.serverSocket_;
    }

    public URL getBaseUrl() {
        return this.baseUrl_;
    }

    public Response serve(Request request) {
        Handler[] handlers = this.handlerList_.toArray(new Handler[0]);
        for (int ih = 0; ih < handlers.length; ++ih) {
            Handler handler = handlers[ih];
            Response response = handler.serveRequest(request);
            if (response == null) continue;
            return response;
        }
        return HttpServer.createErrorResponse(404, "No handler for URL");
    }

    public void setDaemon(boolean isDaemon) {
        this.isDaemon_ = isDaemon;
    }

    public synchronized void start() {
        if (!this.started_) {
            Thread server = new Thread("HTTP Server"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        while (!HttpServer.this.stopped_) {
                            try {
                                final Socket sock = HttpServer.this.serverSocket_.accept();
                                new Thread("HTTP Request"){

                                    public void run() {
                                        try {
                                            HttpServer.this.serveRequest(sock);
                                        }
                                        catch (Throwable e) {
                                            logger_.log(Level.WARNING, "Httpd error", e);
                                        }
                                    }
                                }.start();
                            }
                            catch (IOException e) {
                                if (HttpServer.this.stopped_) continue;
                                logger_.log(Level.WARNING, "Socket error", e);
                            }
                        }
                    }
                    finally {
                        HttpServer.this.stop();
                    }
                }
            };
            server.setDaemon(this.isDaemon_);
            logger_.info("Server " + this.getBaseUrl() + " starting");
            server.start();
            this.started_ = true;
            logger_.config("Server " + this.getBaseUrl() + " started");
        }
    }

    public synchronized void stop() {
        if (!this.stopped_) {
            this.stopped_ = true;
            logger_.info("Server " + this.getBaseUrl() + " stopping");
            try {
                this.serverSocket_.close();
            }
            catch (IOException e) {
                logger_.log(Level.WARNING, "Error during server stop: " + e, e);
            }
        }
    }

    public boolean isRunning() {
        return this.started_ && !this.stopped_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serveRequest(Socket sock) throws IOException {
        Level level;
        InputStream in = sock.getInputStream();
        in = new BufferedInputStream(in);
        Response response = null;
        Request request = null;
        try {
            request = HttpServer.parseRequest(in, sock.getRemoteSocketAddress());
            if (request == null) {
                return;
            }
        }
        catch (HttpException e) {
            response = e.createResponse();
        }
        catch (IOException e) {
            response = HttpServer.createErrorResponse(400, "I/O error", e);
        }
        catch (Throwable e) {
            response = HttpServer.createErrorResponse(500, "Server error", e);
        }
        if (response == null) {
            if (!$assertionsDisabled && request == null) {
                throw new AssertionError();
            }
            try {
                response = this.serve(request);
            }
            catch (Throwable e) {
                response = HttpServer.createErrorResponse(500, e.toString(), e);
            }
        }
        Level level2 = level = response.getStatusCode() == 200 ? Level.CONFIG : Level.WARNING;
        if (logger_.isLoggable(level)) {
            StringBuffer sbuf = new StringBuffer();
            if (request != null) {
                sbuf.append(request.getMethod()).append(' ').append(request.getUrl());
            } else {
                sbuf.append("<bad-request>");
            }
            sbuf.append(" --> ").append(response.statusCode_).append(' ').append(response.statusPhrase_);
            logger_.log(level, sbuf.toString());
        }
        BufferedOutputStream bos = new BufferedOutputStream(sock.getOutputStream());
        try {
            response.writeResponse(bos);
            bos.flush();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {}
        }
    }

    private static Request parseRequest(InputStream in, SocketAddress remoteAddress) throws IOException {
        String[] hdrLines = HttpServer.readHeaderLines(in);
        if (hdrLines == null) {
            return null;
        }
        if (hdrLines.length == 0) {
            throw new HttpException(400, "Empty request");
        }
        Matcher simpleMatcher = SIMPLE_REQUEST_PATTERN.matcher(hdrLines[0]);
        if (simpleMatcher.matches()) {
            return new Request("GET", simpleMatcher.group(1), new HashMap(), remoteAddress, null);
        }
        Matcher fullMatcher = REQUEST_LINE_PATTERN.matcher(hdrLines[0]);
        if (fullMatcher.matches()) {
            byte[] body;
            String method = fullMatcher.group(1);
            String uri = fullMatcher.group(2);
            HttpHeaderMap headerMap = new HttpHeaderMap();
            boolean headerEnd = false;
            int contentLength = 0;
            for (int iLine = 1; iLine < hdrLines.length; ++iLine) {
                String line = hdrLines[iLine];
                Matcher headerMatcher = HEADER_PATTERN.matcher(line);
                if (!headerMatcher.matches()) continue;
                String key = headerMatcher.group(1);
                String value = headerMatcher.group(2);
                boolean cont = true;
                while (iLine + 1 < hdrLines.length && cont) {
                    char c1;
                    cont = false;
                    String line1 = hdrLines[iLine + 1];
                    if (line1.length() <= 0 || (c1 = line1.charAt(0)) != ' ' && c1 != '\t') continue;
                    value = value + line1.trim();
                    ++iLine;
                    cont = true;
                }
                headerMap.addHeader(key, value);
                if (!key.equalsIgnoreCase(HDR_CONTENT_LENGTH)) continue;
                try {
                    contentLength = Integer.parseInt(value.trim());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new HttpException(400, "Failed to parse " + key + " header " + value);
                }
            }
            if (contentLength > 0) {
                int ib;
                int nb;
                body = new byte[contentLength];
                for (ib = 0; ib < contentLength; ib += nb) {
                    nb = in.read(body, ib, contentLength - ib);
                    if (nb >= 0) continue;
                    throw new HttpException(500, "Insufficient bytes for declared Content-Length: " + ib + "<" + contentLength);
                }
                if (!$assertionsDisabled && ib != contentLength) {
                    throw new AssertionError();
                }
            } else {
                body = null;
            }
            if ((uri = SampUtils.uriDecode(uri)).startsWith("http://")) {
                try {
                    URL url = new URL(uri);
                    String path = url.getPath();
                    String query = url.getQuery();
                    if (query != null) {
                        path = path + '?' + query;
                    }
                    uri = path;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            return new Request(method, uri, headerMap, remoteAddress, body);
        }
        throw new HttpException(400, "Bad request");
    }

    private static String[] readHeaderLines(InputStream is) throws IOException {
        String line;
        int c;
        ArrayList<String> lineList = new ArrayList<String>();
        StringBuffer sbuf = new StringBuffer();
        boolean hasChars = false;
        block4: while ((c = is.read()) >= 0) {
            hasChars = true;
            switch (c) {
                case 13: {
                    if (is.read() == 10) {
                        if (sbuf.length() == 0) {
                            return lineList.toArray(new String[0]);
                        }
                        lineList.add(sbuf.toString());
                        sbuf.setLength(0);
                        continue block4;
                    }
                    throw new HttpException(400, "CR w/o LF");
                }
                case 10: {
                    if (sbuf.length() == 0) {
                        return lineList.toArray(new String[0]);
                    }
                    lineList.add(sbuf.toString());
                    sbuf.setLength(0);
                    continue block4;
                }
            }
            sbuf.append((char)c);
        }
        if (!hasChars) {
            return null;
        }
        if (lineList.size() == 1 && SIMPLE_REQUEST_PATTERN.matcher(line = (String)lineList.get(0)).matches()) {
            return new String[]{line};
        }
        throw new HttpException(500, "No CRLF line");
    }

    public static String getHeader(Map headerMap, String key) {
        ArrayList valueList = new ArrayList();
        Iterator it = headerMap.entrySet().iterator();
        while (it.hasNext()) {
            Object value;
            Map.Entry entry = it.next();
            if (!((String)entry.getKey()).equalsIgnoreCase(key) || !((value = entry.getValue()) instanceof String)) continue;
            valueList.add(value);
        }
        int nval = valueList.size();
        if (nval == 0) {
            return null;
        }
        if (nval == 1) {
            return (String)valueList.get(0);
        }
        StringBuffer sbuf = new StringBuffer();
        Iterator vit = valueList.iterator();
        while (vit.hasNext()) {
            sbuf.append((String)vit.next());
            if (!vit.hasNext()) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    public static Response createErrorResponse(int code, String phrase) {
        return new Response(code, phrase, new HashMap()){

            public void writeBody(OutputStream out) {
            }
        };
    }

    public static Response create405Response(String[] supportedMethods) {
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        StringBuffer mlist = new StringBuffer();
        for (int i = 0; i < supportedMethods.length; ++i) {
            if (i > 0) {
                mlist.append(", ");
            }
            mlist.append(supportedMethods[i]);
        }
        hdrMap.put("Allow", mlist.toString());
        hdrMap.put(HDR_CONTENT_LENGTH, "0");
        return new Response(405, "Method not allowed", hdrMap){

            public void writeBody(OutputStream out) {
            }
        };
    }

    public static Response createErrorResponse(int code, String phrase, final Throwable e) {
        LinkedHashMap<String, String> hdrMap = new LinkedHashMap<String, String>();
        hdrMap.put(HDR_CONTENT_TYPE, "text/plain");
        return new Response(code, phrase, hdrMap){

            public void writeBody(OutputStream out) {
                PrintStream pout = new PrintStream(out);
                e.printStackTrace(pout);
                pout.flush();
            }
        };
    }

    static {
        $assertionsDisabled = !HttpServer.class.desiredAssertionStatus();
        SIMPLE_REQUEST_PATTERN = Pattern.compile("GET (\\S+)");
        REQUEST_LINE_PATTERN = Pattern.compile("([a-zA-Z0-9_\\.\\-]+) (\\S+) HTTP/[0-9]+\\.[0-9]+");
        HEADER_PATTERN = Pattern.compile("([^\\s:]+):\\s*(.*)");
        logger_ = Logger.getLogger(HttpServer.class.getName());
    }

    public static interface Handler {
        public Response serveRequest(Request var1);
    }

    static class HttpHeaderMap
    extends LinkedHashMap {
        HttpHeaderMap() {
        }

        public void addHeader(String key, String value) {
            boolean added = false;
            Iterator it = this.entrySet().iterator();
            while (it.hasNext() && !added) {
                Map.Entry entry = it.next();
                if (!((String)entry.getKey()).equalsIgnoreCase(key)) continue;
                entry.setValue(entry.getValue() + ", " + value);
                added = true;
            }
            if (!added) {
                this.put(key, value);
            }
        }
    }

    private static class HttpException
    extends IOException {
        private final int code_;
        private final String phrase_;

        HttpException(int code, String phrase) {
            this.code_ = code;
            this.phrase_ = phrase;
        }

        Response createResponse() {
            return HttpServer.createErrorResponse(this.code_, this.phrase_);
        }
    }

    public static abstract class Response {
        private final int statusCode_;
        private final String statusPhrase_;
        private final Map headerMap_;

        public Response(int statusCode, String statusPhrase, Map headerMap) {
            if (Integer.toString(statusCode).length() != 3) {
                throw new IllegalArgumentException("Bad status " + statusCode);
            }
            this.statusCode_ = statusCode;
            this.statusPhrase_ = statusPhrase;
            this.headerMap_ = headerMap;
        }

        public int getStatusCode() {
            return this.statusCode_;
        }

        public String getStatusPhrase() {
            return this.statusPhrase_;
        }

        public Map getHeaderMap() {
            return this.headerMap_;
        }

        public abstract void writeBody(OutputStream var1) throws IOException;

        public void writeResponse(OutputStream out) throws IOException {
            String statusLine = "HTTP/1.0" + ' ' + this.getStatusCode() + ' ' + this.getStatusPhrase() + '\r' + '\n';
            out.write(statusLine.getBytes("UTF-8"));
            if (this.headerMap_ != null) {
                StringBuffer sbuf = new StringBuffer();
                Iterator it = this.getHeaderMap().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    sbuf.setLength(0);
                    String line = sbuf.append(entry.getKey()).append(':').append(' ').append(entry.getValue()).append('\r').append('\n').toString();
                    out.write(line.getBytes("UTF-8"));
                }
            }
            out.write(13);
            out.write(10);
            this.writeBody(out);
        }
    }

    public static class Request {
        private final String method_;
        private final String url_;
        private final Map headerMap_;
        private final SocketAddress remoteAddress_;
        private final byte[] body_;

        public Request(String method, String url, Map headerMap, SocketAddress remoteAddress, byte[] body) {
            this.method_ = method;
            this.url_ = url;
            this.headerMap_ = headerMap;
            this.remoteAddress_ = remoteAddress;
            this.body_ = body;
        }

        public String getMethod() {
            return this.method_;
        }

        public String getUrl() {
            return this.url_;
        }

        public Map getHeaderMap() {
            return this.headerMap_;
        }

        public SocketAddress getRemoteAddress() {
            return this.remoteAddress_;
        }

        public byte[] getBody() {
            return this.body_;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer().append(this.method_).append(' ').append(this.url_);
            if (this.headerMap_ != null && !this.headerMap_.isEmpty()) {
                sbuf.append("\n    ").append(this.headerMap_);
            }
            if (this.body_ != null && this.body_.length > 0) {
                sbuf.append("\n    ").append("body[").append(this.body_.length).append(']');
            }
            return sbuf.toString();
        }
    }
}

