/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.sal.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.camera.sal.xml.util.SerializationUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Main {
    @Argument(required=true, usage="Input (.ser) File")
    private File file;
    @Option(name="-level", aliases={"-l"}, usage="Conversion level")
    private int level;
    @Option(name="-verbose", aliases={"-v"}, usage="Turn on verbose output")
    private boolean verbose;
    @Option(name="-csc", aliases={"-c"}, usage="CSC name (e.g. CCCamera, MTCamera, ATCamera)")
    private String cscName;
    @Option(name="-map", aliases={"-m"}, usage="Use alternate mapping file")
    private File mappingFile;
    @Option(name="-output", aliases={"-o"}, usage="Output file name ")
    private String outputFileName;
    @Option(name="-settingsApplied", aliases={"-s"}, usage="Generate settingsApplied ")
    private boolean generateSettingsApplied;
    @Option(name="-options", aliases={"-f"}, usage="Fiole to read options from")
    private File optionsFile;
    private String subsystemName;
    private String componentName;

    public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException, ParserConfigurationException, TransformerException, SAXException, XPathExpressionException {
        new Main().doMain(args);
    }

    private void doMain(String[] args) throws IOException, FileNotFoundException, ClassNotFoundException, ParserConfigurationException, TransformerException, SAXException, XPathExpressionException {
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args);
            Mapping mapping = Main.createMapping(this.mappingFile);
            if (this.optionsFile != null) {
                int i;
                this.outputFileName = "/home/tonyj/projects/lsst/ocs-ccs/ts_xml/sal_interfaces/CCCamera/CCCamera_Telemetry.xml";
                this.cscName = "CCCamera";
                XMLMaker2 maker = new XMLMaker2(false);
                Document document = maker.createDocument(XMLMaker2.SALType.TELEMETRY);
                MakeXMLConfiguration xmlConf = MakeXMLConfiguration.getInstance(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-fcs"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("bonn-shutter"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-daq-monitor"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-rebpower"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-vacuum"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-quadbox"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-fp"), mapping);
                maker.writeXML(new StreamResult(new File(this.outputFileName)), document);
                System.out.println("Wrote " + this.outputFileName);
                String settingsApplideOutputFileName = "/home/tonyj/projects/lsst/ocs-ccs/ts_xml/sal_interfaces/CCCamera/CCCamera_Events.xml";
                Document settingsAppliedDocument = maker.createDocument(XMLMaker2.SALType.SETTINGS_APPLIED);
                xmlConf = MakeXMLConfiguration.getInstance(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-fcs"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("bonn-shutter"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-daq-monitor"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-rebpower"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-vacuum"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-quadbox"), mapping);
                maker.addXML(document, xmlConf.getDictionaryConfigurationForAgent("comcam-fp"), mapping);
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new File(settingsApplideOutputFileName));
                XPath xp = XPathFactory.newInstance().newXPath();
                NodeList nl = (NodeList)xp.evaluate("//text()[normalize-space(.)='']", doc, XPathConstants.NODESET);
                for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                    Node node = nl.item(i2);
                    node.getParentNode().removeChild(node);
                }
                Element root = doc.getDocumentElement();
                NodeList childNodes = root.getChildNodes();
                int startIndex = 0;
                int endIndex = 0;
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (!(node instanceof Comment)) continue;
                    Comment comment = (Comment)node;
                    if (comment.getData().trim().startsWith("SETTINGSAPPLIED")) {
                        startIndex = i;
                        continue;
                    }
                    if (!comment.getData().trim().startsWith("ENDSETTINGSAPPLIED")) continue;
                    endIndex = i;
                }
                for (i = startIndex + 1; i < endIndex; ++i) {
                    root.removeChild(childNodes.item(startIndex).getNextSibling());
                }
                Node nextSibling = childNodes.item(startIndex).getNextSibling();
                NodeList replacementNodes = settingsAppliedDocument.getDocumentElement().getChildNodes();
                for (int i3 = 0; i3 < replacementNodes.getLength(); ++i3) {
                    Node newNode = doc.importNode(replacementNodes.item(i3), true);
                    root.insertBefore(newNode, nextSibling);
                }
                maker.writeXML(new StreamResult(new File(settingsApplideOutputFileName)), doc);
                System.out.println("Wrote " + settingsApplideOutputFileName);
            } else {
                DataProviderDictionary dict = SerializationUtils.readDictionaryFromFile(this.file.getAbsolutePath());
                if (this.verbose) {
                    System.out.println(dict.getClass().getTypeName());
                }
                if (this.outputFileName == null) {
                    String inputFileName = this.file.getName();
                    this.outputFileName = inputFileName.endsWith(".ser") ? inputFileName.replace(".ser", ".xml") : inputFileName + ".xml";
                    if (this.generateSettingsApplied) {
                        this.outputFileName = this.outputFileName.replace(".xml", "SettingsApplied.xml");
                    }
                }
                XMLMaker2 maker = new XMLMaker2(this.verbose);
                this.computeSubsystemAndComponentNames(this.extractAgentNameFromDictionaryFile(this.file), this.cscName);
                MakeXMLConfiguration xmlConfig = MakeXMLConfiguration.getInstance(Camera.valueOf(this.cscName), this.generateSettingsApplied ? XMLMaker2.SALType.SETTINGS_APPLIED : XMLMaker2.SALType.TELEMETRY, this.subsystemName, dict);
                Document document = maker.makeXMLFromDictionary(xmlConfig.getDictionaryConfigurationForAgent(this.subsystemName), mapping);
                maker.writeXML(new StreamResult(new File(this.outputFileName)), document);
                System.out.println("Wrote " + this.outputFileName);
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java XMLMaker [options...] arguments...");
            parser.printUsage(System.err);
            System.err.println();
        }
    }

    private String extractAgentNameFromDictionaryFile(File f) {
        String fileName = f.getName();
        return fileName.replace("-status-dictionary.ser", "");
    }

    private void computeSubsystemAndComponentNames(String agentName, String cscName) {
        String subsystemAndComponent = agentName;
        this.subsystemName = "";
        this.componentName = "";
        if (cscName != null) {
            this.subsystemName = cscName;
            this.componentName = subsystemAndComponent;
        } else if (subsystemAndComponent.contains("comcam-")) {
            this.subsystemName = "CCCamera";
            this.componentName = subsystemAndComponent.replace("comcam-", "").trim();
        } else {
            this.subsystemName = "MTCamera";
            this.componentName = subsystemAndComponent;
        }
        if (this.verbose) {
            System.out.println(subsystemAndComponent);
            System.out.println(" Subsystem  Name " + this.subsystemName + " Component Name " + this.componentName);
        }
    }

    public static Mapping createMapping(File mappingFile) throws IOException {
        Mapping mapping;
        if (mappingFile == null) {
            mapping = Mapping.defaultMapping();
        } else {
            try (FileInputStream in = new FileInputStream(mappingFile);){
                mapping = new Mapping(in);
            }
        }
        return mapping;
    }
}

