/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.Binner1D;

public class BinnerMath {
    public static void add(Binner1D newBinner, Binner1D b1, Binner1D b2) throws IllegalArgumentException {
        BinnerMath.checkCompatibility(b1, b2);
        BinnerMath.checkCompatibility(newBinner, b2);
        for (int i = 0; i < b1.bins(); ++i) {
            int e = b1.entries(i) + b2.entries(i);
            double h = b1.height(i) + b2.height(i);
            double sumWW = b1.sumWW(i) + b2.sumWW(i);
            double sumXW = b1.sumXW(i) + b2.sumXW(i);
            double sumXXW = b1.sumXXW(i) + b2.sumXXW(i);
            double d = b1.binCenter(i) - b2.binCenter(i);
            if (d != 0.0) {
                sumXXW -= d * (2.0 * b2.sumXW(i) - d * b2.height(i));
                sumXW -= d * b2.height(i);
            }
            double ep = Math.sqrt(b1.plusError(i) * b1.plusError(i) + b2.plusError(i) * b2.plusError(i));
            double em = Math.sqrt(b1.minusError(i) * b1.plusError(i) + b2.minusError(i) * b2.plusError(i));
            newBinner.setBinContent(i, b1.binCenter(i), e, h, ep, em, sumWW, sumXW, sumXXW);
        }
    }

    public static void sub(Binner1D newBinner, Binner1D b1, Binner1D b2) throws IllegalArgumentException {
        BinnerMath.checkCompatibility(b1, b2);
        BinnerMath.checkCompatibility(newBinner, b2);
        for (int i = 0; i < b1.bins(); ++i) {
            int e = b1.entries(i) - b2.entries(i);
            double h = b1.height(i) - b2.height(i);
            double sumWW = b1.sumWW(i) + b2.sumWW(i);
            double sumXW = b1.sumXW(i) - b2.sumXW(i);
            double sumXXW = b1.sumXXW(i) - b2.sumXXW(i);
            double d = b1.binCenter(i) - b2.binCenter(i);
            if (d != 0.0) {
                sumXXW += d * (2.0 * b2.sumXW(i) - d * b2.height(i));
                sumXW += d * b2.height(i);
            }
            double ep = Math.sqrt(b1.plusError(i) * b1.plusError(i) + b2.plusError(i) * b2.plusError(i));
            double em = Math.sqrt(b1.minusError(i) * b1.plusError(i) + b2.minusError(i) * b2.plusError(i));
            newBinner.setBinContent(i, b1.binCenter(i), e, h, ep, em, sumWW, sumXW, sumXXW);
        }
    }

    public static void mul(Binner1D newBinner, Binner1D b1, Binner1D b2) throws IllegalArgumentException {
        BinnerMath.checkCompatibility(b1, b2);
        BinnerMath.checkCompatibility(newBinner, b2);
        for (int i = 0; i < b1.bins(); ++i) {
            int e = b1.entries(i);
            double h = b1.height(i) * b2.height(i);
            double sumXW = b1.sumXW(i) * b2.height(i);
            double sumXXW = b1.sumXXW(i) * b2.height(i);
            double sumWW = BinnerMath.sumWW_Mul(b1.height(i), b1.sumWW(i), b2.height(i), b2.sumWW(i));
            double ep = BinnerMath.errorMul(b1.plusError(i), b1.height(i), b2.plusError(i), b2.height(i));
            double em = BinnerMath.errorMul(b1.minusError(i), b1.height(i), b2.minusError(i), b2.height(i));
            newBinner.setBinContent(i, b1.binCenter(i), e, h, ep, em, sumWW, sumXW, sumXXW);
        }
    }

    public static void div(Binner1D newBinner, Binner1D b1, Binner1D b2) throws IllegalArgumentException {
        BinnerMath.checkCompatibility(b1, b2);
        BinnerMath.checkCompatibility(newBinner, b2);
        for (int i = 0; i < b1.bins(); ++i) {
            int e = b1.entries(i);
            double h = 0.0;
            double sumXW = b1.sumXW(i);
            double sumXXW = b1.sumXXW(i);
            double sumWW = Double.NaN;
            double ep = Double.NaN;
            double em = Double.NaN;
            if (b2.height(i) != 0.0) {
                h = b1.height(i) / b2.height(i);
                sumXW = b1.sumXW(i) / b2.height(i);
                sumXXW = b1.sumXXW(i) / b2.height(i);
                sumWW = BinnerMath.sumWW_Div(b1.height(i), b1.sumWW(i), b2.height(i), b2.sumWW(i));
                ep = BinnerMath.errorDiv(b1.plusError(i), b1.height(i), b2.plusError(i), b2.height(i));
                em = BinnerMath.errorDiv(b1.minusError(i), b1.height(i), b2.minusError(i), b2.height(i));
            }
            newBinner.setBinContent(i, b1.binCenter(i), e, h, ep, em, sumWW, sumXW, sumXXW);
        }
    }

    public static boolean isValidDouble(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        return !Double.isInfinite(d);
    }

    static void checkCompatibility(Binner1D binner1, Binner1D binner2) throws IllegalArgumentException {
        if (binner1.bins() != binner2.bins()) {
            String message = "Different number of bins: n1=" + binner1.bins() + ", n2=" + binner2.bins();
            throw new IllegalArgumentException(message);
        }
    }

    private static double errorMul(double e1, double l1, double e2, double l2) {
        return Math.sqrt(Math.pow(e1 * l2, 2.0) + Math.pow(l1 * e2, 2.0));
    }

    private static double sumWW_Mul(double h1, double sumWW1, double h2, double sumWW2) {
        return sumWW1 * h2 * h2 + sumWW2 * h1 * h1;
    }

    private static double errorDiv(double e1, double l1, double e2, double l2) {
        return Math.sqrt(Math.pow(e1 / l2, 2.0) + Math.pow(e2 * l1 / (l2 * l2), 2.0));
    }

    private static double sumWW_Div(double h1, double sumWW1, double h2, double sumWW2) {
        return (sumWW1 + sumWW2 * Math.pow(h1 / h2, 2.0)) / (h2 * h2);
    }
}

