/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;
import org.lsst.ccs.subsystem.power.ui.QuadBoxControlPanel;

@Plugin(name="Quadbox Control Plugin", description="Quadbox Control Plugin")
public class QuadBoxControlPlugin
extends ConsolePlugin {
    public void initialize() {
        MonOptionalPage optPage = new MonOptionalPage("quadBoxAgent", QuadBoxControl.class, null, true, new String[]{"QuadBoxState"});
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    public static class QuadBoxControl
    extends ControlPanel
    implements StatusMessageListener {
        private QuadBoxControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("QuadBoxState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(String agent) {
            this.ctrlPanel = new QuadBoxControlPanel(agent);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.ctrlPanel.initPanel();
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updatePanel((QuadBoxState)obj);
        }

        public void disableControlPanel() {
            this.ctrlPanel.disablePanel();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

